/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.action;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.Activator;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.messages.Messages;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.action.AbstractCDOContextAction;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.action.CDOResourceEditorInput;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextEditAction;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class CDOContextEditAction
extends AbstractCDOContextAction
implements IContextEditAction {
    public String getToolTip() {
        return Messages.CDOContextEditAction_0;
    }

    public void openEditor(Context context, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CDOContextEditAction_1, (Object)context.getName()), (int)-1);
        CDOTransaction transaction = this.createTransaction((EObject)context);
        try {
            IEditorPart editor = this.openEditor(this.getDoppelganger(context, (CDOView)transaction));
            if (editor != null) {
                this.hookCloseListener(editor, (CDOView)transaction);
                this.hookSaveListener(editor, transaction);
            } else {
                transaction.close();
            }
        }
        finally {
            sub.done();
        }
    }

    protected IEditorPart openEditor(Context context) throws CoreException {
        CDOResourceEditorInput input;
        IEditorPart result = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart existing = page.findEditor((IEditorInput)(input = new CDOResourceEditorInput(context.eResource(), context.getName())));
        if (existing == null) {
            result = page.openEditor((IEditorInput)input, "org.eclipse.papyrus.customization.properties.UIEditor", true);
        }
        return result;
    }

    private void hookCloseListener(final IEditorPart editor, final CDOView view) {
        final IWorkbenchPage page = editor.getSite().getPage();
        page.addPartListener(new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                if (part == editor) {
                    try {
                        view.close();
                    }
                    finally {
                        page.removePartListener((IPartListener)this);
                    }
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    private void hookSaveListener(final IEditorPart editor, final CDOTransaction transaction) {
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int property) {
                if (property == 257 && !editor.isDirty()) {
                    try {
                        transaction.commit();
                    }
                    catch (CommitException e) {
                        Activator.log.error((Throwable)e);
                        StatusAdapter adapter = new StatusAdapter((IStatus)new Status(4, "org.eclipse.papyrus.cdo.ui.customization.properties", Messages.CDOContextEditAction_2, (Throwable)e));
                        adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.CDOContextEditAction_3);
                        adapter.setProperty(IStatusAdapterConstants.EXPLANATION_PROPERTY, (Object)Messages.CDOContextEditAction_4);
                        StatusManager.getManager().handle(adapter, 2);
                    }
                }
            }
        });
    }
}

