/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dialogs;

import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.wizards.CheckoutSelectionBlock;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CheckoutSelectionDialog
extends TitleAreaDialog {
    private static final String TITLE = Messages.CheckoutSelectionDialog_0;
    private final Supplier<? extends IRunnableContext> runnableContext;
    private final EventBus bus;
    private final CDOCheckout initialSelection;
    private CDOCheckout selectedCheckout;
    private CheckoutSelectionBlock checkoutSelectionBlock;

    public CheckoutSelectionDialog(Shell parentShell, CDOCheckout initialSelection, Supplier<? extends IRunnableContext> runnableContext) {
        super(parentShell);
        this.runnableContext = runnableContext;
        this.bus = new EventBus("repositorySelectionDialog");
        this.initialSelection = initialSelection;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x20);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setMessage(Messages.CheckoutSelectionDialog_1);
        Composite result = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(result, 0);
        main.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        this.checkoutSelectionBlock = new CheckoutSelectionBlock(this.bus, this.runnableContext);
        this.checkoutSelectionBlock.createControl(main);
        this.bus.register((Object)this);
        this.checkoutSelectionBlock.setSelectedCheckout(this.initialSelection);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setSelectedCheckout(this.initialSelection);
    }

    public CDOCheckout getSelectedRepository() {
        return this.selectedCheckout;
    }

    @Subscribe
    public void setSelectedCheckout(CDOCheckout checkout) {
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(checkout != null);
        }
    }

    protected void okPressed() {
        this.selectedCheckout = this.checkoutSelectionBlock.getSelectedCheckout();
        super.okPressed();
    }
}

