/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.gmf.editors.impl.DawnGMFEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.notifications.impl.DawnGMFHandler;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusGMFEditorSupport;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;

public class PapyrusGMFHandler
extends DawnGMFHandler {
    public PapyrusGMFHandler(IDawnEditor editor) {
        super(editor);
    }

    public void attachingObject(CDOTransaction transaction, CDOObject object) {
    }

    public void handleViewInvalidationEvent(CDOViewInvalidationEvent event) {
        CDOViewInvalidationEvent filtered;
        if (UIUtil.ensureUIThread((Object)this, event) && (filtered = this.filter(event)) != null) {
            super.handleViewInvalidationEvent(filtered);
        }
    }

    public void handleTransactionConflictEvent(CDOTransactionConflictEvent event) {
        CDOTransactionConflictEvent filtered;
        if (UIUtil.ensureUIThread((Object)this, event) && (filtered = this.filter(event)) != null) {
            super.handleTransactionConflictEvent(filtered);
        }
    }

    protected CDOViewInvalidationEvent filter(final CDOViewInvalidationEvent event) {
        Object result = event;
        boolean filtered = false;
        final HashSet dirty = Sets.newHashSet((Iterable)event.getDirtyObjects());
        final HashSet detached = Sets.newHashSet((Iterable)event.getDetachedObjects());
        final HashMap deltas = Maps.newHashMap((Map)event.getRevisionDeltas());
        filtered = this.filter(dirty) || filtered;
        filtered = this.filter(detached) || filtered;
        boolean bl = filtered = this.filter(deltas.keySet()) || filtered;
        if (filtered) {
            result = dirty.isEmpty() && detached.isEmpty() && deltas.isEmpty() ? null : new CDOViewInvalidationEvent(){

                public CDOView getSource() {
                    return event.getSource();
                }

                public long getTimeStamp() {
                    return event.getTimeStamp();
                }

                public Map<CDOObject, CDORevisionDelta> getRevisionDeltas() {
                    return deltas;
                }

                public Set<CDOObject> getDirtyObjects() {
                    return dirty;
                }

                public Set<CDOObject> getDetachedObjects() {
                    return detached;
                }
            };
        }
        return result;
    }

    protected boolean filter(Collection<?> objects) {
        return PapyrusGMFEditorSupport.filter(objects, DawnGMFEditorSupport.getDiagramEditor((IDawnEditor)this.editor));
    }

    protected CDOTransactionConflictEvent filter(CDOTransactionConflictEvent event) {
        CDOObject cdoObject = event.getConflictingObject();
        EObject element = CDOUtil.getEObject((EObject)cdoObject);
        DiagramDocumentEditor diagramEditor = DawnGMFEditorSupport.getDiagramEditor((IDawnEditor)this.editor);
        View view = PapyrusGMFEditorSupport.findView(diagramEditor, element);
        return view == null ? null : event;
    }

    public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
        if (object instanceof Resource) {
            return;
        }
        RefreshAdapter.refreshLater((Notifier)object, this.editor);
    }

    public void handleEvent(IEvent event) {
        try {
            super.handleEvent(event);
        }
        finally {
            if (CDOUtils.removeListenerFromDeactivatedLifecycle((IListener)this, (IEvent)event) && event.getSource() instanceof CDOTransaction) {
                ((CDOTransaction)event.getSource()).removeTransactionHandler((CDOTransactionHandlerBase)this);
            }
        }
    }

    private static final class RefreshAdapter
    extends AdapterImpl
    implements Runnable {
        private static Object TYPE = new Object();
        private static final ConcurrentMap<IDawnEditor, Runnable> pending = new ConcurrentHashMap<IDawnEditor, Runnable>();
        private final IDawnEditor editor;

        RefreshAdapter(IDawnEditor editor) {
            this.editor = editor;
        }

        static void refreshLater(Notifier notifier, IDawnEditor editor) {
            if (EcoreUtil.getExistingAdapter((Notifier)notifier, (Object)TYPE) == null) {
                notifier.eAdapters().add((Object)new RefreshAdapter(editor));
            }
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() != 8) {
                this.post();
                this.getTarget().eAdapters().remove((Object)this);
            }
        }

        private void post() {
            if (pending.putIfAbsent(this.editor, this) == null) {
                UIUtil.later(this);
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == TYPE;
        }

        @Override
        public void run() {
            pending.remove(this.editor);
            DiagramDocumentEditor diagramEditor = DawnGMFEditorSupport.getDiagramEditor((IDawnEditor)this.editor);
            if (diagramEditor != null) {
                DawnDiagramUpdater.refreshEditPart((EditPart)diagramEditor.getDiagramEditPart(), (DiagramDocumentEditor)diagramEditor);
            }
        }
    }
}

