/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.cdo.core.importer.IModelImporter;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferOperation;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.wizards.CheckoutSelectionPage;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelMappingsPage;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelReferencesPage;
import org.eclipse.papyrus.cdo.internal.ui.wizards.WizardOperationContext;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.statushandlers.StatusManager;

public class ModelImportWizard
extends Wizard
implements IWorkbenchWizard {
    private ModelReferencesPage referencesPage;
    private CheckoutSelectionPage checkoutPage;
    private ModelMappingsPage mappingsPage;
    private IStructuredSelection selection;
    private IModelTransferConfiguration importConfig;
    private CDOCheckout checkout;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(Messages.ModelImportWizard_0);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void setRepository(CDOCheckout checkout) {
        this.checkout = checkout;
    }

    public void addPages() {
        this.importConfig = IModelTransferConfiguration.Factory.IMPORT.create((IModelTransferOperation.Context)new WizardOperationContext(this.getShell().getDisplay(), this), null);
        final EventBus bus = new EventBus("importWizard");
        this.referencesPage = new ModelReferencesPage(bus, true);
        this.addPage((IWizardPage)this.referencesPage);
        this.checkoutPage = new CheckoutSelectionPage(bus);
        this.addPage((IWizardPage)this.checkoutPage);
        this.mappingsPage = new ModelMappingsPage(bus);
        this.addPage((IWizardPage)this.mappingsPage);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IPapyrusFile next : ModelImportWizard.this.getSelection()) {
                    ModelImportWizard.this.importConfig.addModelToTransfer(URI.createPlatformResourceURI((String)next.getMainFile().getFullPath().toString(), (boolean)true));
                }
                bus.post((Object)ModelImportWizard.this.importConfig);
                if (ModelImportWizard.this.checkout != null) {
                    bus.post((Object)ModelImportWizard.this.checkout);
                }
            }
        });
    }

    Iterable<IPapyrusFile> getSelection() {
        ArrayList result = Lists.newArrayList();
        if (this.selection != null) {
            for (Object next : this.selection.toList()) {
                IPapyrusFile file = null;
                if (next instanceof IPapyrusFile) {
                    file = (IPapyrusFile)next;
                } else if (next instanceof IAdaptable) {
                    file = (IPapyrusFile)((IAdaptable)next).getAdapter(IPapyrusFile.class);
                }
                if (file == null) continue;
                result.add(file);
            }
        }
        return result;
    }

    public boolean performFinish() {
        boolean result = true;
        IModelImporter importer = IModelImporter.Factory.DEFAULT.create();
        Diagnostic problems = importer.importModels(this.mappingsPage.getSelectedMapping());
        if (problems.getSeverity() > 1) {
            StatusManager.getManager().handle(BasicDiagnostic.toIStatus((Diagnostic)problems), 4);
        }
        return result;
    }

    public void dispose() {
        if (this.importConfig != null) {
            final IModelTransferConfiguration configuration = this.importConfig;
            new Job(Messages.ModelImportWizard_2){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    configuration.dispose();
                    return Status.OK_STATUS;
                }
            }.schedule();
            this.importConfig = null;
        }
        super.dispose();
    }
}

