/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.eventbus.EventBus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;

abstract class ModelImportWizardPage
extends WizardPage {
    private final EventBus bus;
    private String message;

    public ModelImportWizardPage(String name, String title, ImageDescriptor image, EventBus bus, String message) {
        super(name, title, image);
        this.bus = bus;
        this.message = message;
        bus.register((Object)this);
        this.setMessage(message);
    }

    void validatePage() {
        this.setMessage(this.mostSevere(this.doValidatePage()));
    }

    protected Diagnostic doValidatePage() {
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic report(int severity, String message) {
        return new BasicDiagnostic(severity, "org.eclipse.papyrus.cdo.ui", 0, message, null);
    }

    Diagnostic mostSevere(Diagnostic diagnostic) {
        Diagnostic result = diagnostic;
        for (Diagnostic next : diagnostic.getChildren()) {
            if (next.getSeverity() != result.getSeverity()) continue;
            result = next;
            break;
        }
        return result;
    }

    void setMessage(Diagnostic diagnostic) {
        String message;
        int messageType;
        switch (diagnostic.getSeverity()) {
            case 0: {
                messageType = 0;
                message = this.message;
                break;
            }
            case 1: {
                messageType = 1;
                message = diagnostic.getMessage();
                break;
            }
            case 2: {
                messageType = 2;
                message = diagnostic.getMessage();
                break;
            }
            case 8: {
                messageType = 1;
                message = diagnostic.getMessage();
                break;
            }
            default: {
                messageType = 3;
                message = diagnostic.getMessage();
            }
        }
        if (diagnostic == Diagnostic.OK_INSTANCE || diagnostic == Diagnostic.CANCEL_INSTANCE) {
            message = this.message;
        }
        this.setMessage(message, messageType);
        this.setPageComplete(diagnostic.getSeverity() < 4);
    }

    protected void post(Object event) {
        this.bus.post(event);
    }

    protected EventBus getEventBus() {
        return this.bus;
    }
}

