/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.providers.ModelImportNodeLabelProvider;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelImportWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModelReferencesPage
extends ModelImportWizardPage {
    private static final String IMPORT_MESSAGE = Messages.ModelReferencesPage_0;
    private static final String EXPORT_MESSAGE = Messages.ModelReferencesPage_1;
    private static final Object[] NO_OBJECTS = new Object[0];
    private final boolean isImport;
    private IModelTransferConfiguration importConfig;
    private TreeViewer modelsTree;
    private Text pathText;
    private Button stripSashModelContent;

    public ModelReferencesPage(EventBus bus, boolean isImport) {
        super("references", Messages.ModelReferencesPage_3, null, bus, isImport ? IMPORT_MESSAGE : EXPORT_MESSAGE);
        this.isImport = isImport;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(1, false));
        new Label(result, 0).setText(Messages.ModelReferencesPage_4);
        ModelImportContentProvider contents = new ModelImportContentProvider();
        this.modelsTree = new CheckboxTreeViewer(result);
        this.modelsTree.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.modelsTree.setAutoExpandLevel(2);
        this.modelsTree.setContentProvider((IContentProvider)contents);
        this.modelsTree.setLabelProvider((IBaseLabelProvider)new TreeNodeLabelProvider());
        new Label(result, 0).setText(Messages.ModelReferencesPage_5);
        this.pathText = new Text(result, 2122);
        this.pathText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(-1, this.convertHeightInCharsToPixels(3)).create());
        if (this.isImport) {
            this.stripSashModelContent = new Button(result, 32);
            this.stripSashModelContent.setText(Messages.ModelReferencesPage_2);
            this.stripSashModelContent.setToolTipText(Messages.ModelReferencesPage_6);
            this.stripSashModelContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ModelReferencesPage.this.getConfiguration() != null) {
                        ModelReferencesPage.this.getConfiguration().setStripSashModelContent(ModelReferencesPage.this.stripSashModelContent.getSelection());
                    }
                }
            });
        }
        this.modelsTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    ModelReferencesPage.this.selected(sel.getFirstElement());
                } else {
                    ModelReferencesPage.this.selected(null);
                }
            }
        });
        ((ICheckable)this.modelsTree).addCheckStateListener((ICheckStateListener)contents);
        ((ICheckable)this.modelsTree).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelReferencesPage.this.validatePage();
                    }
                });
            }
        });
        this.setControl((Control)result);
        this.validatePage();
    }

    public IModelTransferConfiguration getConfiguration() {
        return this.importConfig;
    }

    @Subscribe
    public void setConfiguration(IModelTransferConfiguration configuration) {
        if (configuration != this.importConfig) {
            if (this.importConfig != null) {
                this.importConfig.dispose();
            }
            this.importConfig = configuration;
        }
        this.modelsTree.setInput((Object)configuration);
        if (configuration != null) {
            this.initializeCheckedNodes();
            if (this.stripSashModelContent != null) {
                this.stripSashModelContent.setSelection(true);
                this.stripSashModelContent.setEnabled(configuration.hasSashModelContent());
                this.importConfig.setStripSashModelContent(true);
            }
        } else if (this.stripSashModelContent != null) {
            this.stripSashModelContent.setSelection(true);
            this.stripSashModelContent.setEnabled(false);
        }
        this.validatePage();
    }

    public void dispose() {
        this.importConfig = null;
        super.dispose();
    }

    private void initializeCheckedNodes() {
        Collection initialSet = this.importConfig.getModelsToTransfer();
        ITreeContentProvider contents = (ITreeContentProvider)this.modelsTree.getContentProvider();
        ICheckable checkable = (ICheckable)this.modelsTree;
        HashSet visited = Sets.newHashSet();
        ArrayDeque<Object> queue = new ArrayDeque<Object>(Arrays.asList(contents.getElements((Object)this.importConfig)));
        Object next = queue.poll();
        while (next != null) {
            ITreeNode parent = (ITreeNode)next;
            boolean mustCheck = initialSet.contains(parent.getElement());
            if (mustCheck) {
                checkable.setChecked(next, true);
            }
            if (visited.add(parent.getElement())) {
                Object[] objectArray = contents.getChildren(next);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    ITreeNode treeNode = (ITreeNode)child;
                    queue.add(treeNode);
                    boolean bl = !initialSet.contains(treeNode.getElement()) && (this.isImport ? !treeNode.isDependent() : !treeNode.isDependency()) && (!checkable.getChecked((Object)parent) || !parent.getElement().isModelSubUnit(treeNode.getElement())) ? false : (mustCheck = true);
                    if (mustCheck) {
                        checkable.setChecked(child, true);
                        this.importConfig.addModelToTransfer(treeNode.getElement().getPrimaryResourceURI());
                    }
                    ++n2;
                }
            }
            next = queue.poll();
        }
    }

    void selected(Object treeNode) {
        if (treeNode == null) {
            this.pathText.setText("");
        } else {
            IModelTransferNode node = ((ITreeNode)treeNode).getElement();
            this.pathText.setText(node.getName());
        }
    }

    @Override
    protected Diagnostic doValidatePage() {
        Diagnostic result = Diagnostic.CANCEL_INSTANCE;
        if (this.importConfig != null) {
            result = this.importConfig.getModelsToTransfer().isEmpty() ? this.report(8, NLS.bind((String)Messages.ModelReferencesPage_7, (Object)(this.isImport ? Messages.ModelReferencesPage_8 : Messages.ModelReferencesPage_9))) : this.importConfig.validate();
        }
        return result;
    }

    static interface ITreeNode {
        public IModelTransferNode getElement();

        public boolean isDependent();

        public boolean isDependency();
    }

    private class ModelImportContentProvider
    implements ITreeContentProvider,
    ICheckStateListener {
        private final Multimap<IModelTransferNode, TreeNode> nodes = HashMultimap.create();
        private IModelTransferConfiguration config;
        private Object[] elements;
        private Viewer viewer;

        private ModelImportContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.nodes.clear();
            this.elements = null;
            this.config = (IModelTransferConfiguration)newInput;
            this.viewer = viewer;
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = this.elements;
            if (inputElement != this.config || result == null) {
                IModelTransferConfiguration inputConfig = (IModelTransferConfiguration)inputElement;
                ArrayList nodes = Lists.newArrayListWithCapacity((int)inputConfig.getModelsToTransfer().size());
                for (IModelTransferNode next : inputConfig.getModelsToTransfer()) {
                    nodes.add(new TreeNode(next));
                }
                result = nodes.toArray();
                if (inputConfig == this.config) {
                    this.elements = result;
                }
            }
            return result;
        }

        public boolean hasChildren(Object element) {
            IModelTransferNode importNode = ((TreeNode)element).getElement();
            return !importNode.getDependencies().isEmpty() || !importNode.getDependents().isEmpty();
        }

        public Object getParent(Object element) {
            return ((TreeNode)element).getParent();
        }

        public Object[] getChildren(Object parentElement) {
            return ((TreeNode)parentElement).getChildren();
        }

        public void dispose() {
            this.nodes.clear();
            this.elements = null;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            ITreeNode node = (ITreeNode)event.getElement();
            IModelTransferNode model = node.getElement();
            if (event.getChecked()) {
                this.config.addModelToTransfer(model.getPrimaryResourceURI());
            } else {
                this.config.removeModelToTransfer(model);
            }
            for (ITreeNode next : this.nodes.get((Object)model)) {
                event.getCheckable().setChecked((Object)next, event.getChecked());
            }
        }

        private class TreeNode
        implements ITreeNode {
            private final IModelTransferNode element;
            private final TreeNode parent;
            private List<TreeNode> children;
            private final boolean dependent;

            TreeNode(IModelTransferNode element) {
                this(null, element, false);
            }

            TreeNode(TreeNode parent, IModelTransferNode element, boolean dependent) {
                this.parent = parent;
                this.element = element;
                this.dependent = dependent;
                ModelImportContentProvider.this.nodes.put((Object)element, (Object)this);
            }

            @Override
            public IModelTransferNode getElement() {
                return this.element;
            }

            @Override
            public boolean isDependent() {
                return this.getParent() != null && this.dependent;
            }

            @Override
            public boolean isDependency() {
                return this.getParent() != null && !this.dependent;
            }

            Object getParent() {
                return this.parent;
            }

            Object[] getChildren() {
                if (this.children == null) {
                    this.createChildren();
                }
                return this.children == null ? NO_OBJECTS : this.children.toArray();
            }

            void createChildren() {
                Collection dependencies = this.element.getDependencies();
                Collection dependents = this.element.getDependents();
                if (!dependencies.isEmpty() || !dependents.isEmpty()) {
                    this.children = Lists.newArrayListWithCapacity((int)(dependencies.size() + dependents.size()));
                    for (IModelTransferNode next : ModelReferencesPage.this.isImport ? dependents : dependencies) {
                        this.children.add(new TreeNode(this, next, ModelReferencesPage.this.isImport));
                    }
                    for (IModelTransferNode next : ModelReferencesPage.this.isImport ? dependencies : dependents) {
                        if (!(ModelReferencesPage.this.isImport ? !dependents.contains(next) : !dependencies.contains(next))) continue;
                        this.children.add(new TreeNode(this, next, false));
                    }
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ModelImportContentProvider.this.config != null) {
                                Collection imported = ModelImportContentProvider.this.config.getModelsToTransfer();
                                ICheckable checkable = (ICheckable)ModelImportContentProvider.this.viewer;
                                for (ITreeNode next : TreeNode.this.children) {
                                    if (!imported.contains(next.getElement())) continue;
                                    checkable.setChecked((Object)next, true);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private static class TreeNodeLabelProvider
    extends ModelImportNodeLabelProvider {
        private final ResourceManager images = new DeviceResourceManager((Device)Display.getCurrent());

        private TreeNodeLabelProvider() {
        }

        @Override
        public Image getImage(Object element) {
            ITreeNode treeNode = (ITreeNode)element;
            Image result = super.getImage(element);
            if (result != null && treeNode.isDependent()) {
                result = (Image)this.images.get((DeviceResourceDescriptor)new DecorationOverlayIcon(result, Activator.getIcon("dependent_ovr16"), 1));
            }
            return result;
        }

        @Override
        public void dispose() {
            this.images.dispose();
        }

        @Override
        protected IModelTransferNode getModelImportNode(Object element) {
            return ((ITreeNode)element).getElement();
        }
    }
}

