/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.util;

import java.util.ArrayList;
import java.util.List;

public class TriggeredEventTraces<E> {
    public List<TriggeredEvent> traces = new ArrayList<TriggeredEvent>();

    public void clear() {
        this.traces.clear();
    }

    public void addTrace(String name, E notification) {
        this.traces.add(new TriggeredEvent(name, notification));
    }

    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        for (TriggeredEvent event : this.traces) {
            if (!name.equals(event.name)) continue;
            return true;
        }
        return false;
    }

    public TriggeredEvent getFirstEvent(String name) {
        if (name == null) {
            return null;
        }
        for (TriggeredEvent event : this.traces) {
            if (!name.equals(event.name)) continue;
            return event;
        }
        return null;
    }

    public int size() {
        return this.traces.size();
    }

    public TriggeredEvent get(int index) {
        return this.traces.get(index);
    }

    public class TriggeredEvent {
        public String name;
        public E notifier;
        public Object object;

        public TriggeredEvent(String name, E notifier) {
            this.name = name;
            this.notifier = notifier;
        }

        public TriggeredEvent(String name, E notifier, Object object) {
            this.name = name;
            this.notifier = notifier;
            this.object = object;
        }
    }
}

