/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.assistant.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.requirements.common.Utils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class PapyrusReqSysMLRequirementCreateCommand
extends RecordingCommand {
    protected Element selectedElement;

    public PapyrusReqSysMLRequirementCreateCommand(TransactionalEditingDomain domain, Element selectedElements) {
        super(domain, "PapyrusReqSysMLRequirementCreateCommand");
        this.selectedElement = selectedElements;
    }

    protected void createRequirement(Package owner, String id, String text) {
        Class requirement = owner.createOwnedClass(id, false);
        Stereotype reqStereotype = requirement.getApplicableStereotype("SysML::Requirements::Requirement");
        requirement.applyStereotype(reqStereotype);
        requirement.setValue(reqStereotype, "text", (Object)text);
        requirement.setValue(reqStereotype, "id", (Object)id);
    }

    protected void doExecute() {
        if (this.selectedElement.getNearestPackage() != null) {
            Package owner = this.selectedElement.getNearestPackage();
            String id = Utils.getNewRequirementID((Element)owner);
            this.createRequirement(owner, id, "");
        }
    }
}

