/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.commit;

import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.papyrus.uml.alf.libraries.helper.BackupState;
import org.eclipse.papyrus.uml.alf.transaction.commit.ChangeScenario;
import org.eclipse.papyrus.uml.alf.transaction.job.SaveTextualRepresentationJob;
import org.eclipse.uml2.uml.NamedElement;

public class SaveScenario
extends ChangeScenario {
    private boolean isBackupRequired = true;

    @Override
    public void before() {
        super.before();
        if (!this.userModelState.isDifferent(this.currentModelState)) {
            this.userModelState.rebase(this.currentModelState);
        } else {
            BackupState editionState = new BackupState();
            editionState.status = BackupState.EditionStatus.SAVED;
            editionState.timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
            this.userModelState.setEditionState(editionState);
        }
        this.modelStateToBeCommitted = this.userModelState;
    }

    @Override
    public void execute(NamedElement target, String lastEditedVersion) {
        this.init(target);
        if (!this.userModelState.getContent().equals(lastEditedVersion)) {
            this.userModelState.setText(lastEditedVersion);
        }
        this.before();
        if (this.isBackupRequired) {
            SaveTextualRepresentationJob job = new SaveTextualRepresentationJob(this.modelStateToBeCommitted);
            job.setPriority(20);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    SaveScenario.this.after();
                }
            });
            job.schedule();
        } else {
            this.isBackupRequired = true;
        }
    }

    @Override
    public void after() {
    }
}

