/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.job;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.alf.MappingError;
import org.eclipse.papyrus.uml.alf.ParsingError;
import org.eclipse.papyrus.uml.alf.libraries.helper.AlfUtil;
import org.eclipse.papyrus.uml.alf.text.generation.DefaultEditStringRetrievalStrategy;
import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.transaction.commands.AlfCommand;
import org.eclipse.papyrus.uml.alf.transaction.commands.AlfCommandFactory;
import org.eclipse.papyrus.uml.alf.transaction.job.AlfAbstractJob;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Element;

public class AlfCompilationJob
extends AlfAbstractJob {
    public static final String NAME = "Compile";
    private List<AlfCommand> executedCommands;

    public AlfCompilationJob(AlfTextualRepresentation representation) {
        super(NAME, representation);
        this.setUser(true);
        this.executedCommands = new ArrayList<AlfCommand>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Propagate Alf specification into the model", 4);
        this.executedCommands.clear();
        IStatus jobStatus = Status.OK_STATUS;
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            monitor.subTask("Prepare compilation");
            Resource resource = this.modelElementState.getOwner().eResource();
            monitor.worked(1);
            Resource resource2 = resource;
            synchronized (resource2) {
                resource.setTrackingModification(false);
                jobStatus = this.doCompilation(domain, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!jobStatus.equals(Status.OK_STATUS)) {
                    return jobStatus;
                }
                jobStatus = this.doSave(domain, monitor);
                resource.setTrackingModification(true);
            }
        }
        monitor.done();
        return jobStatus;
    }

    protected IStatus doCompilation(TransactionalEditingDomain domain, IProgressMonitor monitor) {
        monitor.subTask("Compiling");
        try {
            AlfCommand command = AlfCommandFactory.getInstance().createCompilationCommand(this.modelElementState);
            domain.getCommandStack().execute((Command)command);
            this.executedCommands.add(command);
        }
        catch (WrappedException we) {
            Exception e = we.exception();
            if (e instanceof ParsingError) {
                return new Status(4, "org.eclipse.papyrus.uml.alf.transaction", "The parsed specification is not valid");
            }
            if (e instanceof MappingError) {
                return new Status(4, "org.eclipse.papyrus.uml.alf.transaction", "It was not possible to map the specification into UML");
            }
            return new Status(4, "org.eclipse.papyrus.uml.alf.transaction", "An unexpected error stopped the compilation phase");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.papyrus.uml.alf.transaction", "An unexpected error stopped the compilation phase");
        }
        monitor.worked(1);
        return Status.OK_STATUS;
    }

    protected IStatus doSave(TransactionalEditingDomain domain, IProgressMonitor monitor) {
        if (!(this.modelElementState.getOwner() instanceof Activity)) {
            monitor.subTask("Format specification");
            this.modelElementState.setText(new DefaultEditStringRetrievalStrategy().getGeneratedEditString((Element)this.modelElementState.getOwner()));
            monitor.worked(1);
        }
        try {
            if (this.modelElementState.getSource() == null) {
                this.modelElementState.setSource(AlfUtil.getInstance().getTextualRepresentationComment((Element)this.modelElementState.getOwner()));
            }
            monitor.subTask("Save specification");
            AlfCommand command = AlfCommandFactory.getInstance().creatSaveCommand(this.modelElementState);
            domain.getCommandStack().execute((Command)command);
            this.executedCommands.add(command);
            monitor.worked(1);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.papyrus.uml.alf.transaction", "An unexpected error stopped the compilation phase");
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        super.canceling();
    }
}

