/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.handlers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.uml.export.dialog.ExportProfilesParametersDialog;
import org.eclipse.papyrus.uml.export.dialog.ProfilesToExportSelectionDialog;
import org.eclipse.papyrus.uml.export.messages.Messages;
import org.eclipse.papyrus.uml.export.util.BuildProperties;
import org.eclipse.papyrus.uml.export.util.ExportProfilesUserParameters;
import org.eclipse.papyrus.uml.export.util.ImportedLibrary;
import org.eclipse.papyrus.uml.export.util.InstalledProfileURI;
import org.eclipse.papyrus.uml.export.util.PluginExportUtil;
import org.eclipse.papyrus.uml.export.util.ProfileUtil;
import org.eclipse.papyrus.uml.export.util.WSFileUtil;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.xml.sax.SAXException;

public class ExportProfilesCommand
extends AbstractTransactionalCommand {
    private String resourcesFolderName = Messages.ExportProfilesCommand_0;
    String pluginProvider = Messages.ExportProfilesCommand_1;
    String pluginToInstallName = Messages.ExportProfilesCommand_2;
    String pluginVersion = Messages.ExportProfilesCommand_3;
    String execEnvironment = Messages.ExportProfilesCommand_4;

    public ExportProfilesCommand(TransactionalEditingDomain domain, String label, List affectedFiles) {
        super(domain, label, affectedFiles);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block10: {
            try {
                UmlModel openedModel = (UmlModel)((ModelSet)this.getEditingDomain().getResourceSet()).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                if (openedModel != null) {
                    EObject root = openedModel.lookupRoot();
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ProfilesToExportSelectionDialog dialog = new ProfilesToExportSelectionDialog(shell, true, ProfileUtil.getAppliedProfilesFromWS(root), Messages.ExportProfilesCommand_6);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        Object[] profiles = dialog.getResult();
                        int i = 0;
                        while (i < profiles.length) {
                            this.pluginToInstallName = String.valueOf(this.pluginToInstallName) + ((Profile)profiles[i]).getName();
                            ++i;
                        }
                        ExportProfilesParametersDialog paramDialog = new ExportProfilesParametersDialog(DisplayUtils.getDefaultShell(), this.pluginToInstallName, this.pluginProvider, this.pluginVersion, this.execEnvironment, dialog.getResult());
                        if (paramDialog.open() == 0) {
                            ExportProfilesUserParameters param = new ExportProfilesUserParameters(paramDialog.getPluginName(), paramDialog.getPluginProvider(), paramDialog.getPluginVersion(), paramDialog.getPluginExecEnvironment());
                            this.exportProfiles(shell, dialog.getResult(), param, paramDialog.getProfilesIcons());
                            return CommandResult.newOKCommandResult();
                        }
                    }
                    break block10;
                }
                return CommandResult.newErrorCommandResult((String)Messages.ExportProfilesCommand_7);
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return CommandResult.newErrorCommandResult((String)Messages.ExportProfilesCommand_8);
    }

    protected void exportProfiles(final Shell shell, final Object[] appliedProfilesFromWS, final ExportProfilesUserParameters param, final String[] profilesIcons) throws ParserConfigurationException, SAXException, IOException, CoreException {
        ProgressMonitorDialog monitordialog = new ProgressMonitorDialog(shell);
        try {
            monitordialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String profilesConcatName = "";
                    int i = 0;
                    while (i < appliedProfilesFromWS.length) {
                        profilesConcatName = String.valueOf(profilesConcatName) + ((Profile)appliedProfilesFromWS[i]).getName();
                        ++i;
                    }
                    String localPluginName = param.getPluginName();
                    ArrayList<ImportedLibrary> importedLibrariesFromWS = new ArrayList<ImportedLibrary>();
                    IProject project = null;
                    final PluginExportUtil pluginCreator = new PluginExportUtil();
                    monitor.beginTask(Messages.ExportProfilesCommand_10, 100);
                    monitor.subTask(Messages.ExportProfilesCommand_11);
                    project = pluginCreator.createPlugin(monitor, param.getPluginName(), param.getPluginExecEnvironment(), param.getPluginVersion(), param.getPluginProvider());
                    monitor.worked(1);
                    try {
                        monitor.subTask(Messages.ExportProfilesCommand_12);
                        ManifestEditor editor = new ManifestEditor(project);
                        editor.init();
                        editor.setSingleton(true);
                        editor.addDependency("org.eclipse.papyrus.uml.extensionpoints");
                        editor.addDependency("org.eclipse.emf.ecore");
                        editor.save();
                        int i2 = 0;
                        while (i2 < appliedProfilesFromWS.length) {
                            ModelSet modelset = ServiceUtilsForResource.getInstance().getModelSet((Object)((Profile)appliedProfilesFromWS[i2]).eResource());
                            String umlFileName = WSFileUtil.getFileName((EObject)((Profile)appliedProfilesFromWS[i2]), "uml");
                            Resource umlProfile = modelset.getAssociatedResource((EObject)((Profile)appliedProfilesFromWS[i2]), "uml");
                            EcoreUtil.resolveAll((ResourceSet)modelset);
                            URI umlFilenewURI = URI.createPlatformResourceURI((String)(String.valueOf(localPluginName) + ExportProfilesCommand.this.resourcesFolderName + umlFileName), (boolean)true);
                            URI umlFileoldURI = umlProfile.getURI();
                            umlProfile.setURI(umlFilenewURI);
                            umlProfile.save(null);
                            umlProfile.setURI(umlFileoldURI);
                            umlProfile.save(null);
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            Resource newUmlProfileResource = resourceSet.getResource(umlFilenewURI, true);
                            EcoreUtil.resolveAll((ResourceSet)resourceSet);
                            for (EObject obj : newUmlProfileResource.getContents()) {
                                if (!(obj instanceof Profile)) continue;
                                EList importedPackages = ((Profile)obj).getImportedPackages();
                                for (Package pack : importedPackages) {
                                    if (pack.eResource() == null || !pack.eResource().getURI().isPlatformResource()) continue;
                                    String umlPackageFileName = WSFileUtil.getFileName((EObject)pack, "uml");
                                    URI uri = pack.eResource().getURI();
                                    URI newURI = URI.createPlatformResourceURI((String)(String.valueOf(localPluginName) + ExportProfilesCommand.this.resourcesFolderName + umlPackageFileName), (boolean)true);
                                    pack.eResource().setURI(newURI);
                                    pack.eResource().save(null);
                                    pack.eResource().setURI(URI.createURI((String)("platform:/plugin/" + localPluginName + ExportProfilesCommand.this.resourcesFolderName + umlPackageFileName)));
                                    ((Profile)obj).define();
                                    importedLibrariesFromWS.add(new ImportedLibrary((EObject)pack, "platform:/plugin/" + localPluginName + ExportProfilesCommand.this.resourcesFolderName + umlPackageFileName, uri, pack.getName()));
                                }
                            }
                            newUmlProfileResource.save(null);
                            ++i2;
                        }
                        WorkspacePluginModel model = new WorkspacePluginModel(project.getProject().getFile("plugin.xml"), false);
                        IPluginBase base = model.getPluginBase();
                        IPluginExtension uri_mapping_ext = model.createExtension();
                        base.add(uri_mapping_ext);
                        uri_mapping_ext.setPoint("org.eclipse.emf.ecore.uri_mapping");
                        IPluginElement uri_mapping_elem = model.createElement((IPluginObject)uri_mapping_ext);
                        uri_mapping_ext.add((IPluginObject)uri_mapping_elem);
                        uri_mapping_elem.setName("mapping");
                        uri_mapping_elem.setAttribute("source", "pathmap://EXPORTED_" + profilesConcatName + "PROFILES/");
                        uri_mapping_elem.setAttribute("target", "platform:/plugin/" + localPluginName + ExportProfilesCommand.this.resourcesFolderName);
                        model.setDirty(true);
                        model.save();
                        final ArrayList<InstalledProfileURI> installedProfilesUri = new ArrayList<InstalledProfileURI>();
                        int i1 = 0;
                        while (i1 < appliedProfilesFromWS.length) {
                            IPluginExtension ext = model.createExtension();
                            base.add(ext);
                            ext.setPoint("org.eclipse.papyrus.uml.extensionpoints.UMLProfile");
                            IPluginElement elem = model.createElement((IPluginObject)ext);
                            ext.add((IPluginObject)elem);
                            Profile profile = (Profile)appliedProfilesFromWS[i1];
                            String umlFileName = WSFileUtil.getFileName((EObject)profile, "uml");
                            elem.setName("profile");
                            elem.setAttribute("name", profile.getName());
                            elem.setAttribute("path", "platform:/plugin/" + localPluginName + ExportProfilesCommand.this.resourcesFolderName + umlFileName);
                            elem.setAttribute("description", "UML Profile " + profile.getName());
                            elem.setAttribute("provider", param.getPluginProvider());
                            if (profilesIcons[i1] != null && profilesIcons[i1].length() != 0) {
                                File icon = FileUtil.getFile((String)profilesIcons[i1]);
                                String iconName = ExportProfilesCommand.getFSFileName(icon.getAbsolutePath());
                                elem.setAttribute("iconpath", "icons/" + iconName);
                                WSFileUtil.copyFile(project, icon, "icons/", iconName);
                            }
                            installedProfilesUri.add(new InstalledProfileURI("platform:/plugin/" + localPluginName + ExportProfilesCommand.this.resourcesFolderName + umlFileName, profile.eResource().getURI().toString()));
                            model.setDirty(true);
                            model.save();
                            ++i1;
                        }
                        if (!importedLibrariesFromWS.isEmpty()) {
                            for (ImportedLibrary importedLibrary : importedLibrariesFromWS) {
                                IPluginExtension ext = model.createExtension();
                                base.add(ext);
                                ext.setPoint("org.eclipse.papyrus.uml.extensionpoints.UMLLibrary");
                                IPluginElement elem = model.createElement((IPluginObject)ext);
                                ext.add((IPluginObject)elem);
                                elem.setName("library");
                                elem.setAttribute("name", importedLibrary.getName());
                                elem.setAttribute("path", importedLibrary.getUri());
                                elem.setAttribute("description", "UML Library " + importedLibrary.getName());
                                elem.setAttribute("provider", param.getPluginProvider());
                                model.setDirty(true);
                                model.save();
                            }
                        }
                        project.refreshLocal(2, null);
                        monitor.worked(1);
                        monitor.subTask("Plugin customization: adding build properties to Manifest ...");
                        BuildProperties buildproperties = new BuildProperties(project);
                        buildproperties.addBuildEntry("bin.includes", "META-INF/,.,plugin.xml,build.properties,model/,icons/");
                        monitor.worked(1);
                        monitor.subTask(Messages.ExportProfilesCommand_5);
                        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        final IPluginModel pluginModel = PluginExportUtil.getPluginModelForProject(project);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                pluginCreator.exportProfilePlugin(shell, pluginModel, String.valueOf(root.getLocation().toString()) + "/.metadata/.plugins/org.eclipse.pde.core/install/", installedProfilesUri);
                            }
                        });
                        monitor.worked(1);
                        monitor.done();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public static String getFSFileName(String path) {
        String fileName = path.indexOf("\\") < 0 ? path : path.substring(path.lastIndexOf("\\") + 1, path.length());
        return fileName;
    }
}

