/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.util.ProfileUtil;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Profile;

public class AreThereAppliedProfilesFromWS
extends PropertyTester {
    public static final String ARE_THERE_APPLIED_PROFILES = "AreThereAppliedProfiles";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof IMultiDiagramEditor)) {
            return false;
        }
        Boolean currentValue = null;
        if (ARE_THERE_APPLIED_PROFILES.equals(property)) {
            ServicesRegistry registry = ((IMultiDiagramEditor)editor).getServicesRegistry();
            try {
                UmlModel openedModel = (UmlModel)ServiceUtils.getInstance().getModelSet((Object)registry).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                EObject root = openedModel.lookupRoot();
                Object[] profiles = ProfileUtil.getAppliedProfilesFromWS(root);
                int i = 0;
                while (i < profiles.length) {
                    if (profiles[i] instanceof Profile) {
                        currentValue = true;
                        break;
                    }
                    ++i;
                }
                return currentValue == expectedValue;
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            catch (NotFoundException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return false;
    }
}

