/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter.instructions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.richtext.painter.LinePainter;
import org.eclipse.nebula.widgets.richtext.painter.TagProcessingState;
import org.eclipse.nebula.widgets.richtext.painter.instructions.PaintInstruction;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TextPaintInstruction
implements PaintInstruction {
    private TagProcessingState state;
    private String text;
    private List<String> words = new ArrayList<String>();

    public TextPaintInstruction(TagProcessingState state, String text) {
        this.state = state;
        this.text = text;
        String word = text.trim();
        if (word.length() > 0) {
            String[] splitText;
            String[] stringArray = splitText = word.split("\\s");
            int n = splitText.length;
            int n2 = 0;
            while (n2 < n) {
                String splitWord = stringArray[n2];
                String trimmed = splitWord.trim();
                if (trimmed.length() > 0) {
                    this.words.add(trimmed);
                }
                ++n2;
            }
        }
    }

    @Override
    public void paint(GC gc, Rectangle area) {
        FontMetrics metrics;
        if (!this.state.isRendering()) {
            return;
        }
        FontMetrics metricsToUse = metrics = gc.getFontMetrics();
        int baseline = metrics.getAscent() + metrics.getLeading();
        int yAdvance = 0;
        if (this.state.getCurrentLineHeight() > metrics.getHeight()) {
            int biggerBaseline = this.state.getCurrentBiggestFontMetrics().getAscent() + this.state.getCurrentBiggestFontMetrics().getLeading();
            yAdvance = biggerBaseline - baseline;
            metricsToUse = this.state.getCurrentBiggestFontMetrics();
        }
        Point pointer = this.state.getPointer();
        int textLength = 0;
        if (TagProcessingState.TextAlignment.JUSTIFY.equals((Object)this.state.getTextAlignment())) {
            LinePainter line = this.state.getCurrentLine();
            for (String word : this.words) {
                gc.drawText(word, pointer.x, pointer.y + yAdvance, this.state.hasPreviousBgColor());
                int length = gc.textExtent((String)word).x + line.getNextJustifySpace();
                pointer.x += length;
                textLength += length;
            }
        } else {
            textLength = this.getTextLength(gc);
            gc.drawText(this.text, pointer.x, pointer.y + yAdvance, this.state.hasPreviousBgColor());
        }
        if (this.state.isUnderlineActive()) {
            int underlineY = pointer.y + baseline + yAdvance + metricsToUse.getDescent() / 2;
            gc.drawLine(pointer.x, underlineY, pointer.x + textLength, underlineY);
        }
        if (this.state.isStrikethroughActive()) {
            int strikeY = pointer.y + yAdvance + metrics.getHeight() / 2 + metrics.getLeading() / 2;
            gc.drawLine(pointer.x, strikeY, pointer.x + textLength, strikeY);
        }
        if (!TagProcessingState.TextAlignment.JUSTIFY.equals((Object)this.state.getTextAlignment())) {
            pointer.x += textLength;
        }
    }

    public int getTextLength(GC gc) {
        return gc.textExtent((String)this.text).x;
    }

    public int getTrimmedTextLength(GC gc) {
        int result = 0;
        for (String word : this.words) {
            result += gc.textExtent((String)word).x;
        }
        return result;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getWords() {
        return this.words;
    }
}

