/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.handlers.PolicyDefinedTableHandler;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.common.wizards.CreateNattableFromCatalogWizard;
import org.eclipse.papyrus.infra.nattable.nattableconfiguration.NattableConfigurationRegistry;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusSyncTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateNatTableFromCatalogHandler
extends AbstractHandler {
    private Map<ViewPrototype, Integer> viewPrototypes = null;
    private Map<ViewPrototype, String> tableNames = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final EObject context = this.getSelection().get(0);
        CreateNattableFromCatalogWizard wizard = new CreateNattableFromCatalogWizard(context){

            public void dispose() {
                if (this.getSelectedViewPrototypes() != null && this.getTableNames() != null) {
                    CreateNatTableFromCatalogHandler.this.viewPrototypes = new HashMap<ViewPrototype, Integer>(this.getSelectedViewPrototypes());
                    CreateNatTableFromCatalogHandler.this.tableNames = new HashMap<ViewPrototype, String>(this.getTableNames());
                }
                super.dispose();
            }
        };
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        ServicesRegistry serviceRegistry = null;
        TransactionalEditingDomain domain = null;
        try {
            serviceRegistry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        if (dialog.open() == 0) {
            RecordingCommand rc = new RecordingCommand(domain){

                protected void doExecute() {
                    for (ViewPrototype viewPrototype : CreateNatTableFromCatalogHandler.this.viewPrototypes.keySet()) {
                        if (viewPrototype == null) continue;
                        Integer tablesQuantity = (Integer)CreateNatTableFromCatalogHandler.this.viewPrototypes.get(viewPrototype);
                        String tableConfigName = CreateNatTableFromCatalogHandler.this.tableNames.get(viewPrototype) != null && !((String)CreateNatTableFromCatalogHandler.this.tableNames.get(viewPrototype)).isEmpty() ? (String)CreateNatTableFromCatalogHandler.this.tableNames.get(viewPrototype) : viewPrototype.getLabel();
                        int i = 0;
                        while (i < tablesQuantity) {
                            String tableNameToCreate = 1 < tablesQuantity ? String.valueOf(tableConfigName) + "_" + i : tableConfigName;
                            PolicyDefinedTableHandler handler = new PolicyDefinedTableHandler(CreateNatTableFromCatalogHandler.this.getTableConfigurationURI((TableViewPrototype)viewPrototype), context, tableNameToCreate);
                            handler.execute(viewPrototype);
                            ++i;
                        }
                    }
                    CreateNatTableFromCatalogHandler.this.viewPrototypes = null;
                    CreateNatTableFromCatalogHandler.this.tableNames = null;
                }
            };
            domain.getCommandStack().execute((Command)rc);
        }
        return null;
    }

    private URI getTableConfigurationURI(TableViewPrototype viewPrototype) {
        PapyrusTable papyrusTable;
        String uri;
        if (viewPrototype.getConfiguration() instanceof PapyrusTable && (uri = (papyrusTable = (PapyrusTable)viewPrototype.getConfiguration()).getConfiguration()) != null && uri.length() > 0) {
            return URI.createURI((String)uri);
        }
        if (viewPrototype.getConfiguration() instanceof PapyrusSyncTable) {
            return NattableConfigurationRegistry.INSTANCE.getConfigurationURI(((PapyrusSyncTable)viewPrototype.getConfiguration()).getImplementationID());
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.getSelection().size() == 1);
    }

    protected List<EObject> getSelection() {
        ISelection selection;
        ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null && (selection = ww.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                EObject currentEObject = EMFHelper.getEObject(object);
                if (currentEObject == null) continue;
                selectedElements.add(currentEObject);
            }
        }
        return selectedElements;
    }
}

