/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;

public class RemoveControlResourceCommand
extends AbstractControlResourceCommand {
    private static final String PREVIOUS_RESOURCE_ERROR = Messages.getString("RemoveControlResourceCommand.previous.resource.error");
    private static final String TARGET_RESOURCE_ERROR = Messages.getString("RemoveControlResourceCommand.target.resource.error");
    private static final String RESOURCE_ERROR = Messages.getString("RemoveControlResourceCommand.resource.error");
    private static final String RESOURCESET_ERROR = Messages.getString("RemoveControlResourceCommand.resourceset.error");
    private static final String CONTROL_OBJECT_ERROR = Messages.getString("RemoveControlResourceCommand.object.error");
    private static final String UNCONTROL_COMMAND_TITLE = Messages.getString("RemoveControlResourceCommand.command.title");

    public RemoveControlResourceCommand(ControlModeRequest request) {
        super(request, UNCONTROL_COMMAND_TITLE, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())));
    }

    public RemoveControlResourceCommand(ControlModeRequest request, String fileExtension) {
        super(request, fileExtension, UNCONTROL_COMMAND_TITLE, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Resource targetResource;
        EObject objectToControl = this.getRequest().getTargetObject();
        if (objectToControl == null) {
            return CommandResult.newErrorCommandResult((String)CONTROL_OBJECT_ERROR);
        }
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)RESOURCESET_ERROR);
        }
        Resource resource = modelSet.getResource(this.getSourceUri(), false);
        if (resource == null) {
            return CommandResult.newErrorCommandResult((String)RESOURCE_ERROR);
        }
        if (!this.isControlledResourceLocked(this.getRequest().getSourceURI())) {
            modelSet.getResourcesToDeleteOnSave().add(resource.getURI());
        }
        if ((targetResource = this.getTargetResource(objectToControl)) == null) {
            return CommandResult.newErrorCommandResult((String)Messages.getString(TARGET_RESOURCE_ERROR, this.getFileExtension()));
        }
        targetResource.setModified(true);
        this.getRequest().setTargetResource(targetResource, this.getFileExtension());
        this.getRequest().setSourceResource(resource, this.getFileExtension());
        if (!this.isControlledResourceLocked(this.getRequest().getSourceURI())) {
            modelSet.getResources().remove((Object)resource);
        }
        return CommandResult.newOKCommandResult();
    }

    protected Resource getTargetResource(EObject objectToUncontrol) {
        return this.getRequest().getModelSet().getAssociatedResource(objectToUncontrol, this.getFileExtension(), true);
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus superStatus = super.doUndo(monitor, info);
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)RESOURCESET_ERROR).getStatus();
        }
        Resource resource = this.getRequest().getSourceResource(this.getFileExtension());
        if (resource == null) {
            return CommandResult.newErrorCommandResult((String)RESOURCE_ERROR).getStatus();
        }
        modelSet.getResources().add((Object)resource);
        modelSet.getResourcesToDeleteOnSave().remove(resource.getURI());
        this.getRequest().getTargetResource(this.getFileExtension()).setModified(true);
        return superStatus;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus superStatus = super.doRedo(monitor, info);
        Resource resource = this.getRequest().getSourceResource(this.getFileExtension());
        if (resource == null) {
            return CommandResult.newErrorCommandResult((String)PREVIOUS_RESOURCE_ERROR).getStatus();
        }
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)RESOURCESET_ERROR).getStatus();
        }
        if (!this.isControlledResourceLocked(this.getRequest().getSourceURI())) {
            modelSet.getResources().remove((Object)resource);
            modelSet.getResourcesToDeleteOnSave().add(resource.getURI());
        }
        return superStatus;
    }
}

