/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.impl;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.viewpoints.configuration.Activator;
import org.eclipse.papyrus.infra.viewpoints.configuration.impl.AssistantRuleImpl;

public class AssistantRuleCustomImpl
extends AssistantRuleImpl {
    private static final Pattern IMPOSSIBLE_PATTERN = Pattern.compile("^(?<=x)$");
    private static final Pattern WILDCARD_PATTERN = Pattern.compile(".*");
    private Pattern elementTypeIDPattern;

    protected AssistantRuleCustomImpl() {
    }

    public boolean matches(IElementType elementType) {
        String actualID = elementType.getId();
        return actualID != null && this.getElementTypeIDPattern().matcher(actualID).matches();
    }

    Pattern getElementTypeIDPattern() {
        if (this.elementTypeIDPattern == null) {
            try {
                String elementTypeID = this.getElementTypeID();
                this.elementTypeIDPattern = elementTypeID == null ? WILDCARD_PATTERN : Pattern.compile(AssistantRuleCustomImpl.asRegex(elementTypeID));
            }
            catch (PatternSyntaxException e) {
                Activator.INSTANCE.log(e);
                this.elementTypeIDPattern = IMPOSSIBLE_PATTERN;
            }
        }
        return this.elementTypeIDPattern;
    }

    public void setElementTypeID(String newElementTypeID) {
        this.elementTypeIDPattern = null;
        super.setElementTypeID(newElementTypeID);
    }

    static String asRegex(String elementTypeIDPattern) {
        StringBuilder result = new StringBuilder(elementTypeIDPattern);
        int i = 0;
        while (i < result.length()) {
            char ch = result.charAt(i);
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '?': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    if (AssistantRuleCustomImpl.escaped(result, i)) break;
                    result.insert(i, '\\');
                    ++i;
                    break;
                }
                case '*': {
                    if (AssistantRuleCustomImpl.escaped(result, i)) break;
                    result.insert(i, '.');
                    ++i;
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static boolean escaped(CharSequence chars, int offset) {
        boolean result;
        boolean bl = result = offset > 0 && chars.charAt(offset - 1) == '\\';
        if (result) {
            int i = offset - 2;
            while (i >= 0 && chars.charAt(i) == '\\') {
                result = !result;
                --i;
            }
        }
        return result;
    }
}

