/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.AbstractCallActionPinUpdater;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CallOperationActionPinUpdater
extends AbstractCallActionPinUpdater<CallOperationAction> {
    @Override
    public void updatePins(CallOperationAction node) {
        super.updatePins(node);
        InputPin targetPin = this.deriveTarget(node);
        if (node.getTarget() == null) {
            node.setTarget(targetPin);
        } else {
            CallOperationActionPinUpdater.update((Pin)node.getTarget(), (Pin)targetPin);
        }
    }

    @Override
    public InputPin deriveTarget(CallOperationAction node) {
        InputPin pinTarget = UMLFactory.eINSTANCE.createInputPin();
        pinTarget.setLower(1);
        pinTarget.setUpper(1);
        pinTarget.setName("target");
        if (node.getOperation() != null) {
            pinTarget.setType((Type)node.getOperation().getClass_());
        }
        return pinTarget;
    }

    @Override
    public List<InputPin> deriveArguments(CallOperationAction node) {
        ArrayList<InputPin> derivedInputPins = new ArrayList<InputPin>();
        if (node.getOperation() != null) {
            for (Parameter parameter : node.getOperation().getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL && parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                InputPin derivedPin = UMLFactory.eINSTANCE.createInputPin();
                derivedPin.setType(parameter.getType());
                derivedPin.setLower(parameter.getLower());
                derivedPin.setUpper(parameter.getUpper());
                if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    derivedPin.setName("[in] " + parameter.getName());
                } else {
                    derivedPin.setName(parameter.getName());
                }
                derivedInputPins.add(derivedPin);
            }
        }
        return derivedInputPins;
    }

    @Override
    public List<OutputPin> deriveResults(CallOperationAction node) {
        ArrayList<OutputPin> derivedOutputPins = new ArrayList<OutputPin>();
        if (node.getOperation() != null) {
            for (Parameter parameter : node.getOperation().getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL && parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL && parameter.getDirection() != ParameterDirectionKind.OUT_LITERAL) continue;
                OutputPin derivedPin = UMLFactory.eINSTANCE.createOutputPin();
                derivedPin.setType(parameter.getType());
                derivedPin.setLower(parameter.getLower());
                derivedPin.setUpper(parameter.getUpper());
                if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    derivedPin.setName("[out] " + parameter.getName());
                } else {
                    derivedPin.setName(parameter.getName());
                }
                derivedOutputPins.add(derivedPin);
            }
        }
        return derivedOutputPins;
    }
}

