/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;

public class AssociationUtil {
    public static boolean isAssociationEndProperty(Property property) {
        return property.getAssociation() != null;
    }

    public static boolean isIdenticalProperties(boolean expectedNavigable, AggregationKind expectedAggregation, Property property) {
        return AssociationUtil.isIdenticalAggregations(expectedAggregation, property) && AssociationUtil.isIdenticalNavigables(expectedNavigable, property);
    }

    public static boolean isIdenticalAggregations(AggregationKind expectedAggregation, Property property) {
        boolean identicalAggregation = false;
        AggregationKind aggregation = property.getAggregation();
        if (expectedAggregation.equals((Object)aggregation)) {
            identicalAggregation = true;
        }
        return identicalAggregation;
    }

    public static boolean isIdenticalNavigables(boolean expectedNavigable, Property property) {
        boolean identicalNavigable = false;
        boolean navigable = property.isNavigable();
        if (expectedNavigable == navigable) {
            identicalNavigable = true;
        }
        return identicalNavigable;
    }

    public static Property getSourceFirstEnd(Association association) {
        Property source = null;
        EList memberEnds = association.getMemberEnds();
        if (!memberEnds.isEmpty()) {
            source = (Property)memberEnds.get(0);
        }
        return source;
    }

    public static Property getTargetSecondEnd(Association association) {
        Property target = null;
        EList memberEnds = association.getMemberEnds();
        if (2 <= memberEnds.size()) {
            target = (Property)memberEnds.get(1);
        }
        return target;
    }
}

