/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.part;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.profile/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public String getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public String getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(String visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(String visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static String getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLProfileDiagram".equals(view.getType())) {
                return "Profile_ProfileDiagram";
            }
            return "";
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static String getVisualID(String type) {
        return type;
    }

    public static String getType(String visualID) {
        return visualID;
    }

    public static String getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        return "Profile_ProfileDiagram";
    }

    public static String getNodeVisualID(View containerView, EObject domainElement) {
        String containerVisualID;
        if (domainElement == null) {
            return null;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLProfileDiagram".equals(containerModelID)) {
            return null;
        }
        if ("PapyrusUMLProfileDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = "Profile_ProfileDiagram";
        } else {
            return null;
        }
        switch (containerVisualID) {
            case "Profile_ProfileDiagram": {
                if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
                    return "Dependency_Shape";
                }
                if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
                    return "Association_Shape";
                }
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return "Stereotype_Shape";
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    if (domainElement instanceof Type && Util.isMetaclass((Type)((Type)domainElement))) {
                        return "Class_MetaclassShape";
                    }
                    return "Class_Shape";
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return "Comment_Shape";
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return "Constraint_PackagedElementShape";
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return "Model_Shape";
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return "Profile_Shape";
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return "Package_Shape";
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return "Enumeration_Shape";
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return "PrimitiveType_Shape";
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return "DataType_Shape";
                }
                if (!NotationPackage.eINSTANCE.getDiagram().isSuperTypeOf(domainElement.eClass())) break;
                return "Diagram_ShortcutShape";
            }
            case "Package_Shape_CN": {
                if (!UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) break;
                return "Package_Shape_CN";
            }
            case "Package_PackagedElementCompartment": {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return "Comment_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return "Model_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return "Profile_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return "Package_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return "Constraint_PackagedElementShape_CN";
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return "Enumeration_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return "PrimitiveType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return "DataType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return "Stereotype_Shape_CN";
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return "Class_Shape_CN";
            }
            case "Package_PackagedElementCompartment_CN": {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return "Comment_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return "Model_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return "Profile_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return "Package_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return "Constraint_PackagedElementShape_CN";
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return "Enumeration_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return "PrimitiveType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return "DataType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return "Stereotype_Shape_CN";
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return "Class_Shape_CN";
            }
            case "Profile_PackagedElementCompartment": {
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return "Stereotype_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return "Model_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return "Profile_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return "Package_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return "Constraint_PackagedElementShape_CN";
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return "Enumeration_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return "PrimitiveType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return "DataType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return "Comment_Shape_CN";
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                if (domainElement instanceof Type && Util.isMetaclass((Type)((Type)domainElement))) {
                    return "Class_MetaclassShape_CN";
                }
                return "Class_Shape_CN";
            }
            case "Profile_PackagedElementCompartment_CN": {
                if (UMLPackage.eINSTANCE.getStereotype().isSuperTypeOf(domainElement.eClass())) {
                    return "Stereotype_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return "Model_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return "Profile_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return "Package_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return "Constraint_PackagedElementShape_CN";
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return "Enumeration_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return "PrimitiveType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return "DataType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return "Comment_Shape_CN";
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                if (domainElement instanceof Type && Util.isMetaclass((Type)((Type)domainElement))) {
                    return "Class_MetaclassShape_CN";
                }
                return "Class_Shape_CN";
            }
            case "Stereotype_AttributeCompartment": {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return "Property_ClassAttributeLabel";
            }
            case "Stereotype_AttributeCompartment_CN": {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return "Property_ClassAttributeLabel";
            }
            case "Stereotype_OperationCompartment": {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return "Operation_ClassOperationLabel";
            }
            case "Stereotype_OperationCompartment_CN": {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return "Operation_ClassOperationLabel";
            }
            case "Model_PackagedElementCompartment": {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return "Comment_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return "Model_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return "Profile_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return "Package_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return "Constraint_PackagedElementShape_CN";
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return "Enumeration_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return "PrimitiveType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return "DataType_Shape_CN";
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return "Class_Shape_CN";
            }
            case "Model_PackagedElementCompartment_CN": {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return "Comment_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return "Model_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getProfile().isSuperTypeOf(domainElement.eClass())) {
                    return "Profile_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return "Package_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return "Constraint_PackagedElementShape_CN";
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return "Enumeration_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return "PrimitiveType_Shape_CN";
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return "DataType_Shape_CN";
                }
                if (!UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) break;
                return "Class_Shape_CN";
            }
            case "Enumeration_LiteralCompartment_CN": {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return "EnumerationLiteral_LiteralLabel";
            }
            case "Enumeration_LiteralCompartment": {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return "EnumerationLiteral_LiteralLabel";
            }
            case "DataType_AttributeCompartment": {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return "Property_DataTypeAttributeLabel";
            }
            case "DataType_AttributeCompartment_CN": {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return "Property_DataTypeAttributeLabel";
            }
            case "DataType_OperationCompartment": {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return "Operation_DataTypeOperationLabel";
            }
            case "DataType_OperationCompartment_CN": {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return "Operation_DataTypeOperationLabel";
            }
            case "Class_AttributeCompartment": {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return "Property_ClassAttributeLabel";
            }
            case "Class_AttributeCompartment_CN": {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return "Property_ClassAttributeLabel";
            }
            case "Class_OperationCompartment": {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return "Operation_ClassOperationLabel";
            }
            case "Class_OperationCompartment_CN": {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return "Operation_ClassOperationLabel";
            }
        }
        return null;
    }

    public static boolean canCreateNode(View containerView, String nodeVisualID) {
        block263: {
            String containerVisualID;
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLProfileDiagram".equals(containerModelID)) {
                return false;
            }
            if ("PapyrusUMLProfileDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Profile_ProfileDiagram";
            } else {
                return false;
            }
            if (containerVisualID == null) break block263;
            switch (containerVisualID) {
                case "Profile_ProfileDiagram": {
                    if ("Dependency_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Association_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Stereotype_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Class_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Class_MetaclassShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_PackagedElementShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Profile_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Enumeration_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("PrimitiveType_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Diagram_ShortcutShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Dependency_Shape": {
                    if (!"Dependency_MultiNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Stereotype_Shape": {
                    if ("Stereotype_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Stereotype_AttributeCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Stereotype_OperationCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_Shape": {
                    if ("Class_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Class_OperationCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_AttributeCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_MetaclassShape": {
                    if (!"Class_MetaclassNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape": {
                    if (!"Comment_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_PackagedElementShape": {
                    if ("Constraint_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_Shape": {
                    if ("Model_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Model_PackagedElementCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Profile_Shape": {
                    if ("Profile_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Profile_PackagedElementCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_Shape": {
                    if ("Package_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Package_PackagedElementCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Enumeration_Shape": {
                    if ("Enumeration_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Enumeration_LiteralCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "PrimitiveType_Shape": {
                    if (!"PrimitiveType_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DataType_Shape": {
                    if ("DataType_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_AttributeCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"DataType_OperationCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Diagram_ShortcutShape": {
                    if (!"Diagram_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "PrimitiveType_Shape_CN": {
                    if (!"PrimitiveType_NameLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Stereotype_Shape_CN": {
                    if ("Stereotype_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Stereotype_AttributeCompartment_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Stereotype_OperationCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_Shape_CN": {
                    if ("Class_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Class_AttributeCompartment_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_OperationCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_MetaclassShape_CN": {
                    if (!"Class_MetaclassNameLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape_CN": {
                    if (!"Comment_BodyLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_Shape_CN": {
                    if ("Model_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Model_PackagedElementCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Profile_Shape_CN": {
                    if ("Profile_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Profile_PackagedElementCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_Shape_CN": {
                    if ("Package_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_PackagedElementCompartment_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Package_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_PackagedElementShape_CN": {
                    if ("Constraint_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Enumeration_Shape_CN": {
                    if ("Enumeration_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Enumeration_LiteralCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "DataType_Shape_CN": {
                    if ("DataType_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_AttributeCompartment_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"DataType_OperationCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_PackagedElementCompartment": {
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Profile_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Enumeration_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("PrimitiveType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Stereotype_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_PackagedElementCompartment_CN": {
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Profile_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Enumeration_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("PrimitiveType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Stereotype_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Profile_PackagedElementCompartment": {
                    if ("Stereotype_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Profile_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Enumeration_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("PrimitiveType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Class_MetaclassShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Profile_PackagedElementCompartment_CN": {
                    if ("Stereotype_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Profile_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Enumeration_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("PrimitiveType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Class_MetaclassShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Stereotype_AttributeCompartment": {
                    if (!"Property_ClassAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Stereotype_AttributeCompartment_CN": {
                    if (!"Property_ClassAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Stereotype_OperationCompartment": {
                    if (!"Operation_ClassOperationLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Stereotype_OperationCompartment_CN": {
                    if (!"Operation_ClassOperationLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_PackagedElementCompartment": {
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Profile_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Enumeration_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("PrimitiveType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_PackagedElementCompartment_CN": {
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Profile_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Enumeration_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("PrimitiveType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("DataType_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Class_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Enumeration_LiteralCompartment_CN": {
                    if (!"EnumerationLiteral_LiteralLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Enumeration_LiteralCompartment": {
                    if (!"EnumerationLiteral_LiteralLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DataType_AttributeCompartment": {
                    if (!"Property_DataTypeAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DataType_AttributeCompartment_CN": {
                    if (!"Property_DataTypeAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DataType_OperationCompartment": {
                    if (!"Operation_DataTypeOperationLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "DataType_OperationCompartment_CN": {
                    if (!"Operation_DataTypeOperationLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_AttributeCompartment": {
                    if (!"Property_ClassAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_AttributeCompartment_CN": {
                    if (!"Property_ClassAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_OperationCompartment": {
                    if (!"Operation_ClassOperationLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Class_OperationCompartment_CN": {
                    if (!"Operation_ClassOperationLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Association_Edge": {
                    if ("Association_StereotypeLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Association_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Association_TargetRoleLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Association_SourceRoleLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Association_SourceMultiplicityLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Association_TargetMultiplicityLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Association_BranchEdge": {
                    if ("Association_BranchRoleLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Association_BranchMultiplicityLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Generalization_Edge": {
                    if (!"Generalization_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Dependency_Edge": {
                    if ("Dependency_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Dependency_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "ElementImport_Edge": {
                    if ("ElementImport_AliasLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"ElementImport_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "PackageImport_Edge": {
                    if (!"PackageImport_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_ContextEdge": {
                    if (!"Constraint_KeywordLabel".equals(nodeVisualID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        if (UMLPackage.eINSTANCE.getExtension().isSuperTypeOf(domainElement.eClass())) {
            return "Extension_Edge";
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return "Association_Edge";
        }
        if (UMLPackage.eINSTANCE.getProfileApplication().isSuperTypeOf(domainElement.eClass())) {
            return "ProfileApplication_Edge";
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass())) {
            return "Association_BranchEdge";
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return "Generalization_Edge";
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return "Dependency_Edge";
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return "Dependency_BranchEdge";
        }
        if (UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) {
            return "ElementImport_Edge";
        }
        if (UMLPackage.eINSTANCE.getPackageImport().isSuperTypeOf(domainElement.eClass())) {
            return "PackageImport_Edge";
        }
        return "";
    }

    private static boolean isDiagram(Profile element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
        if (candidate == null) {
            return false;
        }
        String basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return candidate.equals(basic);
    }

    public static boolean isCompartmentVisualID(String visualID) {
        block45: {
            if (visualID == null) break block45;
            switch (visualID) {
                case "Class_AttributeCompartment": 
                case "Stereotype_AttributeCompartment": 
                case "DataType_OperationCompartment_CN": 
                case "Package_PackagedElementCompartment": 
                case "Stereotype_OperationCompartment_CN": 
                case "Class_OperationCompartment": 
                case "Model_PackagedElementCompartment": 
                case "Stereotype_OperationCompartment": 
                case "Model_PackagedElementCompartment_CN": 
                case "Profile_PackagedElementCompartment": 
                case "Class_OperationCompartment_CN": 
                case "Profile_PackagedElementCompartment_CN": 
                case "Package_PackagedElementCompartment_CN": 
                case "DataType_AttributeCompartment": 
                case "Enumeration_LiteralCompartment": 
                case "DataType_AttributeCompartment_CN": 
                case "Enumeration_LiteralCompartment_CN": 
                case "Stereotype_AttributeCompartment_CN": 
                case "DataType_OperationCompartment": 
                case "Class_AttributeCompartment_CN": {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(String visualID) {
        block40: {
            if (visualID == null) break block40;
            switch (visualID) {
                case "Profile_ProfileDiagram": {
                    return false;
                }
                case "Operation_DataTypeOperationLabel": 
                case "Property_DataTypeAttributeLabel": 
                case "Constraint_PackagedElementShape_CN": 
                case "Class_MetaclassShape": 
                case "Dependency_Shape": 
                case "PrimitiveType_Shape_CN": 
                case "Association_Shape": 
                case "Comment_Shape": 
                case "Diagram_ShortcutShape": 
                case "Class_MetaclassShape_CN": 
                case "Property_ClassAttributeLabel": 
                case "EnumerationLiteral_LiteralLabel": 
                case "Comment_Shape_CN": 
                case "Constraint_PackagedElementShape": 
                case "Operation_ClassOperationLabel": 
                case "PrimitiveType_Shape": {
                    return true;
                }
            }
        }
        return false;
    }
}

