/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLParserProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.uml2.uml.ActionExecutionSpecification;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConsiderIgnoreFragment;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Package;

public class UMLNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof UMLNavigatorItem && !this.isOwnView(((UMLNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return UMLDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case "Package_SequenceDiagram": {
                return this.getImage("Navigator?Diagram?http://www.eclipse.org/uml2/5.0.0/UML?Package", UMLElementTypes.Package_SequenceDiagram);
            }
            case "Interaction_Shape": {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/uml2/5.0.0/UML?Interaction", UMLElementTypes.Interaction_Shape);
            }
            case "Lifeline_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?Lifeline", UMLElementTypes.Lifeline_Shape);
            }
            case "InteractionUse_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?InteractionUse", UMLElementTypes.InteractionUse_Shape);
            }
            case "BehaviorExecutionSpecification_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?BehaviorExecutionSpecification", UMLElementTypes.BehaviorExecutionSpecification_Shape);
            }
            case "CombinedFragment_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?CombinedFragment", UMLElementTypes.CombinedFragment_Shape);
            }
            case "InteractionOperand_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?InteractionOperand", UMLElementTypes.InteractionOperand_Shape);
            }
            case "ActionExecutionSpecification_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?ActionExecutionSpecification", UMLElementTypes.ActionExecutionSpecification_Shape);
            }
            case "ConsiderIgnoreFragment_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?ConsiderIgnoreFragment", UMLElementTypes.ConsiderIgnoreFragment_Shape);
            }
            case "Constraint_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?Constraint", UMLElementTypes.Constraint_Shape);
            }
            case "Comment_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?Comment", UMLElementTypes.Comment_Shape);
            }
            case "Continuation_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?Continuation", UMLElementTypes.Continuation_Shape);
            }
            case "StateInvariant_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?StateInvariant", UMLElementTypes.StateInvariant_Shape);
            }
            case "CombinedFragment_CoRegionShape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?CombinedFragment", UMLElementTypes.CombinedFragment_CoRegionShape);
            }
            case "TimeConstraint_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?TimeConstraint", UMLElementTypes.TimeConstraint_Shape);
            }
            case "TimeObservation_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?TimeObservation", UMLElementTypes.TimeObservation_Shape);
            }
            case "DurationConstraint_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?DurationConstraint", UMLElementTypes.DurationConstraint_Shape);
            }
            case "DestructionOccurrenceSpecification_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?DestructionOccurrenceSpecification", UMLElementTypes.DestructionOccurrenceSpecification_Shape);
            }
            case "DurationConstraint_Shape_CN": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?DurationConstraint", UMLElementTypes.DurationConstraint_Shape_CN);
            }
            case "DurationObservation_Shape": {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/5.0.0/UML?DurationObservation", UMLElementTypes.DurationObservation_Shape);
            }
            case "Message_SynchEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Message", UMLElementTypes.Message_SynchEdge);
            }
            case "Message_AsynchEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Message", UMLElementTypes.Message_AsynchEdge);
            }
            case "Message_ReplyEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Message", UMLElementTypes.Message_ReplyEdge);
            }
            case "Message_CreateEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Message", UMLElementTypes.Message_CreateEdge);
            }
            case "Message_DeleteEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Message", UMLElementTypes.Message_DeleteEdge);
            }
            case "Message_LostEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Message", UMLElementTypes.Message_LostEdge);
            }
            case "Message_FoundEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Message", UMLElementTypes.Message_FoundEdge);
            }
            case "Comment_AnnotatedElementEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Comment?annotatedElement", UMLElementTypes.Comment_AnnotatedElementEdge);
            }
            case "Constraint_ConstrainedElementEdge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?Constraint?constrainedElement", UMLElementTypes.Constraint_ConstrainedElementEdge);
            }
            case "GeneralOrdering_Edge": {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/5.0.0/UML?GeneralOrdering", UMLElementTypes.GeneralOrdering_Edge);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = UMLDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && UMLElementTypes.isKnownElementType(elementType)) {
            image = UMLElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case "Package_SequenceDiagram": {
                return this.getPackage_SequenceDiagramText(view);
            }
            case "Interaction_Shape": {
                return this.getInteraction_ShapeText(view);
            }
            case "Lifeline_Shape": {
                return this.getLifeline_ShapeText(view);
            }
            case "InteractionUse_Shape": {
                return this.getInteractionUse_ShapeText(view);
            }
            case "BehaviorExecutionSpecification_Shape": {
                return this.getBehaviorExecutionSpecification_ShapeText(view);
            }
            case "CombinedFragment_Shape": {
                return this.getCombinedFragment_ShapeText(view);
            }
            case "InteractionOperand_Shape": {
                return this.getInteractionOperand_ShapeText(view);
            }
            case "ActionExecutionSpecification_Shape": {
                return this.getActionExecutionSpecification_ShapeText(view);
            }
            case "ConsiderIgnoreFragment_Shape": {
                return this.getConsiderIgnoreFragment_ShapeText(view);
            }
            case "Constraint_Shape": {
                return this.getConstraint_ShapeText(view);
            }
            case "Comment_Shape": {
                return this.getComment_ShapeText(view);
            }
            case "Continuation_Shape": {
                return this.getContinuation_ShapeText(view);
            }
            case "StateInvariant_Shape": {
                return this.getStateInvariant_ShapeText(view);
            }
            case "CombinedFragment_CoRegionShape": {
                return this.getCombinedFragment_CoRegionShapeText(view);
            }
            case "TimeConstraint_Shape": {
                return this.getTimeConstraint_ShapeText(view);
            }
            case "TimeObservation_Shape": {
                return this.getTimeObservation_ShapeText(view);
            }
            case "DurationConstraint_Shape": {
                return this.getDurationConstraint_ShapeText(view);
            }
            case "DestructionOccurrenceSpecification_Shape": {
                return this.getDestructionOccurrenceSpecification_ShapeText(view);
            }
            case "DurationConstraint_Shape_CN": {
                return this.getDurationConstraint_Shape_CNText(view);
            }
            case "DurationObservation_Shape": {
                return this.getDurationObservation_ShapeText(view);
            }
            case "Message_SynchEdge": {
                return this.getMessage_SynchEdgeText(view);
            }
            case "Message_AsynchEdge": {
                return this.getMessage_AsynchEdgeText(view);
            }
            case "Message_ReplyEdge": {
                return this.getMessage_ReplyEdgeText(view);
            }
            case "Message_CreateEdge": {
                return this.getMessage_CreateEdgeText(view);
            }
            case "Message_DeleteEdge": {
                return this.getMessage_DeleteEdgeText(view);
            }
            case "Message_LostEdge": {
                return this.getMessage_LostEdgeText(view);
            }
            case "Message_FoundEdge": {
                return this.getMessage_FoundEdgeText(view);
            }
            case "Comment_AnnotatedElementEdge": {
                return this.getComment_AnnotatedElementEdgeText(view);
            }
            case "Constraint_ConstrainedElementEdge": {
                return this.getConstraint_ConstrainedElementEdgeText(view);
            }
            case "GeneralOrdering_Edge": {
                return this.getGeneralOrdering_EdgeText(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getPackage_SequenceDiagramText(View view) {
        Package domainModelElement = (Package)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = Package_SequenceDiagram");
        return "";
    }

    private String getInteraction_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Interaction_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Interaction_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Interaction_NameLabel");
        return "";
    }

    private String getLifeline_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Lifeline_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Lifeline_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Lifeline_NameLabel");
        return "";
    }

    private String getInteractionUse_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InteractionUse_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("InteractionUse_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label InteractionUse_NameLabel");
        return "";
    }

    private String getBehaviorExecutionSpecification_ShapeText(View view) {
        BehaviorExecutionSpecification domainModelElement = (BehaviorExecutionSpecification)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = BehaviorExecutionSpecification_Shape");
        return "";
    }

    private String getCombinedFragment_ShapeText(View view) {
        CombinedFragment domainModelElement = (CombinedFragment)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = CombinedFragment_Shape");
        return "";
    }

    private String getInteractionOperand_ShapeText(View view) {
        InteractionOperand domainModelElement = (InteractionOperand)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = InteractionOperand_Shape");
        return "";
    }

    private String getActionExecutionSpecification_ShapeText(View view) {
        ActionExecutionSpecification domainModelElement = (ActionExecutionSpecification)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = ActionExecutionSpecification_Shape");
        return "";
    }

    private String getConsiderIgnoreFragment_ShapeText(View view) {
        ConsiderIgnoreFragment domainModelElement = (ConsiderIgnoreFragment)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = ConsiderIgnoreFragment_Shape");
        return "";
    }

    private String getConstraint_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Constraint_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Constraint_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Constraint_NameLabel");
        return "";
    }

    private String getComment_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Comment_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Comment_BodyLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Comment_BodyLabel");
        return "";
    }

    private String getContinuation_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Continuation_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Continuation_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Continuation_NameLabel");
        return "";
    }

    private String getStateInvariant_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.StateInvariant_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("StateInvariant_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label StateInvariant_NameLabel");
        return "";
    }

    private String getCombinedFragment_CoRegionShapeText(View view) {
        CombinedFragment domainModelElement = (CombinedFragment)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = CombinedFragment_CoRegionShape");
        return "";
    }

    private String getTimeConstraint_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.TimeConstraint_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("TimeConstraint_ConstraintLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label TimeConstraint_ConstraintLabel");
        return "";
    }

    private String getTimeObservation_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.TimeObservation_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("TimeObservation_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label TimeObservation_NameLabel");
        return "";
    }

    private String getDurationConstraint_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationConstraint_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("DurationConstraint_BodyLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label DurationConstraint_BodyLabel");
        return "";
    }

    private String getDestructionOccurrenceSpecification_ShapeText(View view) {
        DestructionOccurrenceSpecification domainModelElement = (DestructionOccurrenceSpecification)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = DestructionOccurrenceSpecification_Shape");
        return "";
    }

    private String getDurationConstraint_Shape_CNText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationConstraint_Shape_CN, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("DurationConstraint_BodyLabel_CN"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label DurationConstraint_BodyLabel_CN");
        return "";
    }

    private String getDurationObservation_ShapeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationObservation_Shape, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("DurationObservation_NameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label DurationObservation_NameLabel");
        return "";
    }

    private String getMessage_SynchEdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_SynchEdge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Message_SynchNameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Message_SynchNameLabel");
        return "";
    }

    private String getMessage_AsynchEdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_AsynchEdge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Message_AsynchNameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Message_AsynchNameLabel");
        return "";
    }

    private String getMessage_ReplyEdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_ReplyEdge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Message_ReplyNameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Message_ReplyNameLabel");
        return "";
    }

    private String getMessage_CreateEdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_CreateEdge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Message_CreateNameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Message_CreateNameLabel");
        return "";
    }

    private String getMessage_DeleteEdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_DeleteEdge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Message_DeleteNameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Message_DeleteNameLabel");
        return "";
    }

    private String getMessage_LostEdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_LostEdge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Message_LostNameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Message_LostNameLabel");
        return "";
    }

    private String getMessage_FoundEdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_FoundEdge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("Message_FoundNameLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label Message_FoundNameLabel");
        return "";
    }

    private String getComment_AnnotatedElementEdgeText(View view) {
        return "";
    }

    private String getConstraint_ConstrainedElementEdgeText(View view) {
        return "";
    }

    private String getGeneralOrdering_EdgeText(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.GeneralOrdering_Edge, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType("GeneralOrdering_StereotypeLabel"));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label GeneralOrdering_StereotypeLabel");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }
}

