/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementContentProvider;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementLabelProvider;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementTreeViewerFilter;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.TreeObject;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel.DecoratedTreeComposite;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.ChooseSetStereotypeDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.panels.AppliedStereotypePanel;
import org.eclipse.papyrus.uml.tools.commands.UnapplyStereotypeCommand;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCompositeOnModel
extends DecoratedTreeComposite
implements ISelectionChangedListener {
    private AppliedStereotypePanel appliedStereotypePanel;
    protected CLabel label;

    public TransactionalEditingDomain getEditingDomain(Element context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    public AppliedStereotypeCompositeOnModel(AppliedStereotypePanel parent) {
        super(parent, 0, "Applied stereotypes", true);
        this.appliedStereotypePanel = parent;
    }

    public AppliedStereotypeCompositeOnModel(Composite parent) {
        super(parent, 0, "Applied stereotypes", true);
    }

    protected void addAppliedStereotype() {
        ChooseSetStereotypeDialog dialog = new ChooseSetStereotypeDialog(this.getShell(), this.getElement());
        int result = dialog.open();
        if (result == 0) {
            Element element = this.getElement();
            EList oldStereotypeList = element.getAppliedStereotypes();
            ArrayList newStereotypeList = dialog.getSelectedElements();
            BasicEList newOrderList = new BasicEList();
            newOrderList.addAll((Collection)newStereotypeList);
            if (!newStereotypeList.equals(oldStereotypeList)) {
                for (Stereotype currentStOld : oldStereotypeList) {
                    if (newStereotypeList.contains(currentStOld)) {
                        newStereotypeList.remove(currentStOld);
                        continue;
                    }
                    this.unapplyStereotype(element, currentStOld);
                }
                for (Stereotype currentStereotype : newStereotypeList) {
                    this.applyStereotype(element, currentStereotype);
                }
                this.selectionChanged(null);
                if (this.appliedStereotypePanel != null) {
                    this.appliedStereotypePanel.refresh();
                }
            }
        }
    }

    public void addButtonPressed() {
        this.addAppliedStereotype();
    }

    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.createStereotypesTree();
        this.removeButton.setToolTipText("Remove stereotype");
        this.addButton.setToolTipText("Apply stereotype");
        return this;
    }

    private void createStereotypesTree() {
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProfileElementLabelProvider());
        this.treeViewer.addFilter((ViewerFilter)new ProfileElementTreeViewerFilter());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void downButtonPressed() {
        int nbrOfSelection = this.getTree().getSelectionCount();
        if (nbrOfSelection < 1) {
            return;
        }
        TreeItem[] items = this.getTree().getSelection();
        int indexLast = this.getTree().indexOf(items[items.length - 1]);
        if (indexLast + 1 >= this.getElement().getAppliedStereotypes().size()) {
            return;
        }
        int i = 0;
        while (i < nbrOfSelection) {
            TreeItem item = items[nbrOfSelection - 1 - i];
            if (item.getData() instanceof AppliedStereotypeTreeObject) {
                AppliedStereotypeTreeObject sTO = (AppliedStereotypeTreeObject)item.getData();
                BasicEList stereotypes = new BasicEList();
                stereotypes.addAll((Collection)this.element.getAppliedStereotypes());
                int index = stereotypes.indexOf((Object)sTO.getStereotype());
                if (index == -1 || index >= stereotypes.size() - 1) {
                    return;
                }
                stereotypes.move(index + 1, (Object)sTO.getStereotype());
                this.reorderStereotypeApplications(this.element, (EList)stereotypes);
            }
            ++i;
        }
    }

    public void editItem(TreeItem item) {
    }

    public Element getSelected() {
        return this.appliedStereotypePanel.getSelected();
    }

    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    protected Boolean isInStereotypeDisplay(Stereotype st) {
        return false;
    }

    public void refreshTreeViewer() {
        this.treeViewer.refresh();
    }

    public void refresh() {
        super.refresh();
        if (this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            if (this.element != null) {
                ISelection selection = this.treeViewer.getSelection();
                try {
                    this.treeViewer.setInput((Object)new StereotypedElementTreeObject(this.element));
                }
                finally {
                    this.treeViewer.setSelection(selection);
                }
            } else {
                this.treeViewer.setInput(null);
            }
            StereotypedElementTreeObject rTO = (StereotypedElementTreeObject)this.treeViewer.getInput();
            if (rTO == null) {
                return;
            }
            boolean isEditable = this.isEditable();
            if (rTO.getChildren() != null && rTO.getChildren().length > 1) {
                this.upButton.setEnabled(isEditable);
                this.downButton.setEnabled(isEditable);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
            if (rTO.getChildren() != null && rTO.getChildren().length == 0) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(isEditable);
            }
        }
    }

    public void removeButtonPressed() {
        this.unapplyStereotype();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.appliedStereotypePanel != null) {
            if (event == null) {
                this.appliedStereotypePanel.setSelectedProperty(null);
                return;
            }
            IStructuredSelection structSelection = (IStructuredSelection)event.getSelection();
            Object selection = structSelection.getFirstElement();
            if (selection instanceof AppliedStereotypePropertyTreeObject) {
                this.appliedStereotypePanel.setSelectedProperty((AppliedStereotypePropertyTreeObject)selection);
            } else {
                this.appliedStereotypePanel.setSelectedProperty(null);
            }
        }
    }

    public void setInput(StereotypedElementTreeObject element) {
        ISelection selection = this.treeViewer.getSelection();
        try {
            this.treeViewer.setInput((Object)element);
        }
        finally {
            this.treeViewer.setSelection(selection);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("StereotypesTree.expandAll")) {
            this.treeViewer.expandAll();
        }
    }

    protected void unapplyStereotype() {
        int nbrOfSelection = this.getTree().getSelectionCount();
        if (nbrOfSelection == 0) {
            return;
        }
        int i = 0;
        while (i < nbrOfSelection) {
            TreeItem item = this.getTree().getSelection()[i];
            if (item.getData() instanceof AppliedStereotypeTreeObject) {
                AppliedStereotypeTreeObject sTO = (AppliedStereotypeTreeObject)item.getData();
                this.unapplyStereotype(this.element, sTO.getStereotype());
                sTO.removeMe();
            }
            ++i;
        }
        if (this.appliedStereotypePanel != null) {
            this.appliedStereotypePanel.refresh();
        } else {
            this.refresh();
        }
    }

    public void upButtonPressed() {
        int nbrOfSelection = this.getTree().getSelectionCount();
        if (nbrOfSelection < 1) {
            return;
        }
        TreeItem[] items = this.getTree().getSelection();
        int indexFirst = this.getTree().indexOf(items[0]);
        if (indexFirst == 0) {
            return;
        }
        int i = 0;
        while (i < nbrOfSelection) {
            TreeItem item = items[i];
            if (item.getData() instanceof AppliedStereotypeTreeObject) {
                AppliedStereotypeTreeObject sTO = (AppliedStereotypeTreeObject)item.getData();
                BasicEList stereotypes = new BasicEList();
                stereotypes.addAll((Collection)this.element.getAppliedStereotypes());
                int index = stereotypes.indexOf((Object)sTO.getStereotype());
                if (index < 1) {
                    return;
                }
                stereotypes.move(index - 1, (Object)sTO.getStereotype());
                this.reorderStereotypeApplications(this.element, (EList)stereotypes);
            }
            ++i;
        }
        if (this.appliedStereotypePanel != null) {
            this.appliedStereotypePanel.refresh();
        } else {
            this.refresh();
        }
    }

    public void keepSelection(ISelection pSelection) {
        this.getDisplay().asyncExec((Runnable)new SelectionKeeper(pSelection));
    }

    public void applyStereotype(final Element elt, final Stereotype st) {
        try {
            final TransactionalEditingDomain domain = this.getEditingDomain(elt);
            domain.runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            domain.getCommandStack().execute(AppliedStereotypeCompositeOnModel.this.getApplyStereotypeCommand(elt, st, domain));
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void unapplyStereotype(final Element elt, final Stereotype st) {
        try {
            final TransactionalEditingDomain domain = this.getEditingDomain(elt);
            domain.runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            domain.getCommandStack().execute(AppliedStereotypeCompositeOnModel.this.getUnapplyStereotypeCommand(elt, st, domain));
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void reorderStereotypeApplications(final Element element, final EList stereotypes) {
        try {
            final TransactionalEditingDomain domain = this.getEditingDomain(element);
            domain.runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                                protected void doExecute() {
                                    Util.reorderStereotypeApplications((Element)element, (EList)stereotypes);
                                    AppliedStereotypeCompositeOnModel.this.refresh();
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected Command getApplyStereotypeCommand(final Element elt, final Stereotype st, TransactionalEditingDomain domain) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                elt.applyStereotype(st);
                AppliedStereotypeCompositeOnModel.this.refresh();
            }
        };
    }

    protected Command getUnapplyStereotypeCommand(Element elt, Stereotype st, TransactionalEditingDomain domain) {
        return new UnapplyStereotypeCommand(elt, st, domain);
    }

    private class SelectionKeeper
    implements Runnable {
        ISelection selection = null;

        public SelectionKeeper(ISelection selection) {
            this.selection = selection;
        }

        public void run() {
            Object[] vSelectedElements = this.extractSelectedElements(this.selection);
            Object[] vCorrespondingElements = this.getCorrespondingElements(vSelectedElements);
            StructuredSelection vSelection = new StructuredSelection(vCorrespondingElements);
            AppliedStereotypeCompositeOnModel.this.treeViewer.setSelection((ISelection)vSelection);
        }

        private Object[] getCorrespondingElements(Object[] vSelectedElements) {
            StereotypedElementTreeObject vStereotypesTree = (StereotypedElementTreeObject)AppliedStereotypeCompositeOnModel.this.treeViewer.getInput();
            ArrayList<AppliedStereotypeTreeObject> vReturn = new ArrayList<AppliedStereotypeTreeObject>();
            Object[] objectArray = vSelectedElements;
            int n = vSelectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object vStereotype = objectArray[n2];
                if (vStereotype instanceof AppliedStereotypeTreeObject) {
                    AppliedStereotypeTreeObject vTreeObject = this.findAppliedStereotypeInTree(((AppliedStereotypeTreeObject)vStereotype).getStereotype(), vStereotypesTree);
                    vReturn.add(vTreeObject);
                }
                ++n2;
            }
            return vReturn.toArray();
        }

        private AppliedStereotypeTreeObject findAppliedStereotypeInTree(Stereotype stereotype, StereotypedElementTreeObject vStereotypesTree) {
            AppliedStereotypeTreeObject vAppliedStereotypeObject = null;
            TreeObject[] treeObjectArray = vStereotypesTree.getChildren();
            int n = treeObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeObject vChild = treeObjectArray[n2];
                if (vChild instanceof AppliedStereotypeTreeObject && stereotype.equals(((AppliedStereotypeTreeObject)vChild).getStereotype())) {
                    vAppliedStereotypeObject = (AppliedStereotypeTreeObject)vChild;
                }
                ++n2;
            }
            return vAppliedStereotypeObject;
        }

        private Object[] extractSelectedElements(ISelection pSelection) {
            ArrayList<Object> vObjectsList = new ArrayList<Object>();
            if (pSelection instanceof IStructuredSelection) {
                vObjectsList.addAll(Arrays.asList(((IStructuredSelection)pSelection).toArray()));
            }
            return vObjectsList.toArray();
        }
    }
}

