/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredCreateConnectionViewCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.View;

public class CommonDeferredCreateConnectionViewCommand
extends DeferredCreateConnectionViewCommand
implements ICommand {
    protected ICommand command;
    protected Command createConnectionCmd;
    protected CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor;

    public CommonDeferredCreateConnectionViewCommand(TransactionalEditingDomain editingDomain, EObject element, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint, ICommand command) {
        super(editingDomain, element, sourceViewAdapter, targetViewAdapter, viewer, preferencesHint);
        this.command = command;
        this.setResult(CommandResult.newOKCommandResult());
    }

    public CommonDeferredCreateConnectionViewCommand(TransactionalEditingDomain editingDomain, String semanticHint, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint, CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor, ICommand command) {
        super(editingDomain, semanticHint, sourceViewAdapter, targetViewAdapter, viewer, preferencesHint);
        this.viewDescriptor = viewDescriptor;
        this.command = command;
        this.setResult(CommandResult.newOKCommandResult((Object)viewDescriptor));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Map epRegistry = this.viewer.getEditPartRegistry();
        IGraphicalEditPart sourceEP = (IGraphicalEditPart)epRegistry.get(this.sourceViewAdapter.getAdapter(View.class));
        IGraphicalEditPart targetEP = (IGraphicalEditPart)epRegistry.get(this.targetViewAdapter.getAdapter(View.class));
        if (sourceEP instanceof LabelEditPart) {
            sourceEP = this.findEditPartForCreation((View)this.sourceViewAdapter.getAdapter(View.class));
        }
        if (targetEP instanceof LabelEditPart) {
            targetEP = this.findEditPartForCreation((View)this.targetViewAdapter.getAdapter(View.class));
        }
        return this.doExecuteWithResult(progressMonitor, info, sourceEP, targetEP);
    }

    protected IGraphicalEditPart findEditPartForCreation(View view) {
        Iterator editPartIterator = this.viewer.getEditPartRegistry().values().iterator();
        EObject semanticElement = view.getElement();
        while (editPartIterator.hasNext()) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (currentEditPart instanceof CompartmentEditPart || !(currentEditPart instanceof IGraphicalEditPart) || semanticElement != ((IGraphicalEditPart)currentEditPart).resolveSemanticElement() || currentEditPart instanceof LabelEditPart) continue;
            return (IGraphicalEditPart)currentEditPart;
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info, IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart) throws ExecutionException {
        Assert.isNotNull((Object)sourceEditPart);
        Assert.isNotNull((Object)targetEditPart);
        CreateConnectionViewRequest createRequest = new CreateConnectionViewRequest(this.viewDescriptor);
        this.createConnectionCmd = CreateConnectionViewRequest.getCreateCommand((CreateConnectionViewRequest)createRequest, (EditPart)sourceEditPart, (EditPart)targetEditPart);
        if (this.createConnectionCmd == null) {
            throw new ExecutionException("Connection creation command is null.");
        }
        if (this.createConnectionCmd.canExecute()) {
            this.createConnectionCmd.execute();
        }
        if (this.element != null) {
            ((View)createRequest.getConnectionViewDescriptor().getAdapter(View.class)).setElement(this.element);
        }
        this.viewer = null;
        return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
    }

    public void setElement(EObject element) {
        this.element = element;
    }
}

