/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomIntStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableList;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.PapyrusRoundedEditPartHelper;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AllowResizeAffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;

public abstract class RoundedCompartmentEditPart
extends NamedElementEditPart {
    private static final boolean DEFAULT_HAS_HEADER = false;
    private static final int DEFAULT_BORDER_STYLE = 1;
    private static final int DEFAULT_CORNER_HEIGHT = 0;
    private static final int DEFAULT_CORNER_WIDTH = 0;
    private static final int[] DEFAULT_CUTOM_DASH = new int[]{5, 5};
    private static final int DEFAULT_FLOATING_LABEL_OFFSET_HEIGHT = 0;
    private static final int DEFAULT_FLOATING_LABEL_OFFSET_WIDTH = 0;
    private static final boolean DEFAULT_IS_FLOATING_LABEL_CONSTRAINED = false;
    private static final boolean DEFAULT_IS_OVAL = false;
    private static final boolean DEFAULT_IS_PACKAGE = false;
    private static final boolean DEFAULT_USE_ORIGINAL_COLORS = true;
    private static final int DEFAULT_SHADOW_WIDTH = 4;
    protected IChangeListener namedStyleListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            RoundedCompartmentEditPart.this.refresh();
        }
    };
    private IObservableValue ovalObservable;
    private IObservableValue borderStyleObservable;
    private IObservableValue hasHeaderObservable;
    private IObservableValue radiusObservableHeight;
    private IObservableValue radiusObservableWidth;
    private IObservableList customDashObservable;
    private IObservableValue isPackageObservable;
    private IObservableValue shadowWidthObservable;
    private IObservableValue shadowColorObservable;
    private IObservableValue alignmentObservable;
    private IObservableValue isFloatingLabelContrainedObservable;
    private IObservableValue floatingLabelOffsetObservableHeight;
    private IObservableValue floatingLabelOffsetObservableWidth;
    private IObservableValue nameBackgroundColorObservable;

    public RoundedCompartmentEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("affixed node alignment editpolicy", (EditPolicy)new AllowResizeAffixedNodeAlignmentEditPolicy());
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        if ("affixed node alignment editpolicy".equals(key)) {
            if (editPolicy instanceof AllowResizeAffixedNodeAlignmentEditPolicy) {
                super.installEditPolicy(key, editPolicy);
            }
        } else {
            super.installEditPolicy(key, editPolicy);
        }
    }

    @Override
    protected void refreshVisuals() {
        PapyrusRoundedEditPartHelper.refreshRadius((IPapyrusEditPart)this, (int)this.getDefaultCornerWidth(), (int)this.getDefaultCornerHeight());
        PapyrusRoundedEditPartHelper.refreshOval((IPapyrusEditPart)this, (boolean)this.getDefaultIsOvalValue());
        PapyrusRoundedEditPartHelper.refreshFloatingName((IPapyrusEditPart)this, (boolean)this.getDefaultIsFloatingNameConstrained(), (int)this.getDefaultFloatingLabelOffsetWidth(), (int)this.getDefaultFloatingLabelOffsetHeight());
        PapyrusRoundedEditPartHelper.refreshBorderStyle((IPapyrusEditPart)this, (int)this.getDefaultBorderStyle(), (int[])this.getDefaultCutomDash());
        PapyrusRoundedEditPartHelper.refreshHasHeader((IPapyrusEditPart)this, (boolean)this.getDefaultHasHeader());
        PapyrusRoundedEditPartHelper.refreshShadowWidth((IPapyrusEditPart)this, (int)this.getDefaultShadowWidth());
        PapyrusRoundedEditPartHelper.refreshPackage((IPapyrusEditPart)this, (boolean)this.getDefaultIsPackage());
        PapyrusRoundedEditPartHelper.refreshShadowColor((IPapyrusEditPart)this, (String)this.getDefaultShadowColor());
        PapyrusRoundedEditPartHelper.refreshNameLabelColor((IPapyrusEditPart)this, (String)this.getNameLabelbackgroundColor());
        super.refreshVisuals();
    }

    protected int getLineType() {
        return PapyrusRoundedEditPartHelper.getNotationBorderStyle((IPapyrusEditPart)this, (int)this.getDefaultBorderStyle());
    }

    protected String getNameLabelbackgroundColor() {
        return null;
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        View view = (View)this.getModel();
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)view);
        this.radiusObservableWidth = new CustomIntStyleObservableValue(view, domain, "radiusWidth");
        this.radiusObservableWidth.addChangeListener(this.namedStyleListener);
        this.radiusObservableHeight = new CustomIntStyleObservableValue(view, domain, "radiusHeight");
        this.radiusObservableHeight.addChangeListener(this.namedStyleListener);
        this.ovalObservable = new CustomBooleanStyleObservableValue(view, domain, "isOval");
        this.ovalObservable.addChangeListener(this.namedStyleListener);
        this.borderStyleObservable = new CustomStringStyleObservableValue(view, domain, "borderStyle");
        this.borderStyleObservable.addChangeListener(this.namedStyleListener);
        this.customDashObservable = new CustomStringStyleObservableList(view, domain, "customDash");
        this.customDashObservable.addChangeListener(this.namedStyleListener);
        this.hasHeaderObservable = new CustomBooleanStyleObservableValue(view, domain, "displayHeader");
        this.hasHeaderObservable.addChangeListener(this.namedStyleListener);
        this.isPackageObservable = new CustomBooleanStyleObservableValue(view, domain, "isPackage");
        this.isPackageObservable.addChangeListener(this.namedStyleListener);
        this.shadowWidthObservable = new CustomIntStyleObservableValue(view, domain, "shadowWidth");
        this.shadowWidthObservable.addChangeListener(this.namedStyleListener);
        this.shadowColorObservable = new CustomStringStyleObservableValue(view, domain, "shadowColor");
        this.shadowColorObservable.addChangeListener(this.namedStyleListener);
        this.nameBackgroundColorObservable = new CustomStringStyleObservableValue(view, domain, "nameBackgroundColor");
        this.nameBackgroundColorObservable.addChangeListener(this.namedStyleListener);
        this.alignmentObservable = new CustomStringStyleObservableValue(view, domain, "textAlignment");
        this.alignmentObservable.addChangeListener(this.namedStyleListener);
        this.floatingLabelOffsetObservableHeight = new CustomIntStyleObservableValue(view, domain, "floatingLabelOffsetHeight");
        this.floatingLabelOffsetObservableHeight.addChangeListener(this.namedStyleListener);
        this.floatingLabelOffsetObservableWidth = new CustomIntStyleObservableValue(view, domain, "floatingLabelOffsetWidth");
        this.floatingLabelOffsetObservableWidth.addChangeListener(this.namedStyleListener);
        this.isFloatingLabelContrainedObservable = new CustomBooleanStyleObservableValue(view, domain, "isFloatingLabelConstrained");
        this.isFloatingLabelContrainedObservable.addChangeListener(this.namedStyleListener);
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.radiusObservableWidth.dispose();
        this.radiusObservableHeight.dispose();
        this.ovalObservable.dispose();
        this.borderStyleObservable.dispose();
        this.customDashObservable.dispose();
        this.hasHeaderObservable.dispose();
        this.isPackageObservable.dispose();
        this.shadowWidthObservable.dispose();
        this.shadowColorObservable.dispose();
        this.nameBackgroundColorObservable.dispose();
        this.alignmentObservable.dispose();
        this.floatingLabelOffsetObservableHeight.dispose();
        this.floatingLabelOffsetObservableWidth.dispose();
        this.isFloatingLabelContrainedObservable.dispose();
    }

    private String getDefaultShadowColor() {
        return null;
    }

    protected boolean getDefaultIsPackage() {
        return false;
    }

    private int getDefaultShadowWidth() {
        return 4;
    }

    protected int getDefaultBorderStyle() {
        return 1;
    }

    protected int getDefaultCornerHeight() {
        return 0;
    }

    protected int getDefaultCornerWidth() {
        return 0;
    }

    private int[] getDefaultCutomDash() {
        return DEFAULT_CUTOM_DASH;
    }

    protected int getDefaultFloatingLabelOffsetHeight() {
        return 0;
    }

    protected int getDefaultFloatingLabelOffsetWidth() {
        return 0;
    }

    protected boolean getDefaultIsFloatingNameConstrained() {
        return false;
    }

    protected boolean getDefaultIsOvalValue() {
        return false;
    }

    protected boolean getDefaultUseOriginalColors() {
        return true;
    }

    protected boolean getDefaultHasHeader() {
        return false;
    }
}

