/**
 * Copyright (c) 2017 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.uml.expressions.umlexpressions.provider;

import java.util.ArrayList;
import java.util.Collection;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.emf.expressions.ExpressionCatalog;
import org.eclipse.papyrus.infra.emf.expressions.ExpressionsPackage;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.AndExpression;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.BooleanExpressionsPackage;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.NotExpression;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.OrExpression;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.util.BooleanExpressionsSwitch;
import org.eclipse.papyrus.infra.emf.expressions.util.ExpressionsSwitch;
import org.eclipse.papyrus.uml.expressions.umlexpressions.UMLExpressionsFactory;
import org.eclipse.papyrus.uml.expressions.umlexpressions.UMLExpressionsPackage;
import org.eclipse.papyrus.uml.expressions.umlexpressions.util.UMLExpressionsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class UMLExpressionsItemProviderAdapterFactory extends UMLExpressionsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(UmlexpressionsEditPlugin.INSTANCE, UMLExpressionsPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UMLExpressionsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsStereotypedWithExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IsStereotypedWithExpressionItemProvider isStereotypedWithExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsStereotypedWithExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIsStereotypedWithExpressionAdapter() {
		if (isStereotypedWithExpressionItemProvider == null) {
			isStereotypedWithExpressionItemProvider = new IsStereotypedWithExpressionItemProvider(this);
		}

		return isStereotypedWithExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.expressions.umlexpressions.HasAppliedStereotypesExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HasAppliedStereotypesExpressionItemProvider hasAppliedStereotypesExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.expressions.umlexpressions.HasAppliedStereotypesExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHasAppliedStereotypesExpressionAdapter() {
		if (hasAppliedStereotypesExpressionItemProvider == null) {
			hasAppliedStereotypesExpressionItemProvider = new HasAppliedStereotypesExpressionItemProvider(this);
		}

		return hasAppliedStereotypesExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsTypeOfExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IsTypeOfExpressionItemProvider isTypeOfExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsTypeOfExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIsTypeOfExpressionAdapter() {
		if (isTypeOfExpressionItemProvider == null) {
			isTypeOfExpressionItemProvider = new IsTypeOfExpressionItemProvider(this);
		}

		return isTypeOfExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsKindOfExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IsKindOfExpressionItemProvider isKindOfExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsKindOfExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIsKindOfExpressionAdapter() {
		if (isKindOfExpressionItemProvider == null) {
			isKindOfExpressionItemProvider = new IsKindOfExpressionItemProvider(this);
		}

		return isKindOfExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsKindOfStereotypeExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IsKindOfStereotypeExpressionItemProvider isKindOfStereotypeExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsKindOfStereotypeExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIsKindOfStereotypeExpressionAdapter() {
		if (isKindOfStereotypeExpressionItemProvider == null) {
			isKindOfStereotypeExpressionItemProvider = new IsKindOfStereotypeExpressionItemProvider(this);
		}

		return isKindOfStereotypeExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsTypeOfStereotypeExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IsTypeOfStereotypeExpressionItemProvider isTypeOfStereotypeExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.expressions.umlexpressions.IsTypeOfStereotypeExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIsTypeOfStereotypeExpressionAdapter() {
		if (isTypeOfStereotypeExpressionItemProvider == null) {
			isTypeOfStereotypeExpressionItemProvider = new IsTypeOfStereotypeExpressionItemProvider(this);
		}

		return isTypeOfStereotypeExpressionItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (isStereotypedWithExpressionItemProvider != null) isStereotypedWithExpressionItemProvider.dispose();
		if (hasAppliedStereotypesExpressionItemProvider != null) hasAppliedStereotypesExpressionItemProvider.dispose();
		if (isTypeOfExpressionItemProvider != null) isTypeOfExpressionItemProvider.dispose();
		if (isKindOfExpressionItemProvider != null) isKindOfExpressionItemProvider.dispose();
		if (isKindOfStereotypeExpressionItemProvider != null) isKindOfStereotypeExpressionItemProvider.dispose();
		if (isTypeOfStereotypeExpressionItemProvider != null) isTypeOfStereotypeExpressionItemProvider.dispose();
	}

	/**
	 * A child creation extender for the {@link ExpressionsPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class ExpressionsChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends ExpressionsSwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseExpressionCatalog(ExpressionCatalog object) {
				newChildDescriptors.add
					(createChildParameter
						(ExpressionsPackage.Literals.EXPRESSION_CATALOG__EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsStereotypedWithExpression()));

				newChildDescriptors.add
					(createChildParameter
						(ExpressionsPackage.Literals.EXPRESSION_CATALOG__EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createHasAppliedStereotypesExpression()));

				newChildDescriptors.add
					(createChildParameter
						(ExpressionsPackage.Literals.EXPRESSION_CATALOG__EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(ExpressionsPackage.Literals.EXPRESSION_CATALOG__EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(ExpressionsPackage.Literals.EXPRESSION_CATALOG__EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfStereotypeExpression()));

				newChildDescriptors.add
					(createChildParameter
						(ExpressionsPackage.Literals.EXPRESSION_CATALOG__EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfStereotypeExpression()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
			new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
			return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return UmlexpressionsEditPlugin.INSTANCE;
		}
	}

	/**
	 * A child creation extender for the {@link BooleanExpressionsPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class BooleanExpressionsChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends BooleanExpressionsSwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseOrExpression(OrExpression object) {
				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.OR_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsStereotypedWithExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.OR_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createHasAppliedStereotypesExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.OR_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.OR_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.OR_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfStereotypeExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.OR_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfStereotypeExpression()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseAndExpression(AndExpression object) {
				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.AND_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsStereotypedWithExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.AND_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createHasAppliedStereotypesExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.AND_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.AND_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.AND_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfStereotypeExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.AND_EXPRESSION__OWNED_EXPRESSIONS,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfStereotypeExpression()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseNotExpression(NotExpression object) {
				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.NOT_EXPRESSION__OWNED_EXPRESSION,
						 UMLExpressionsFactory.eINSTANCE.createIsStereotypedWithExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.NOT_EXPRESSION__OWNED_EXPRESSION,
						 UMLExpressionsFactory.eINSTANCE.createHasAppliedStereotypesExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.NOT_EXPRESSION__OWNED_EXPRESSION,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.NOT_EXPRESSION__OWNED_EXPRESSION,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.NOT_EXPRESSION__OWNED_EXPRESSION,
						 UMLExpressionsFactory.eINSTANCE.createIsKindOfStereotypeExpression()));

				newChildDescriptors.add
					(createChildParameter
						(BooleanExpressionsPackage.Literals.NOT_EXPRESSION__OWNED_EXPRESSION,
						 UMLExpressionsFactory.eINSTANCE.createIsTypeOfStereotypeExpression()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
			new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
			return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return UmlexpressionsEditPlugin.INSTANCE;
		}
	}

}
