/**
 * Copyright (c) 2015 Christian W. Damus and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *
 */
package org.eclipse.papyrus.infra.editor.welcome;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 *
 * @see org.eclipse.papyrus.infra.editor.welcome.WelcomePackage
 * @generated
 */
public interface WelcomeFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	WelcomeFactory eINSTANCE = org.eclipse.papyrus.infra.editor.welcome.internal.impl.WelcomeFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Welcome</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Welcome</em>'.
	 * @generated
	 */
	Welcome createWelcome();

	/**
	 * Returns a new object of class '<em>Page</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Page</em>'.
	 * @generated
	 */
	WelcomePage createWelcomePage();

	/**
	 * Returns a new object of class '<em>Section</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Section</em>'.
	 * @generated
	 */
	WelcomeSection createWelcomeSection();

	/**
	 * Returns a new object of class '<em>Sash Column</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Sash Column</em>'.
	 * @generated
	 */
	SashColumn createSashColumn();

	/**
	 * Returns a new object of class '<em>Sash Row</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return a new object of class '<em>Sash Row</em>'.
	 * @generated
	 */
	SashRow createSashRow();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the package supported by this factory.
	 * @generated
	 */
	WelcomePackage getWelcomePackage();

} // WelcomeFactory
