/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.locators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.BehaviorFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.PortFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.BasePortChildLocator;

public class BehaviorPositionLocator
extends BasePortChildLocator {
    public BehaviorPositionLocator(PortFigure port) {
        super(port);
    }

    public void relocate(IFigure target) {
        BehaviorFigure behavior = this.myPort.getBehavior();
        Rectangle behaviorPosition = this.getBehaviorPosition(this.myPort);
        behavior.setBounds(behaviorPosition);
    }

    private Rectangle getBehaviorPosition(PortFigure port) {
        int portSide = this.getPortSide();
        BehaviorFigure behavior = port.getBehavior();
        behavior.setPosition(portSide);
        Rectangle portPosition = port.getBounds();
        Rectangle behaviorPosition = port.getBehavior().getBounds();
        behaviorPosition.x = portPosition.x;
        behaviorPosition.y = portPosition.y;
        if ((portSide & 1) != 0) {
            behaviorPosition.y = behaviorPosition.y + portPosition.height + 6;
            behaviorPosition.x = behaviorPosition.x + portPosition.width / 2 - behaviorPosition.width / 2;
        } else if ((portSide & 4) != 0) {
            behaviorPosition.y = behaviorPosition.y - behaviorPosition.height - 6;
            behaviorPosition.x = behaviorPosition.x + portPosition.width / 2 - behaviorPosition.width / 2;
        } else if ((portSide & 0x10) != 0) {
            behaviorPosition.x = behaviorPosition.x - behaviorPosition.width - 6;
            behaviorPosition.y = behaviorPosition.y + portPosition.height / 2 - behaviorPosition.height / 2;
        } else if ((portSide & 8) != 0) {
            behaviorPosition.x = behaviorPosition.x + portPosition.width + 6;
            behaviorPosition.y = behaviorPosition.y + portPosition.height / 2 - behaviorPosition.height / 2;
        }
        return behaviorPosition;
    }
}

