/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.internal.uml.diagram.sequence.elk.Point;
import org.eclipse.papyrus.internal.uml.diagram.sequence.elk.RectilinearConvexHull;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifeLineLayoutManager;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.swt.graphics.Color;

public class LifelineFigure
extends RoundedCompartmentFigure {
    protected RectangleFigure lifelineHeaderBoundsFigure;
    @Deprecated
    protected RectangleFigure fFigureExecutionsContainerFigure;
    @Deprecated
    protected LifelineDotLineCustomFigure fFigureLifelineDotLineFigure;
    private List<NodeFigure> childrenFigure = new ArrayList<NodeFigure>();

    public LifelineFigure() {
        this.setLayoutManager((LayoutManager)new LifeLineLayoutManager());
        this.setTransparency(100);
        this.createContents();
    }

    public void setTransparency(int transparency) {
        super.setTransparency(100);
    }

    public PointList getPolygonPoints() {
        PointList points = new PointList(8);
        points.addPoint(this.getBounds().x, this.getBounds().y);
        points.addPoint(this.getBounds().x + this.getBounds().width, this.getBounds().y);
        points.addPoint(this.getBounds().x + this.getBounds().width, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader());
        points.addPoint(this.getBounds().x + this.getBounds().width / 2, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader());
        points.addPoint(this.getBounds().x + this.getBounds().width / 2, this.getBounds().y + this.getBounds().height);
        points.addPoint(this.getBounds().x + this.getBounds().width / 2, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader());
        points.addPoint(this.getBounds().x, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader());
        points.addPoint(this.getBounds().x, this.getBounds().y);
        if (this.childrenFigure.isEmpty()) {
            return points;
        }
        return this.completeFigureWithChildren(points);
    }

    /*
     * WARNING - void declaration
     */
    private PointList completeFigureWithChildren(PointList nudeLifelinePointList) {
        void var8_13;
        void var8_11;
        if (this.childrenFigure.isEmpty()) {
            return nudeLifelinePointList;
        }
        PointList newPointList = new PointList();
        int index = 0;
        while (index < 4) {
            newPointList.addPoint(nudeLifelinePointList.getPoint(index));
            ++index;
        }
        List<Set<Rectangle>> groups = this.getGroupedRectangles(this.getChildrenRectangle());
        ArrayList<Collection<org.eclipse.draw2d.geometry.Point>> groupPointsLists = new ArrayList<Collection<org.eclipse.draw2d.geometry.Point>>();
        for (Set<Rectangle> currentGroup : groups) {
            groupPointsLists.add(PapyrusRectilinearConvexHull.getExternalShapeForRectangle(currentGroup));
        }
        groupPointsLists.sort(new OrdinatePointListComparator());
        ArrayList<ArrayList<org.eclipse.draw2d.geometry.Point>> descendingList = new ArrayList<ArrayList<org.eclipse.draw2d.geometry.Point>>();
        ArrayList<ArrayList<org.eclipse.draw2d.geometry.Point>> ascendingList = new ArrayList<ArrayList<org.eclipse.draw2d.geometry.Point>>();
        for (List list : groupPointsLists) {
            ArrayList<org.eclipse.draw2d.geometry.Point> topToBottom = new ArrayList<org.eclipse.draw2d.geometry.Point>();
            ArrayList<org.eclipse.draw2d.geometry.Point> bottomToTop = new ArrayList<org.eclipse.draw2d.geometry.Point>();
            LifelineFigure.divideIn2PointLists(list, topToBottom, bottomToTop);
            descendingList.add(topToBottom);
            ascendingList.add(0, bottomToTop);
        }
        boolean bl = false;
        while (var8_11 < descendingList.size()) {
            newPointList.addPoint(newPointList.getLastPoint().x, ((org.eclipse.draw2d.geometry.Point)((List)descendingList.get((int)var8_11)).get((int)0)).y);
            for (org.eclipse.draw2d.geometry.Point current : (List)descendingList.get((int)var8_11)) {
                newPointList.addPoint(current);
            }
            newPointList.addPoint(this.getBounds().x + this.getBounds().width / 2, newPointList.getLastPoint().y);
            ++var8_11;
        }
        newPointList.addPoint(newPointList.getLastPoint().x, this.getBounds().y + this.getBounds().height);
        boolean bl2 = false;
        while (var8_13 < ascendingList.size()) {
            newPointList.addPoint(newPointList.getLastPoint().x, ((org.eclipse.draw2d.geometry.Point)((List)ascendingList.get((int)var8_13)).get((int)0)).y);
            for (org.eclipse.draw2d.geometry.Point current : (List)ascendingList.get((int)var8_13)) {
                newPointList.addPoint(current);
            }
            newPointList.addPoint(this.getBounds().x + this.getBounds().width / 2, newPointList.getLastPoint().y);
            ++var8_13;
        }
        ++index;
        while (index < nudeLifelinePointList.size()) {
            newPointList.addPoint(nudeLifelinePointList.getPoint(index));
            ++index;
        }
        return newPointList;
    }

    private Collection<Rectangle> getChildrenRectangle() {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (NodeFigure figure : this.childrenFigure) {
            rectangles.add(figure.getBounds());
        }
        return rectangles;
    }

    private static final void divideIn2PointLists(List<org.eclipse.draw2d.geometry.Point> ptList, List<org.eclipse.draw2d.geometry.Point> topToBottomList, List<org.eclipse.draw2d.geometry.Point> bottomToTopList) {
        Assert.isNotNull(topToBottomList);
        Assert.isNotNull(bottomToTopList);
        org.eclipse.draw2d.geometry.Point topPoint = LifelineFigure.getTopPoint(ptList);
        org.eclipse.draw2d.geometry.Point bottomPoint = LifelineFigure.getBottomPoint(ptList);
        boolean topToBottom = true;
        int i = ptList.indexOf(topPoint);
        while (true) {
            org.eclipse.draw2d.geometry.Point current = ptList.get(i);
            if (i + 1 == ptList.size()) {
                i = 0;
            }
            if (topToBottom) {
                topToBottomList.add(current);
                if (current.equals((Object)bottomPoint)) {
                    topToBottom = false;
                    bottomToTopList.add(current);
                }
            } else {
                bottomToTopList.add(current);
                if (current.equals((Object)topPoint)) break;
            }
            ++i;
        }
    }

    private static final org.eclipse.draw2d.geometry.Point getTopPoint(Collection<org.eclipse.draw2d.geometry.Point> points) {
        org.eclipse.draw2d.geometry.Point topPoint = new org.eclipse.draw2d.geometry.Point(0, Integer.MAX_VALUE);
        for (org.eclipse.draw2d.geometry.Point current : points) {
            if (current.y >= topPoint.y) continue;
            topPoint = current;
        }
        return topPoint;
    }

    private static final org.eclipse.draw2d.geometry.Point getBottomPoint(Collection<org.eclipse.draw2d.geometry.Point> points) {
        org.eclipse.draw2d.geometry.Point bottomPoint = new org.eclipse.draw2d.geometry.Point(0, Integer.MIN_VALUE);
        for (org.eclipse.draw2d.geometry.Point current : points) {
            if (current.y <= bottomPoint.y) continue;
            bottomPoint = current;
        }
        return bottomPoint;
    }

    private List<Set<Rectangle>> getGroupedRectangles(Collection<Rectangle> rectangles) {
        ArrayList<Set<Rectangle>> groups = new ArrayList<Set<Rectangle>>();
        ArrayList<Rectangle> localRectangles = new ArrayList<Rectangle>(rectangles);
        Iterator iter = localRectangles.iterator();
        while (iter.hasNext()) {
            Set<Rectangle> result = this.getIntersectingRectangles((Rectangle)iter.next(), localRectangles);
            groups.add(result);
            localRectangles.removeAll(result);
            iter = localRectangles.iterator();
        }
        return groups;
    }

    private Set<Rectangle> getIntersectingRectangles(Rectangle aRectangle, Collection<Rectangle> allAvailableRectangle) {
        allAvailableRectangle = new ArrayList<Rectangle>(allAvailableRectangle);
        allAvailableRectangle.remove(aRectangle);
        HashSet<Rectangle> intersectingRectangles = new HashSet<Rectangle>();
        for (Rectangle current : allAvailableRectangle) {
            if (!current.intersects(aRectangle)) continue;
            intersectingRectangles.add(current);
            intersectingRectangles.addAll(this.getIntersectingRectangles(current, allAvailableRectangle));
        }
        intersectingRectangles.add(aRectangle);
        return intersectingRectangles;
    }

    public void paint(Graphics graphics) {
        Rectangle rect = this.getBounds();
        graphics.pushState();
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setLineWidth(1);
        graphics.drawRectangle(rect.x, rect.y, rect.width - 1, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader() - rect.y);
        graphics.setLineDash(new int[]{5, 5});
        graphics.drawLine(new org.eclipse.draw2d.geometry.Point(rect.x + rect.width / 2, ((LifeLineLayoutManager)this.getLifeLineLayoutManager()).getBottomHeader()), new org.eclipse.draw2d.geometry.Point(rect.x + rect.width / 2, rect.y + rect.height - 1));
        graphics.popState();
        super.paint(graphics);
    }

    public LayoutManager getLayoutManager() {
        return new XYLayout();
    }

    public LayoutManager getLifeLineLayoutManager() {
        return super.getLayoutManager();
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        super.paintBackground(graphics, this.getFigureLifelineNameContainerFigure().getBounds());
    }

    protected IFigure getBorderedFigure() {
        return this.getFigureLifelineNameContainerFigure();
    }

    protected Border getDefaultBorder(Color borderColor) {
        int margin = this.getMapMode().DPtoLP(7);
        MarginBorder defaultBorder = new MarginBorder(margin, margin, margin, margin);
        return defaultBorder;
    }

    private void createContents() {
        this.lifelineHeaderBoundsFigure = new LifelineHeaderFigure();
        this.add((IFigure)this.lifelineHeaderBoundsFigure);
    }

    protected IMapMode getMapMode() {
        return MapModeUtil.getMapMode();
    }

    public WrappingLabel getFigureLifelineLabelFigure() {
        return this.getNameLabel();
    }

    @Deprecated
    public RectangleFigure getFigureLifelineNameContainerFigure() {
        return this.lifelineHeaderBoundsFigure;
    }

    @Deprecated
    public RectangleFigure getFigureExecutionsContainerFigure() {
        return this.fFigureExecutionsContainerFigure;
    }

    @Deprecated
    public LifelineDotLineCustomFigure getFigureLifelineDotLineFigure() {
        return this.fFigureLifelineDotLineFigure;
    }

    public void setChildrenFigure(List<NodeFigure> childrenFigure) {
        this.childrenFigure = childrenFigure == null ? Collections.emptyList() : childrenFigure;
    }

    public final class LifelineHeaderFigure
    extends RectangleFigure {
        protected void fillShape(Graphics graphics) {
        }

        protected void outlineShape(Graphics graphics) {
        }
    }

    private static final class OrdinatePointListComparator
    implements Comparator<Collection<org.eclipse.draw2d.geometry.Point>> {
        private OrdinatePointListComparator() {
        }

        @Override
        public int compare(Collection<org.eclipse.draw2d.geometry.Point> o1, Collection<org.eclipse.draw2d.geometry.Point> o2) {
            return Integer.valueOf(LifelineFigure.getTopPoint(o1).y).compareTo(LifelineFigure.getTopPoint(o2).y);
        }
    }

    private static final class PapyrusRectilinearConvexHull {
        private PapyrusRectilinearConvexHull() {
        }

        public static final List<org.eclipse.draw2d.geometry.Point> getExternalShapeForRectangle(Collection<Rectangle> rectangles) {
            return PapyrusRectilinearConvexHull.getExternalShapeForPoints(PapyrusRectilinearConvexHull.getAllPoints(rectangles));
        }

        private static final List<org.eclipse.draw2d.geometry.Point> getExternalShapeForPoints(Collection<org.eclipse.draw2d.geometry.Point> inputPoints) {
            List<Point> elkPTS = PapyrusRectilinearConvexHull.convertToELKPoints(inputPoints);
            List<org.eclipse.draw2d.geometry.Point> pt = PapyrusRectilinearConvexHull.convertToPoints(RectilinearConvexHull.of(elkPTS).getHull());
            pt.add(pt.iterator().next());
            return pt;
        }

        private static final Set<org.eclipse.draw2d.geometry.Point> getAllPoints(Collection<Rectangle> rectangles) {
            HashSet<org.eclipse.draw2d.geometry.Point> points = new HashSet<org.eclipse.draw2d.geometry.Point>();
            for (Rectangle current : rectangles) {
                for (Rectangle internalCurrent : rectangles) {
                    if (!internalCurrent.intersects(current)) continue;
                    Rectangle rect = internalCurrent.getIntersection(current);
                    points.add(rect.getTopLeft());
                    points.add(rect.getTopRight());
                    points.add(rect.getBottomLeft());
                    points.add(rect.getBottomRight());
                }
                points.add(current.getTopLeft());
                points.add(current.getTopRight());
                points.add(current.getBottomLeft());
                points.add(current.getBottomRight());
            }
            return points;
        }

        private static final List<Point> convertToELKPoints(Collection<org.eclipse.draw2d.geometry.Point> draw2DPoints) {
            ArrayList<Point> elkPoints = new ArrayList<Point>();
            for (org.eclipse.draw2d.geometry.Point current : draw2DPoints) {
                elkPoints.add(new Point(current.preciseX(), current.preciseY()));
            }
            return elkPoints;
        }

        private static final List<org.eclipse.draw2d.geometry.Point> convertToPoints(Collection<Point> elkPoints) {
            ArrayList<org.eclipse.draw2d.geometry.Point> draw2DPoints = new ArrayList<org.eclipse.draw2d.geometry.Point>();
            for (Point current : elkPoints) {
                draw2DPoints.add(new org.eclipse.draw2d.geometry.Point((int)current.x, (int)current.y));
            }
            return draw2DPoints;
        }
    }
}

