/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.providers;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomCommentAnnotatedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomDurationConstraintEditPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.uml2.uml.DurationConstraint;

public class DurationConstraintContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;
    private MenuItem subMenuItem;

    public DurationConstraintContributionItem() {
        this.setId("org.eclipse.papyrus.sequence.duraitonconstraint.menuitem");
    }

    public DurationConstraintContributionItem(String id) {
        super(id);
    }

    public void dispose() {
        if (this.subMenuItem != null && !this.subMenuItem.isDisposed()) {
            this.subMenuItem.dispose();
        }
    }

    public void fill(Composite parent) {
    }

    public void fill(Menu menu, int index) {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement == null) {
            return;
        }
        EObject businessObject = EMFHelper.getEObject((Object)selectedElement);
        if (businessObject == null || !(businessObject instanceof DurationConstraint)) {
            return;
        }
        this.createSubMenu(menu, index, (DurationConstraint)businessObject);
    }

    protected void createSubMenu(Menu menu, int index, DurationConstraint businessObject) {
        this.subMenuItem = new MenuItem(menu, 8);
        this.subMenuItem.setText("Rotate Duration Constraint");
        this.subMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DurationConstraintContributionItem.this.doRotate();
            }
        });
    }

    protected Object getSelectedElement() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    protected ISelection getSelection() {
        ISelectionService selectionService = this.getSelectionService();
        if (selectionService != null) {
            return selectionService.getSelection();
        }
        return null;
    }

    protected ISelectionService getSelectionService() {
        ISelectionService selectionService = (ISelectionService)this.serviceLocator.getService(ISelectionService.class);
        return selectionService;
    }

    public void fill(ToolBar parent, int index) {
    }

    public void fill(CoolBar parent, int index) {
    }

    public void saveWidgetState() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isGroupMarker() {
        return false;
    }

    public boolean isSeparator() {
        return false;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "(id=" + this.getId() + ")";
    }

    public void update() {
    }

    public void update(String id) {
    }

    public void initialize(IServiceLocator serviceLocator) {
        assert (serviceLocator != null);
        this.serviceLocator = serviceLocator;
    }

    private void doRotate() {
        Object element = this.getSelectedElement();
        if (!(element instanceof CustomDurationConstraintEditPart)) {
            return;
        }
        CustomDurationConstraintEditPart durationPart = (CustomDurationConstraintEditPart)((Object)element);
        boolean isVertical = durationPart.isArrowVertical();
        CompositeCommand compositeCmd = new CompositeCommand("rotate");
        CustomDurationConstraintEditPart.RotateArrowCommand rotateCmd = new CustomDurationConstraintEditPart.RotateArrowCommand(durationPart.getEditingDomain(), durationPart);
        compositeCmd.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)rotateCmd));
        SetResizeAndLocationCommand boundsCommand = new SetResizeAndLocationCommand(durationPart.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)durationPart.getNotationView()), this.getNewBounds(durationPart.getBounds()));
        compositeCmd.add((IUndoableOperation)boundsCommand);
        List list = durationPart.getSourceConnections();
        for (Object o : list) {
            CustomCommentAnnotatedElementEditPart connectionPart;
            String terminal;
            if (!(o instanceof CustomCommentAnnotatedElementEditPart) || (terminal = AnchorHelper.getAnchorId((connectionPart = (CustomCommentAnnotatedElementEditPart)((Object)o)).getEditingDomain(), (ConnectionEditPart)connectionPart, true)).length() <= 0) continue;
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            SetConnectionAnchorsCommand rotateAnchorsCommand = new SetConnectionAnchorsCommand(connectionPart.getEditingDomain(), "Rotate Duration Anchors");
            rotateAnchorsCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)connectionPart.getNotationView()));
            if (isVertical) {
                if ((double)pt.y < 0.3) {
                    rotateAnchorsCommand.setNewSourceTerminal("(0,0.5){L}");
                } else if ((double)pt.y > 0.7) {
                    rotateAnchorsCommand.setNewSourceTerminal("(1,0.5){R}");
                }
            } else if ((double)pt.x < 0.3) {
                rotateAnchorsCommand.setNewSourceTerminal("(0.5,0){T}");
            } else if ((double)pt.x > 0.7) {
                rotateAnchorsCommand.setNewSourceTerminal("(0.5,1){D}");
            }
            compositeCmd.add((IUndoableOperation)rotateAnchorsCommand);
        }
        durationPart.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)compositeCmd));
    }

    private Rectangle getNewBounds(Rectangle bounds) {
        Point p = bounds.getCenter();
        return new Rectangle(p.x - bounds.height / 2, p.y - bounds.width / 2, bounds.height, bounds.width);
    }
}

