/*
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *
 * $Id: UMLItemProviderAdapterFactory.java,v 1.21 2007/05/04 20:35:56 khussey Exp $
 */
package org.eclipse.uml2.uml.edit.providers;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.uml2.common.edit.provider.IItemQualifiedTextProvider;

import org.eclipse.uml2.uml.util.UMLAdapterFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class UMLItemProviderAdapterFactory
		extends UMLAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public UMLItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);

		supportedTypes.add(IItemQualifiedTextProvider.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Comment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentItemProvider commentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Comment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentAdapter() {
		if (commentItemProvider == null) {
			commentItemProvider = new CommentItemProvider(this);
		}

		return commentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Package} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageItemProvider packageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Dependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDependencyAdapter() {
		if (dependencyItemProvider == null) {
			dependencyItemProvider = new DependencyItemProvider(this);
		}

		return dependencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ElementImport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElementImportItemProvider elementImportItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TemplateParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateParameterAdapter() {
		if (templateParameterItemProvider == null) {
			templateParameterItemProvider = new TemplateParameterItemProvider(
				this);
		}

		return templateParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TemplateParameterSubstitution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateParameterSubstitutionItemProvider templateParameterSubstitutionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TemplateSignature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateSignatureAdapter() {
		if (templateSignatureItemProvider == null) {
			templateSignatureItemProvider = new TemplateSignatureItemProvider(
				this);
		}

		return templateSignatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TemplateParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateParameterItemProvider templateParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TemplateBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateBindingAdapter() {
		if (templateBindingItemProvider == null) {
			templateBindingItemProvider = new TemplateBindingItemProvider(this);
		}

		return templateBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TemplateSignature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateSignatureItemProvider templateSignatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TemplateParameterSubstitution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateParameterSubstitutionAdapter() {
		if (templateParameterSubstitutionItemProvider == null) {
			templateParameterSubstitutionItemProvider = new TemplateParameterSubstitutionItemProvider(
				this);
		}

		return templateParameterSubstitutionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Generalization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeneralizationItemProvider generalizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ElementImport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElementImportAdapter() {
		if (elementImportItemProvider == null) {
			elementImportItemProvider = new ElementImportItemProvider(this);
		}

		return elementImportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.PackageImport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageImportItemProvider packageImportItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.PackageImport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageImportAdapter() {
		if (packageImportItemProvider == null) {
			packageImportItemProvider = new PackageImportItemProvider(this);
		}

		return packageImportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Constraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstraintItemProvider constraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Package}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageAdapter() {
		if (packageItemProvider == null) {
			packageItemProvider = new PackageItemProvider(this);
		}

		return packageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Dependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DependencyItemProvider dependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.PackageMerge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageMergeAdapter() {
		if (packageMergeItemProvider == null) {
			packageMergeItemProvider = new PackageMergeItemProvider(this);
		}

		return packageMergeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ProfileApplication} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProfileApplicationItemProvider profileApplicationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ProfileApplication}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProfileApplicationAdapter() {
		if (profileApplicationItemProvider == null) {
			profileApplicationItemProvider = new ProfileApplicationItemProvider(
				this);
		}

		return profileApplicationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Enumeration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumerationItemProvider enumerationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Profile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProfileAdapter() {
		if (profileItemProvider == null) {
			profileItemProvider = new ProfileItemProvider(this);
		}

		return profileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Model} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelItemProvider modelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Stereotype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStereotypeAdapter() {
		if (stereotypeItemProvider == null) {
			stereotypeItemProvider = new StereotypeItemProvider(this);
		}

		return stereotypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Image} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageItemProvider imageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Image}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImageAdapter() {
		if (imageItemProvider == null) {
			imageItemProvider = new ImageItemProvider(this);
		}

		return imageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Profile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProfileItemProvider profileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Class}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassAdapter() {
		if (classItemProvider == null) {
			classItemProvider = new ClassItemProvider(this);
		}

		return classItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InterfaceRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceRealizationItemProvider interfaceRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Generalization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeneralizationAdapter() {
		if (generalizationItemProvider == null) {
			generalizationItemProvider = new GeneralizationItemProvider(this);
		}

		return generalizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.GeneralizationSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeneralizationSetItemProvider generalizationSetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.GeneralizationSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeneralizationSetAdapter() {
		if (generalizationSetItemProvider == null) {
			generalizationSetItemProvider = new GeneralizationSetItemProvider(
				this);
		}

		return generalizationSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Substitution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubstitutionItemProvider substitutionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.UseCase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUseCaseAdapter() {
		if (useCaseItemProvider == null) {
			useCaseItemProvider = new UseCaseItemProvider(this);
		}

		return useCaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Include} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IncludeItemProvider includeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Include}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIncludeAdapter() {
		if (includeItemProvider == null) {
			includeItemProvider = new IncludeItemProvider(this);
		}

		return includeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Extend} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtendItemProvider extendItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Extend}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtendAdapter() {
		if (extendItemProvider == null) {
			extendItemProvider = new ExtendItemProvider(this);
		}

		return extendItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExtensionPoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtensionPointItemProvider extensionPointItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Constraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstraintAdapter() {
		if (constraintItemProvider == null) {
			constraintItemProvider = new ConstraintItemProvider(this);
		}

		return constraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Association} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssociationItemProvider associationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExtensionPoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtensionPointAdapter() {
		if (extensionPointItemProvider == null) {
			extensionPointItemProvider = new ExtensionPointItemProvider(this);
		}

		return extensionPointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.RedefinableTemplateSignature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RedefinableTemplateSignatureItemProvider redefinableTemplateSignatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Substitution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubstitutionAdapter() {
		if (substitutionItemProvider == null) {
			substitutionItemProvider = new SubstitutionItemProvider(this);
		}

		return substitutionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Realization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RealizationItemProvider realizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Realization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRealizationAdapter() {
		if (realizationItemProvider == null) {
			realizationItemProvider = new RealizationItemProvider(this);
		}

		return realizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Abstraction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractionItemProvider abstractionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Abstraction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstractionAdapter() {
		if (abstractionItemProvider == null) {
			abstractionItemProvider = new AbstractionItemProvider(this);
		}

		return abstractionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.OpaqueExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OpaqueExpressionItemProvider opaqueExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.OpaqueExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOpaqueExpressionAdapter() {
		if (opaqueExpressionItemProvider == null) {
			opaqueExpressionItemProvider = new OpaqueExpressionItemProvider(
				this);
		}

		return opaqueExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Parameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterItemProvider parameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Parameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterAdapter() {
		if (parameterItemProvider == null) {
			parameterItemProvider = new ParameterItemProvider(this);
		}

		return parameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ConnectorEnd} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectorEndItemProvider connectorEndItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ConnectorEnd}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectorEndAdapter() {
		if (connectorEndItemProvider == null) {
			connectorEndItemProvider = new ConnectorEndItemProvider(this);
		}

		return connectorEndItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Property} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyItemProvider propertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Property}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyAdapter() {
		if (propertyItemProvider == null) {
			propertyItemProvider = new PropertyItemProvider(this);
		}

		return propertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Deployment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeploymentItemProvider deploymentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Deployment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeploymentAdapter() {
		if (deploymentItemProvider == null) {
			deploymentItemProvider = new DeploymentItemProvider(this);
		}

		return deploymentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DeploymentSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeploymentSpecificationItemProvider deploymentSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DeploymentSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeploymentSpecificationAdapter() {
		if (deploymentSpecificationItemProvider == null) {
			deploymentSpecificationItemProvider = new DeploymentSpecificationItemProvider(
				this);
		}

		return deploymentSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Artifact} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArtifactItemProvider artifactItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Artifact}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArtifactAdapter() {
		if (artifactItemProvider == null) {
			artifactItemProvider = new ArtifactItemProvider(this);
		}

		return artifactItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Manifestation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManifestationItemProvider manifestationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Manifestation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManifestationAdapter() {
		if (manifestationItemProvider == null) {
			manifestationItemProvider = new ManifestationItemProvider(this);
		}

		return manifestationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Operation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationItemProvider operationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Operation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationAdapter() {
		if (operationItemProvider == null) {
			operationItemProvider = new OperationItemProvider(this);
		}

		return operationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Class} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassItemProvider classItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ParameterSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterSetAdapter() {
		if (parameterSetItemProvider == null) {
			parameterSetItemProvider = new ParameterSetItemProvider(this);
		}

		return parameterSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DataType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataTypeItemProvider dataTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DataType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataTypeAdapter() {
		if (dataTypeItemProvider == null) {
			dataTypeItemProvider = new DataTypeItemProvider(this);
		}

		return dataTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.OperationTemplateParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationTemplateParameterItemProvider operationTemplateParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Interface}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfaceAdapter() {
		if (interfaceItemProvider == null) {
			interfaceItemProvider = new InterfaceItemProvider(this);
		}

		return interfaceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Reception} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReceptionItemProvider receptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Reception}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReceptionAdapter() {
		if (receptionItemProvider == null) {
			receptionItemProvider = new ReceptionItemProvider(this);
		}

		return receptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Signal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalItemProvider signalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Signal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalAdapter() {
		if (signalItemProvider == null) {
			signalItemProvider = new SignalItemProvider(this);
		}

		return signalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ProtocolStateMachine} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProtocolStateMachineItemProvider protocolStateMachineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ProtocolStateMachine}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProtocolStateMachineAdapter() {
		if (protocolStateMachineItemProvider == null) {
			protocolStateMachineItemProvider = new ProtocolStateMachineItemProvider(
				this);
		}

		return protocolStateMachineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.StateMachine} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateMachineItemProvider stateMachineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.StateMachine}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateMachineAdapter() {
		if (stateMachineItemProvider == null) {
			stateMachineItemProvider = new StateMachineItemProvider(this);
		}

		return stateMachineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Region} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegionItemProvider regionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Region}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegionAdapter() {
		if (regionItemProvider == null) {
			regionItemProvider = new RegionItemProvider(this);
		}

		return regionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Transition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransitionItemProvider transitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Transition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransitionAdapter() {
		if (transitionItemProvider == null) {
			transitionItemProvider = new TransitionItemProvider(this);
		}

		return transitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Trigger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TriggerItemProvider triggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Trigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTriggerAdapter() {
		if (triggerItemProvider == null) {
			triggerItemProvider = new TriggerItemProvider(this);
		}

		return triggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Port} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PortItemProvider portItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Port}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPortAdapter() {
		if (portItemProvider == null) {
			portItemProvider = new PortItemProvider(this);
		}

		return portItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.State} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateItemProvider stateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.State}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateAdapter() {
		if (stateItemProvider == null) {
			stateItemProvider = new StateItemProvider(this);
		}

		return stateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ConnectionPointReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectionPointReferenceItemProvider connectionPointReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ConnectionPointReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectionPointReferenceAdapter() {
		if (connectionPointReferenceItemProvider == null) {
			connectionPointReferenceItemProvider = new ConnectionPointReferenceItemProvider(
				this);
		}

		return connectionPointReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Pseudostate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PseudostateItemProvider pseudostateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Pseudostate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPseudostateAdapter() {
		if (pseudostateItemProvider == null) {
			pseudostateItemProvider = new PseudostateItemProvider(this);
		}

		return pseudostateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ProtocolConformance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProtocolConformanceItemProvider protocolConformanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ProtocolConformance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProtocolConformanceAdapter() {
		if (protocolConformanceItemProvider == null) {
			protocolConformanceItemProvider = new ProtocolConformanceItemProvider(
				this);
		}

		return protocolConformanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Connector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectorItemProvider connectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.OperationTemplateParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationTemplateParameterAdapter() {
		if (operationTemplateParameterItemProvider == null) {
			operationTemplateParameterItemProvider = new OperationTemplateParameterItemProvider(
				this);
		}

		return operationTemplateParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ConnectableElementTemplateParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectableElementTemplateParameterItemProvider connectableElementTemplateParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Association}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssociationAdapter() {
		if (associationItemProvider == null) {
			associationItemProvider = new AssociationItemProvider(this);
		}

		return associationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TemplateBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateBindingItemProvider templateBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ConnectableElementTemplateParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectableElementTemplateParameterAdapter() {
		if (connectableElementTemplateParameterItemProvider == null) {
			connectableElementTemplateParameterItemProvider = new ConnectableElementTemplateParameterItemProvider(
				this);
		}

		return connectableElementTemplateParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CollaborationUse} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollaborationUseItemProvider collaborationUseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CollaborationUse}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollaborationUseAdapter() {
		if (collaborationUseItemProvider == null) {
			collaborationUseItemProvider = new CollaborationUseItemProvider(
				this);
		}

		return collaborationUseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Collaboration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollaborationItemProvider collaborationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Collaboration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollaborationAdapter() {
		if (collaborationItemProvider == null) {
			collaborationItemProvider = new CollaborationItemProvider(this);
		}

		return collaborationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.UseCase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UseCaseItemProvider useCaseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Connector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectorAdapter() {
		if (connectorItemProvider == null) {
			connectorItemProvider = new ConnectorItemProvider(this);
		}

		return connectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Extension} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtensionItemProvider extensionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.RedefinableTemplateSignature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRedefinableTemplateSignatureAdapter() {
		if (redefinableTemplateSignatureItemProvider == null) {
			redefinableTemplateSignatureItemProvider = new RedefinableTemplateSignatureItemProvider(
				this);
		}

		return redefinableTemplateSignatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ClassifierTemplateParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassifierTemplateParameterItemProvider classifierTemplateParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ClassifierTemplateParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassifierTemplateParameterAdapter() {
		if (classifierTemplateParameterItemProvider == null) {
			classifierTemplateParameterItemProvider = new ClassifierTemplateParameterItemProvider(
				this);
		}

		return classifierTemplateParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.StringExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringExpressionItemProvider stringExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InterfaceRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfaceRealizationAdapter() {
		if (interfaceRealizationItemProvider == null) {
			interfaceRealizationItemProvider = new InterfaceRealizationItemProvider(
				this);
		}

		return interfaceRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Interface} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceItemProvider interfaceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Extension}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtensionAdapter() {
		if (extensionItemProvider == null) {
			extensionItemProvider = new ExtensionItemProvider(this);
		}

		return extensionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExtensionEnd} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtensionEndItemProvider extensionEndItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExtensionEnd}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtensionEndAdapter() {
		if (extensionEndItemProvider == null) {
			extensionEndItemProvider = new ExtensionEndItemProvider(this);
		}

		return extensionEndItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Stereotype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StereotypeItemProvider stereotypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.StringExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringExpressionAdapter() {
		if (stringExpressionItemProvider == null) {
			stringExpressionItemProvider = new StringExpressionItemProvider(
				this);
		}

		return stringExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Expression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionItemProvider expressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Expression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionAdapter() {
		if (expressionItemProvider == null) {
			expressionItemProvider = new ExpressionItemProvider(this);
		}

		return expressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.PackageMerge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageMergeItemProvider packageMergeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LiteralInteger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLiteralIntegerAdapter() {
		if (literalIntegerItemProvider == null) {
			literalIntegerItemProvider = new LiteralIntegerItemProvider(this);
		}

		return literalIntegerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LiteralString} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LiteralStringItemProvider literalStringItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LiteralString}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLiteralStringAdapter() {
		if (literalStringItemProvider == null) {
			literalStringItemProvider = new LiteralStringItemProvider(this);
		}

		return literalStringItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LiteralBoolean} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LiteralBooleanItemProvider literalBooleanItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LiteralBoolean}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLiteralBooleanAdapter() {
		if (literalBooleanItemProvider == null) {
			literalBooleanItemProvider = new LiteralBooleanItemProvider(this);
		}

		return literalBooleanItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LiteralNull} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LiteralNullItemProvider literalNullItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LiteralNull}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLiteralNullAdapter() {
		if (literalNullItemProvider == null) {
			literalNullItemProvider = new LiteralNullItemProvider(this);
		}

		return literalNullItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InstanceValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceValueItemProvider instanceValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Slot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSlotAdapter() {
		if (slotItemProvider == null) {
			slotItemProvider = new SlotItemProvider(this);
		}

		return slotItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.PrimitiveType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeItemProvider primitiveTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InstanceSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanceSpecificationAdapter() {
		if (instanceSpecificationItemProvider == null) {
			instanceSpecificationItemProvider = new InstanceSpecificationItemProvider(
				this);
		}

		return instanceSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Slot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SlotItemProvider slotItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Enumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumerationAdapter() {
		if (enumerationItemProvider == null) {
			enumerationItemProvider = new EnumerationItemProvider(this);
		}

		return enumerationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.EnumerationLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumerationLiteralItemProvider enumerationLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.EnumerationLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumerationLiteralAdapter() {
		if (enumerationLiteralItemProvider == null) {
			enumerationLiteralItemProvider = new EnumerationLiteralItemProvider(
				this);
		}

		return enumerationLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InstanceSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceSpecificationItemProvider instanceSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.PrimitiveType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeAdapter() {
		if (primitiveTypeItemProvider == null) {
			primitiveTypeItemProvider = new PrimitiveTypeItemProvider(this);
		}

		return primitiveTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LiteralInteger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LiteralIntegerItemProvider literalIntegerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InstanceValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanceValueAdapter() {
		if (instanceValueItemProvider == null) {
			instanceValueItemProvider = new InstanceValueItemProvider(this);
		}

		return instanceValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LiteralUnlimitedNatural} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LiteralUnlimitedNaturalItemProvider literalUnlimitedNaturalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LiteralUnlimitedNatural}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLiteralUnlimitedNaturalAdapter() {
		if (literalUnlimitedNaturalItemProvider == null) {
			literalUnlimitedNaturalItemProvider = new LiteralUnlimitedNaturalItemProvider(
				this);
		}

		return literalUnlimitedNaturalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.OpaqueBehavior} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OpaqueBehaviorItemProvider opaqueBehaviorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.OpaqueBehavior}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOpaqueBehaviorAdapter() {
		if (opaqueBehaviorItemProvider == null) {
			opaqueBehaviorItemProvider = new OpaqueBehaviorItemProvider(this);
		}

		return opaqueBehaviorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.FunctionBehavior} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionBehaviorItemProvider functionBehaviorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.FunctionBehavior}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionBehaviorAdapter() {
		if (functionBehaviorItemProvider == null) {
			functionBehaviorItemProvider = new FunctionBehaviorItemProvider(
				this);
		}

		return functionBehaviorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.OpaqueAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OpaqueActionItemProvider opaqueActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Actor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActorAdapter() {
		if (actorItemProvider == null) {
			actorItemProvider = new ActorItemProvider(this);
		}

		return actorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CallEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallEventItemProvider callEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Usage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUsageAdapter() {
		if (usageItemProvider == null) {
			usageItemProvider = new UsageItemProvider(this);
		}

		return usageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ControlFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControlFlowItemProvider controlFlowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Message}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageAdapter() {
		if (messageItemProvider == null) {
			messageItemProvider = new MessageItemProvider(this);
		}

		return messageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Interaction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteractionItemProvider interactionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Interaction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInteractionAdapter() {
		if (interactionItemProvider == null) {
			interactionItemProvider = new InteractionItemProvider(this);
		}

		return interactionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Lifeline} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LifelineItemProvider lifelineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Lifeline}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLifelineAdapter() {
		if (lifelineItemProvider == null) {
			lifelineItemProvider = new LifelineItemProvider(this);
		}

		return lifelineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.PartDecomposition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartDecompositionItemProvider partDecompositionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.PartDecomposition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartDecompositionAdapter() {
		if (partDecompositionItemProvider == null) {
			partDecompositionItemProvider = new PartDecompositionItemProvider(
				this);
		}

		return partDecompositionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InteractionUse} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteractionUseItemProvider interactionUseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InteractionUse}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInteractionUseAdapter() {
		if (interactionUseItemProvider == null) {
			interactionUseItemProvider = new InteractionUseItemProvider(this);
		}

		return interactionUseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Gate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GateItemProvider gateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Gate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGateAdapter() {
		if (gateItemProvider == null) {
			gateItemProvider = new GateItemProvider(this);
		}

		return gateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.GeneralOrdering} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeneralOrderingItemProvider generalOrderingItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.StructuredActivityNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructuredActivityNodeItemProvider structuredActivityNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Activity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityAdapter() {
		if (activityItemProvider == null) {
			activityItemProvider = new ActivityItemProvider(this);
		}

		return activityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Variable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableItemProvider variableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ActivityPartition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityPartitionAdapter() {
		if (activityPartitionItemProvider == null) {
			activityPartitionItemProvider = new ActivityPartitionItemProvider(
				this);
		}

		return activityPartitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InterruptibleActivityRegion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterruptibleActivityRegionItemProvider interruptibleActivityRegionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.StructuredActivityNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructuredActivityNodeAdapter() {
		if (structuredActivityNodeItemProvider == null) {
			structuredActivityNodeItemProvider = new StructuredActivityNodeItemProvider(
				this);
		}

		return structuredActivityNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Activity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityItemProvider activityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Variable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAdapter() {
		if (variableItemProvider == null) {
			variableItemProvider = new VariableItemProvider(this);
		}

		return variableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ActivityPartition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityPartitionItemProvider activityPartitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InterruptibleActivityRegion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterruptibleActivityRegionAdapter() {
		if (interruptibleActivityRegionItemProvider == null) {
			interruptibleActivityRegionItemProvider = new InterruptibleActivityRegionItemProvider(
				this);
		}

		return interruptibleActivityRegionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExceptionHandler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExceptionHandlerItemProvider exceptionHandlerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExceptionHandler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExceptionHandlerAdapter() {
		if (exceptionHandlerItemProvider == null) {
			exceptionHandlerItemProvider = new ExceptionHandlerItemProvider(
				this);
		}

		return exceptionHandlerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.OutputPin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutputPinItemProvider outputPinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.OutputPin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutputPinAdapter() {
		if (outputPinItemProvider == null) {
			outputPinItemProvider = new OutputPinItemProvider(this);
		}

		return outputPinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Pin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PinItemProvider pinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Pin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPinAdapter() {
		if (pinItemProvider == null) {
			pinItemProvider = new PinItemProvider(this);
		}

		return pinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InputPin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InputPinItemProvider inputPinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InputPin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInputPinAdapter() {
		if (inputPinItemProvider == null) {
			inputPinItemProvider = new InputPinItemProvider(this);
		}

		return inputPinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ValuePin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValuePinItemProvider valuePinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.GeneralOrdering}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeneralOrderingAdapter() {
		if (generalOrderingItemProvider == null) {
			generalOrderingItemProvider = new GeneralOrderingItemProvider(this);
		}

		return generalOrderingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.OccurrenceSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OccurrenceSpecificationItemProvider occurrenceSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.OccurrenceSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOccurrenceSpecificationAdapter() {
		if (occurrenceSpecificationItemProvider == null) {
			occurrenceSpecificationItemProvider = new OccurrenceSpecificationItemProvider(
				this);
		}

		return occurrenceSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InteractionOperand} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteractionOperandItemProvider interactionOperandItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InteractionOperand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInteractionOperandAdapter() {
		if (interactionOperandItemProvider == null) {
			interactionOperandItemProvider = new InteractionOperandItemProvider(
				this);
		}

		return interactionOperandItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InteractionConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteractionConstraintItemProvider interactionConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InteractionConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInteractionConstraintAdapter() {
		if (interactionConstraintItemProvider == null) {
			interactionConstraintItemProvider = new InteractionConstraintItemProvider(
				this);
		}

		return interactionConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExecutionOccurrenceSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionOccurrenceSpecificationItemProvider executionOccurrenceSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExecutionOccurrenceSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionOccurrenceSpecificationAdapter() {
		if (executionOccurrenceSpecificationItemProvider == null) {
			executionOccurrenceSpecificationItemProvider = new ExecutionOccurrenceSpecificationItemProvider(
				this);
		}

		return executionOccurrenceSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExecutionEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionEventItemProvider executionEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExecutionEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionEventAdapter() {
		if (executionEventItemProvider == null) {
			executionEventItemProvider = new ExecutionEventItemProvider(this);
		}

		return executionEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.StateInvariant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateInvariantItemProvider stateInvariantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.StateInvariant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateInvariantAdapter() {
		if (stateInvariantItemProvider == null) {
			stateInvariantItemProvider = new StateInvariantItemProvider(this);
		}

		return stateInvariantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ActionExecutionSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActionExecutionSpecificationItemProvider actionExecutionSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ActionExecutionSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActionExecutionSpecificationAdapter() {
		if (actionExecutionSpecificationItemProvider == null) {
			actionExecutionSpecificationItemProvider = new ActionExecutionSpecificationItemProvider(
				this);
		}

		return actionExecutionSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.BehaviorExecutionSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BehaviorExecutionSpecificationItemProvider behaviorExecutionSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.BehaviorExecutionSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBehaviorExecutionSpecificationAdapter() {
		if (behaviorExecutionSpecificationItemProvider == null) {
			behaviorExecutionSpecificationItemProvider = new BehaviorExecutionSpecificationItemProvider(
				this);
		}

		return behaviorExecutionSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CreationEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CreationEventItemProvider creationEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CreationEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCreationEventAdapter() {
		if (creationEventItemProvider == null) {
			creationEventItemProvider = new CreationEventItemProvider(this);
		}

		return creationEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DestructionEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DestructionEventItemProvider destructionEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DestructionEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDestructionEventAdapter() {
		if (destructionEventItemProvider == null) {
			destructionEventItemProvider = new DestructionEventItemProvider(
				this);
		}

		return destructionEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.SendOperationEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SendOperationEventItemProvider sendOperationEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.SendOperationEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSendOperationEventAdapter() {
		if (sendOperationEventItemProvider == null) {
			sendOperationEventItemProvider = new SendOperationEventItemProvider(
				this);
		}

		return sendOperationEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.SendSignalEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SendSignalEventItemProvider sendSignalEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.SendSignalEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSendSignalEventAdapter() {
		if (sendSignalEventItemProvider == null) {
			sendSignalEventItemProvider = new SendSignalEventItemProvider(this);
		}

		return sendSignalEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.MessageOccurrenceSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageOccurrenceSpecificationItemProvider messageOccurrenceSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.MessageOccurrenceSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageOccurrenceSpecificationAdapter() {
		if (messageOccurrenceSpecificationItemProvider == null) {
			messageOccurrenceSpecificationItemProvider = new MessageOccurrenceSpecificationItemProvider(
				this);
		}

		return messageOccurrenceSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReceiveOperationEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReceiveOperationEventItemProvider receiveOperationEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReceiveOperationEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReceiveOperationEventAdapter() {
		if (receiveOperationEventItemProvider == null) {
			receiveOperationEventItemProvider = new ReceiveOperationEventItemProvider(
				this);
		}

		return receiveOperationEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReceiveSignalEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReceiveSignalEventItemProvider receiveSignalEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReceiveSignalEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReceiveSignalEventAdapter() {
		if (receiveSignalEventItemProvider == null) {
			receiveSignalEventItemProvider = new ReceiveSignalEventItemProvider(
				this);
		}

		return receiveSignalEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Actor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActorItemProvider actorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CombinedFragment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCombinedFragmentAdapter() {
		if (combinedFragmentItemProvider == null) {
			combinedFragmentItemProvider = new CombinedFragmentItemProvider(
				this);
		}

		return combinedFragmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Continuation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContinuationItemProvider continuationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Continuation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContinuationAdapter() {
		if (continuationItemProvider == null) {
			continuationItemProvider = new ContinuationItemProvider(this);
		}

		return continuationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ConsiderIgnoreFragment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConsiderIgnoreFragmentItemProvider considerIgnoreFragmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ConsiderIgnoreFragment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConsiderIgnoreFragmentAdapter() {
		if (considerIgnoreFragmentItemProvider == null) {
			considerIgnoreFragmentItemProvider = new ConsiderIgnoreFragmentItemProvider(
				this);
		}

		return considerIgnoreFragmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CreateObjectAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CreateObjectActionItemProvider createObjectActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CallEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallEventAdapter() {
		if (callEventItemProvider == null) {
			callEventItemProvider = new CallEventItemProvider(this);
		}

		return callEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ChangeEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChangeEventItemProvider changeEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ChangeEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChangeEventAdapter() {
		if (changeEventItemProvider == null) {
			changeEventItemProvider = new ChangeEventItemProvider(this);
		}

		return changeEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.SignalEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalEventItemProvider signalEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.SignalEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalEventAdapter() {
		if (signalEventItemProvider == null) {
			signalEventItemProvider = new SignalEventItemProvider(this);
		}

		return signalEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.AnyReceiveEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnyReceiveEventItemProvider anyReceiveEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.AnyReceiveEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnyReceiveEventAdapter() {
		if (anyReceiveEventItemProvider == null) {
			anyReceiveEventItemProvider = new AnyReceiveEventItemProvider(this);
		}

		return anyReceiveEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ForkNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForkNodeItemProvider forkNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CreateObjectAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCreateObjectActionAdapter() {
		if (createObjectActionItemProvider == null) {
			createObjectActionItemProvider = new CreateObjectActionItemProvider(
				this);
		}

		return createObjectActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DestroyObjectAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DestroyObjectActionItemProvider destroyObjectActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DestroyObjectAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDestroyObjectActionAdapter() {
		if (destroyObjectActionItemProvider == null) {
			destroyObjectActionItemProvider = new DestroyObjectActionItemProvider(
				this);
		}

		return destroyObjectActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TestIdentityAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TestIdentityActionItemProvider testIdentityActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TestIdentityAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTestIdentityActionAdapter() {
		if (testIdentityActionItemProvider == null) {
			testIdentityActionItemProvider = new TestIdentityActionItemProvider(
				this);
		}

		return testIdentityActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadSelfAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadSelfActionItemProvider readSelfActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadSelfAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadSelfActionAdapter() {
		if (readSelfActionItemProvider == null) {
			readSelfActionItemProvider = new ReadSelfActionItemProvider(this);
		}

		return readSelfActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadStructuralFeatureAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadStructuralFeatureActionItemProvider readStructuralFeatureActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadStructuralFeatureAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadStructuralFeatureActionAdapter() {
		if (readStructuralFeatureActionItemProvider == null) {
			readStructuralFeatureActionItemProvider = new ReadStructuralFeatureActionItemProvider(
				this);
		}

		return readStructuralFeatureActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ClearStructuralFeatureAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearStructuralFeatureActionItemProvider clearStructuralFeatureActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ClearStructuralFeatureAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClearStructuralFeatureActionAdapter() {
		if (clearStructuralFeatureActionItemProvider == null) {
			clearStructuralFeatureActionItemProvider = new ClearStructuralFeatureActionItemProvider(
				this);
		}

		return clearStructuralFeatureActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.RemoveStructuralFeatureValueAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RemoveStructuralFeatureValueActionItemProvider removeStructuralFeatureValueActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.RemoveStructuralFeatureValueAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRemoveStructuralFeatureValueActionAdapter() {
		if (removeStructuralFeatureValueActionItemProvider == null) {
			removeStructuralFeatureValueActionItemProvider = new RemoveStructuralFeatureValueActionItemProvider(
				this);
		}

		return removeStructuralFeatureValueActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.AddStructuralFeatureValueAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AddStructuralFeatureValueActionItemProvider addStructuralFeatureValueActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.AddStructuralFeatureValueAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAddStructuralFeatureValueActionAdapter() {
		if (addStructuralFeatureValueActionItemProvider == null) {
			addStructuralFeatureValueActionItemProvider = new AddStructuralFeatureValueActionItemProvider(
				this);
		}

		return addStructuralFeatureValueActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LinkEndData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkEndDataItemProvider linkEndDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LinkEndData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkEndDataAdapter() {
		if (linkEndDataItemProvider == null) {
			linkEndDataItemProvider = new LinkEndDataItemProvider(this);
		}

		return linkEndDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.QualifierValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QualifierValueItemProvider qualifierValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.QualifierValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQualifierValueAdapter() {
		if (qualifierValueItemProvider == null) {
			qualifierValueItemProvider = new QualifierValueItemProvider(this);
		}

		return qualifierValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadLinkAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadLinkActionItemProvider readLinkActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadLinkAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadLinkActionAdapter() {
		if (readLinkActionItemProvider == null) {
			readLinkActionItemProvider = new ReadLinkActionItemProvider(this);
		}

		return readLinkActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LinkEndCreationData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkEndCreationDataItemProvider linkEndCreationDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LinkEndCreationData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkEndCreationDataAdapter() {
		if (linkEndCreationDataItemProvider == null) {
			linkEndCreationDataItemProvider = new LinkEndCreationDataItemProvider(
				this);
		}

		return linkEndCreationDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CreateLinkAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CreateLinkActionItemProvider createLinkActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CreateLinkAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCreateLinkActionAdapter() {
		if (createLinkActionItemProvider == null) {
			createLinkActionItemProvider = new CreateLinkActionItemProvider(
				this);
		}

		return createLinkActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DestroyLinkAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DestroyLinkActionItemProvider destroyLinkActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DestroyLinkAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDestroyLinkActionAdapter() {
		if (destroyLinkActionItemProvider == null) {
			destroyLinkActionItemProvider = new DestroyLinkActionItemProvider(
				this);
		}

		return destroyLinkActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LinkEndDestructionData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinkEndDestructionDataItemProvider linkEndDestructionDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LinkEndDestructionData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinkEndDestructionDataAdapter() {
		if (linkEndDestructionDataItemProvider == null) {
			linkEndDestructionDataItemProvider = new LinkEndDestructionDataItemProvider(
				this);
		}

		return linkEndDestructionDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ClearAssociationAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearAssociationActionItemProvider clearAssociationActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ClearAssociationAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClearAssociationActionAdapter() {
		if (clearAssociationActionItemProvider == null) {
			clearAssociationActionItemProvider = new ClearAssociationActionItemProvider(
				this);
		}

		return clearAssociationActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.BroadcastSignalAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BroadcastSignalActionItemProvider broadcastSignalActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.BroadcastSignalAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBroadcastSignalActionAdapter() {
		if (broadcastSignalActionItemProvider == null) {
			broadcastSignalActionItemProvider = new BroadcastSignalActionItemProvider(
				this);
		}

		return broadcastSignalActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.SendObjectAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SendObjectActionItemProvider sendObjectActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.SendObjectAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSendObjectActionAdapter() {
		if (sendObjectActionItemProvider == null) {
			sendObjectActionItemProvider = new SendObjectActionItemProvider(
				this);
		}

		return sendObjectActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ValueSpecificationAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValueSpecificationActionItemProvider valueSpecificationActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ValueSpecificationAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValueSpecificationActionAdapter() {
		if (valueSpecificationActionItemProvider == null) {
			valueSpecificationActionItemProvider = new ValueSpecificationActionItemProvider(
				this);
		}

		return valueSpecificationActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TimeExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeExpressionItemProvider timeExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TimeExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeExpressionAdapter() {
		if (timeExpressionItemProvider == null) {
			timeExpressionItemProvider = new TimeExpressionItemProvider(this);
		}

		return timeExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Duration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DurationItemProvider durationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Duration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDurationAdapter() {
		if (durationItemProvider == null) {
			durationItemProvider = new DurationItemProvider(this);
		}

		return durationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DurationInterval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DurationIntervalItemProvider durationIntervalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ValuePin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValuePinAdapter() {
		if (valuePinItemProvider == null) {
			valuePinItemProvider = new ValuePinItemProvider(this);
		}

		return valuePinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.SendSignalAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SendSignalActionItemProvider sendSignalActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DurationInterval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDurationIntervalAdapter() {
		if (durationIntervalItemProvider == null) {
			durationIntervalItemProvider = new DurationIntervalItemProvider(
				this);
		}

		return durationIntervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Interval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntervalItemProvider intervalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Interval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntervalAdapter() {
		if (intervalItemProvider == null) {
			intervalItemProvider = new IntervalItemProvider(this);
		}

		return intervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TimeConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeConstraintItemProvider timeConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TimeConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeConstraintAdapter() {
		if (timeConstraintItemProvider == null) {
			timeConstraintItemProvider = new TimeConstraintItemProvider(this);
		}

		return timeConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.IntervalConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntervalConstraintItemProvider intervalConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.IntervalConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntervalConstraintAdapter() {
		if (intervalConstraintItemProvider == null) {
			intervalConstraintItemProvider = new IntervalConstraintItemProvider(
				this);
		}

		return intervalConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TimeInterval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeIntervalItemProvider timeIntervalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TimeInterval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeIntervalAdapter() {
		if (timeIntervalItemProvider == null) {
			timeIntervalItemProvider = new TimeIntervalItemProvider(this);
		}

		return timeIntervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DurationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DurationConstraintItemProvider durationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DurationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDurationConstraintAdapter() {
		if (durationConstraintItemProvider == null) {
			durationConstraintItemProvider = new DurationConstraintItemProvider(
				this);
		}

		return durationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TimeObservation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeObservationItemProvider timeObservationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TimeObservation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeObservationAdapter() {
		if (timeObservationItemProvider == null) {
			timeObservationItemProvider = new TimeObservationItemProvider(this);
		}

		return timeObservationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DurationObservation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DurationObservationItemProvider durationObservationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DurationObservation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDurationObservationAdapter() {
		if (durationObservationItemProvider == null) {
			durationObservationItemProvider = new DurationObservationItemProvider(
				this);
		}

		return durationObservationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.FinalState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FinalStateItemProvider finalStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.OpaqueAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOpaqueActionAdapter() {
		if (opaqueActionItemProvider == null) {
			opaqueActionItemProvider = new OpaqueActionItemProvider(this);
		}

		return opaqueActionItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.SendSignalAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSendSignalActionAdapter() {
		if (sendSignalActionItemProvider == null) {
			sendSignalActionItemProvider = new SendSignalActionItemProvider(
				this);
		}

		return sendSignalActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CallOperationAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallOperationActionItemProvider callOperationActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CallOperationAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallOperationActionAdapter() {
		if (callOperationActionItemProvider == null) {
			callOperationActionItemProvider = new CallOperationActionItemProvider(
				this);
		}

		return callOperationActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CallBehaviorAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallBehaviorActionItemProvider callBehaviorActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CallBehaviorAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallBehaviorActionAdapter() {
		if (callBehaviorActionItemProvider == null) {
			callBehaviorActionItemProvider = new CallBehaviorActionItemProvider(
				this);
		}

		return callBehaviorActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.SequenceNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequenceNodeItemProvider sequenceNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InformationItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInformationItemAdapter() {
		if (informationItemItemProvider == null) {
			informationItemItemProvider = new InformationItemItemProvider(this);
		}

		return informationItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InformationFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InformationFlowItemProvider informationFlowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InformationFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInformationFlowAdapter() {
		if (informationFlowItemProvider == null) {
			informationFlowItemProvider = new InformationFlowItemProvider(this);
		}

		return informationFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadExtentAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadExtentActionItemProvider readExtentActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Model}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelAdapter() {
		if (modelItemProvider == null) {
			modelItemProvider = new ModelItemProvider(this);
		}

		return modelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ParameterSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterSetItemProvider parameterSetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadVariableAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadVariableActionAdapter() {
		if (readVariableActionItemProvider == null) {
			readVariableActionItemProvider = new ReadVariableActionItemProvider(
				this);
		}

		return readVariableActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ClearVariableAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearVariableActionItemProvider clearVariableActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ClearVariableAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClearVariableActionAdapter() {
		if (clearVariableActionItemProvider == null) {
			clearVariableActionItemProvider = new ClearVariableActionItemProvider(
				this);
		}

		return clearVariableActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.AddVariableValueAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AddVariableValueActionItemProvider addVariableValueActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.AddVariableValueAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAddVariableValueActionAdapter() {
		if (addVariableValueActionItemProvider == null) {
			addVariableValueActionItemProvider = new AddVariableValueActionItemProvider(
				this);
		}

		return addVariableValueActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.RemoveVariableValueAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RemoveVariableValueActionItemProvider removeVariableValueActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.RemoveVariableValueAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRemoveVariableValueActionAdapter() {
		if (removeVariableValueActionItemProvider == null) {
			removeVariableValueActionItemProvider = new RemoveVariableValueActionItemProvider(
				this);
		}

		return removeVariableValueActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.RaiseExceptionAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RaiseExceptionActionItemProvider raiseExceptionActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.RaiseExceptionAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRaiseExceptionActionAdapter() {
		if (raiseExceptionActionItemProvider == null) {
			raiseExceptionActionItemProvider = new RaiseExceptionActionItemProvider(
				this);
		}

		return raiseExceptionActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ActionInputPin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActionInputPinItemProvider actionInputPinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ActionInputPin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActionInputPinAdapter() {
		if (actionInputPinItemProvider == null) {
			actionInputPinItemProvider = new ActionInputPinItemProvider(this);
		}

		return actionInputPinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InformationItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InformationItemItemProvider informationItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadExtentAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadExtentActionAdapter() {
		if (readExtentActionItemProvider == null) {
			readExtentActionItemProvider = new ReadExtentActionItemProvider(
				this);
		}

		return readExtentActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReclassifyObjectAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReclassifyObjectActionItemProvider reclassifyObjectActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReclassifyObjectAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReclassifyObjectActionAdapter() {
		if (reclassifyObjectActionItemProvider == null) {
			reclassifyObjectActionItemProvider = new ReclassifyObjectActionItemProvider(
				this);
		}

		return reclassifyObjectActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadIsClassifiedObjectAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadIsClassifiedObjectActionItemProvider readIsClassifiedObjectActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadIsClassifiedObjectAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadIsClassifiedObjectActionAdapter() {
		if (readIsClassifiedObjectActionItemProvider == null) {
			readIsClassifiedObjectActionItemProvider = new ReadIsClassifiedObjectActionItemProvider(
				this);
		}

		return readIsClassifiedObjectActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.StartClassifierBehaviorAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StartClassifierBehaviorActionItemProvider startClassifierBehaviorActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.StartClassifierBehaviorAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStartClassifierBehaviorActionAdapter() {
		if (startClassifierBehaviorActionItemProvider == null) {
			startClassifierBehaviorActionItemProvider = new StartClassifierBehaviorActionItemProvider(
				this);
		}

		return startClassifierBehaviorActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadLinkObjectEndAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadLinkObjectEndActionItemProvider readLinkObjectEndActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadLinkObjectEndAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadLinkObjectEndActionAdapter() {
		if (readLinkObjectEndActionItemProvider == null) {
			readLinkObjectEndActionItemProvider = new ReadLinkObjectEndActionItemProvider(
				this);
		}

		return readLinkObjectEndActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadLinkObjectEndQualifierAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadLinkObjectEndQualifierActionItemProvider readLinkObjectEndQualifierActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReadLinkObjectEndQualifierAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReadLinkObjectEndQualifierActionAdapter() {
		if (readLinkObjectEndQualifierActionItemProvider == null) {
			readLinkObjectEndQualifierActionItemProvider = new ReadLinkObjectEndQualifierActionItemProvider(
				this);
		}

		return readLinkObjectEndQualifierActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CreateLinkObjectAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CreateLinkObjectActionItemProvider createLinkObjectActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CreateLinkObjectAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCreateLinkObjectActionAdapter() {
		if (createLinkObjectActionItemProvider == null) {
			createLinkObjectActionItemProvider = new CreateLinkObjectActionItemProvider(
				this);
		}

		return createLinkObjectActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.AcceptEventAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AcceptEventActionItemProvider acceptEventActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.AcceptEventAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAcceptEventActionAdapter() {
		if (acceptEventActionItemProvider == null) {
			acceptEventActionItemProvider = new AcceptEventActionItemProvider(
				this);
		}

		return acceptEventActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.AcceptCallAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AcceptCallActionItemProvider acceptCallActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.AcceptCallAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAcceptCallActionAdapter() {
		if (acceptCallActionItemProvider == null) {
			acceptCallActionItemProvider = new AcceptCallActionItemProvider(
				this);
		}

		return acceptCallActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReplyAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReplyActionItemProvider replyActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReplyAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReplyActionAdapter() {
		if (replyActionItemProvider == null) {
			replyActionItemProvider = new ReplyActionItemProvider(this);
		}

		return replyActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.UnmarshallAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnmarshallActionItemProvider unmarshallActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.UnmarshallAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnmarshallActionAdapter() {
		if (unmarshallActionItemProvider == null) {
			unmarshallActionItemProvider = new UnmarshallActionItemProvider(
				this);
		}

		return unmarshallActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReduceAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReduceActionItemProvider reduceActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ReduceAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReduceActionAdapter() {
		if (reduceActionItemProvider == null) {
			reduceActionItemProvider = new ReduceActionItemProvider(this);
		}

		return reduceActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.JoinNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoinNodeItemProvider joinNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ControlFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createControlFlowAdapter() {
		if (controlFlowItemProvider == null) {
			controlFlowItemProvider = new ControlFlowItemProvider(this);
		}

		return controlFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.InitialNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InitialNodeItemProvider initialNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.InitialNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInitialNodeAdapter() {
		if (initialNodeItemProvider == null) {
			initialNodeItemProvider = new InitialNodeItemProvider(this);
		}

		return initialNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ActivityParameterNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityParameterNodeItemProvider activityParameterNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ActivityParameterNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityParameterNodeAdapter() {
		if (activityParameterNodeItemProvider == null) {
			activityParameterNodeItemProvider = new ActivityParameterNodeItemProvider(
				this);
		}

		return activityParameterNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Message} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageItemProvider messageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ForkNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForkNodeAdapter() {
		if (forkNodeItemProvider == null) {
			forkNodeItemProvider = new ForkNodeItemProvider(this);
		}

		return forkNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.FlowFinalNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FlowFinalNodeItemProvider flowFinalNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.FlowFinalNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFlowFinalNodeAdapter() {
		if (flowFinalNodeItemProvider == null) {
			flowFinalNodeItemProvider = new FlowFinalNodeItemProvider(this);
		}

		return flowFinalNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CentralBufferNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CentralBufferNodeItemProvider centralBufferNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CentralBufferNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCentralBufferNodeAdapter() {
		if (centralBufferNodeItemProvider == null) {
			centralBufferNodeItemProvider = new CentralBufferNodeItemProvider(
				this);
		}

		return centralBufferNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.MergeNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MergeNodeItemProvider mergeNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.MergeNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMergeNodeAdapter() {
		if (mergeNodeItemProvider == null) {
			mergeNodeItemProvider = new MergeNodeItemProvider(this);
		}

		return mergeNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DecisionNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DecisionNodeItemProvider decisionNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DecisionNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecisionNodeAdapter() {
		if (decisionNodeItemProvider == null) {
			decisionNodeItemProvider = new DecisionNodeItemProvider(this);
		}

		return decisionNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ActivityFinalNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityFinalNodeItemProvider activityFinalNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ActivityFinalNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityFinalNodeAdapter() {
		if (activityFinalNodeItemProvider == null) {
			activityFinalNodeItemProvider = new ActivityFinalNodeItemProvider(
				this);
		}

		return activityFinalNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ComponentRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentRealizationItemProvider componentRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.JoinNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJoinNodeAdapter() {
		if (joinNodeItemProvider == null) {
			joinNodeItemProvider = new JoinNodeItemProvider(this);
		}

		return joinNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.DataStoreNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataStoreNodeItemProvider dataStoreNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.DataStoreNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataStoreNodeAdapter() {
		if (dataStoreNodeItemProvider == null) {
			dataStoreNodeItemProvider = new DataStoreNodeItemProvider(this);
		}

		return dataStoreNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ObjectFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ObjectFlowItemProvider objectFlowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ObjectFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createObjectFlowAdapter() {
		if (objectFlowItemProvider == null) {
			objectFlowItemProvider = new ObjectFlowItemProvider(this);
		}

		return objectFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ConditionalNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalNodeItemProvider conditionalNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.SequenceNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequenceNodeAdapter() {
		if (sequenceNodeItemProvider == null) {
			sequenceNodeItemProvider = new SequenceNodeItemProvider(this);
		}

		return sequenceNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Usage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UsageItemProvider usageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ConditionalNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalNodeAdapter() {
		if (conditionalNodeItemProvider == null) {
			conditionalNodeItemProvider = new ConditionalNodeItemProvider(this);
		}

		return conditionalNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Clause} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClauseItemProvider clauseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Clause}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClauseAdapter() {
		if (clauseItemProvider == null) {
			clauseItemProvider = new ClauseItemProvider(this);
		}

		return clauseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.LoopNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LoopNodeItemProvider loopNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.LoopNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLoopNodeAdapter() {
		if (loopNodeItemProvider == null) {
			loopNodeItemProvider = new LoopNodeItemProvider(this);
		}

		return loopNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExpansionNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpansionNodeItemProvider expansionNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExpansionNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpansionNodeAdapter() {
		if (expansionNodeItemProvider == null) {
			expansionNodeItemProvider = new ExpansionNodeItemProvider(this);
		}

		return expansionNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExpansionRegion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpansionRegionItemProvider expansionRegionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExpansionRegion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpansionRegionAdapter() {
		if (expansionRegionItemProvider == null) {
			expansionRegionItemProvider = new ExpansionRegionItemProvider(this);
		}

		return expansionRegionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ProtocolTransition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProtocolTransitionItemProvider protocolTransitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ComponentRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentRealizationAdapter() {
		if (componentRealizationItemProvider == null) {
			componentRealizationItemProvider = new ComponentRealizationItemProvider(
				this);
		}

		return componentRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Component} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentItemProvider componentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Component}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentAdapter() {
		if (componentItemProvider == null) {
			componentItemProvider = new ComponentItemProvider(this);
		}

		return componentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Node} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NodeItemProvider nodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Node}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNodeAdapter() {
		if (nodeItemProvider == null) {
			nodeItemProvider = new NodeItemProvider(this);
		}

		return nodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.Device} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeviceItemProvider deviceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.Device}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeviceAdapter() {
		if (deviceItemProvider == null) {
			deviceItemProvider = new DeviceItemProvider(this);
		}

		return deviceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ExecutionEnvironment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionEnvironmentItemProvider executionEnvironmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ExecutionEnvironment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionEnvironmentAdapter() {
		if (executionEnvironmentItemProvider == null) {
			executionEnvironmentItemProvider = new ExecutionEnvironmentItemProvider(
				this);
		}

		return executionEnvironmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CommunicationPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommunicationPathItemProvider communicationPathItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.CommunicationPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommunicationPathAdapter() {
		if (communicationPathItemProvider == null) {
			communicationPathItemProvider = new CommunicationPathItemProvider(
				this);
		}

		return communicationPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.CombinedFragment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CombinedFragmentItemProvider combinedFragmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.FinalState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFinalStateAdapter() {
		if (finalStateItemProvider == null) {
			finalStateItemProvider = new FinalStateItemProvider(this);
		}

		return finalStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.TimeEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeEventItemProvider timeEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.TimeEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeEventAdapter() {
		if (timeEventItemProvider == null) {
			timeEventItemProvider = new TimeEventItemProvider(this);
		}

		return timeEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.ReadVariableAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReadVariableActionItemProvider readVariableActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.ProtocolTransition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProtocolTransitionAdapter() {
		if (protocolTransitionItemProvider == null) {
			protocolTransitionItemProvider = new ProtocolTransitionItemProvider(
				this);
		}

		return protocolTransitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.uml.AssociationClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssociationClassItemProvider associationClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.uml.AssociationClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssociationClassAdapter() {
		if (associationClassItemProvider == null) {
			associationClassItemProvider = new AssociationClassItemProvider(
				this);
		}

		return associationClassItemProvider;
	}

	protected StereotypeApplicationItemProvider stereotypeApplicationItemProvider;

	public Adapter createStereotypeApplicationAdapter() {

		if (stereotypeApplicationItemProvider == null) {
			stereotypeApplicationItemProvider = new StereotypeApplicationItemProvider(
				this);
		}

		return stereotypeApplicationItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null
			? this
			: parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForTypeGen(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	@Override
	public boolean isFactoryForType(Object type) {
		return isFactoryForTypeGen(type)
			|| (type instanceof EPackage && UMLUtil.getProfile((EPackage) type) != null)
			|| (type instanceof EObject && UMLUtil
				.getStereotype((EObject) type) != null);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class)
				|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void disposeGen() {
		if (commentItemProvider != null)
			commentItemProvider.dispose();
		if (packageItemProvider != null)
			packageItemProvider.dispose();
		if (dependencyItemProvider != null)
			dependencyItemProvider.dispose();
		if (elementImportItemProvider != null)
			elementImportItemProvider.dispose();
		if (packageImportItemProvider != null)
			packageImportItemProvider.dispose();
		if (constraintItemProvider != null)
			constraintItemProvider.dispose();
		if (associationItemProvider != null)
			associationItemProvider.dispose();
		if (templateBindingItemProvider != null)
			templateBindingItemProvider.dispose();
		if (templateSignatureItemProvider != null)
			templateSignatureItemProvider.dispose();
		if (templateParameterItemProvider != null)
			templateParameterItemProvider.dispose();
		if (templateParameterSubstitutionItemProvider != null)
			templateParameterSubstitutionItemProvider.dispose();
		if (generalizationItemProvider != null)
			generalizationItemProvider.dispose();
		if (generalizationSetItemProvider != null)
			generalizationSetItemProvider.dispose();
		if (substitutionItemProvider != null)
			substitutionItemProvider.dispose();
		if (realizationItemProvider != null)
			realizationItemProvider.dispose();
		if (abstractionItemProvider != null)
			abstractionItemProvider.dispose();
		if (opaqueExpressionItemProvider != null)
			opaqueExpressionItemProvider.dispose();
		if (parameterItemProvider != null)
			parameterItemProvider.dispose();
		if (connectableElementTemplateParameterItemProvider != null)
			connectableElementTemplateParameterItemProvider.dispose();
		if (connectorEndItemProvider != null)
			connectorEndItemProvider.dispose();
		if (propertyItemProvider != null)
			propertyItemProvider.dispose();
		if (deploymentItemProvider != null)
			deploymentItemProvider.dispose();
		if (deploymentSpecificationItemProvider != null)
			deploymentSpecificationItemProvider.dispose();
		if (artifactItemProvider != null)
			artifactItemProvider.dispose();
		if (manifestationItemProvider != null)
			manifestationItemProvider.dispose();
		if (operationItemProvider != null)
			operationItemProvider.dispose();
		if (classItemProvider != null)
			classItemProvider.dispose();
		if (interfaceRealizationItemProvider != null)
			interfaceRealizationItemProvider.dispose();
		if (interfaceItemProvider != null)
			interfaceItemProvider.dispose();
		if (receptionItemProvider != null)
			receptionItemProvider.dispose();
		if (signalItemProvider != null)
			signalItemProvider.dispose();
		if (protocolStateMachineItemProvider != null)
			protocolStateMachineItemProvider.dispose();
		if (stateMachineItemProvider != null)
			stateMachineItemProvider.dispose();
		if (regionItemProvider != null)
			regionItemProvider.dispose();
		if (transitionItemProvider != null)
			transitionItemProvider.dispose();
		if (triggerItemProvider != null)
			triggerItemProvider.dispose();
		if (portItemProvider != null)
			portItemProvider.dispose();
		if (stateItemProvider != null)
			stateItemProvider.dispose();
		if (connectionPointReferenceItemProvider != null)
			connectionPointReferenceItemProvider.dispose();
		if (pseudostateItemProvider != null)
			pseudostateItemProvider.dispose();
		if (protocolConformanceItemProvider != null)
			protocolConformanceItemProvider.dispose();
		if (connectorItemProvider != null)
			connectorItemProvider.dispose();
		if (extensionItemProvider != null)
			extensionItemProvider.dispose();
		if (extensionEndItemProvider != null)
			extensionEndItemProvider.dispose();
		if (stereotypeItemProvider != null)
			stereotypeItemProvider.dispose();
		if (imageItemProvider != null)
			imageItemProvider.dispose();
		if (profileItemProvider != null)
			profileItemProvider.dispose();
		if (modelItemProvider != null)
			modelItemProvider.dispose();
		if (parameterSetItemProvider != null)
			parameterSetItemProvider.dispose();
		if (dataTypeItemProvider != null)
			dataTypeItemProvider.dispose();
		if (operationTemplateParameterItemProvider != null)
			operationTemplateParameterItemProvider.dispose();
		if (collaborationUseItemProvider != null)
			collaborationUseItemProvider.dispose();
		if (collaborationItemProvider != null)
			collaborationItemProvider.dispose();
		if (useCaseItemProvider != null)
			useCaseItemProvider.dispose();
		if (includeItemProvider != null)
			includeItemProvider.dispose();
		if (extendItemProvider != null)
			extendItemProvider.dispose();
		if (extensionPointItemProvider != null)
			extensionPointItemProvider.dispose();
		if (redefinableTemplateSignatureItemProvider != null)
			redefinableTemplateSignatureItemProvider.dispose();
		if (classifierTemplateParameterItemProvider != null)
			classifierTemplateParameterItemProvider.dispose();
		if (stringExpressionItemProvider != null)
			stringExpressionItemProvider.dispose();
		if (expressionItemProvider != null)
			expressionItemProvider.dispose();
		if (usageItemProvider != null)
			usageItemProvider.dispose();
		if (packageMergeItemProvider != null)
			packageMergeItemProvider.dispose();
		if (profileApplicationItemProvider != null)
			profileApplicationItemProvider.dispose();
		if (enumerationItemProvider != null)
			enumerationItemProvider.dispose();
		if (enumerationLiteralItemProvider != null)
			enumerationLiteralItemProvider.dispose();
		if (instanceSpecificationItemProvider != null)
			instanceSpecificationItemProvider.dispose();
		if (slotItemProvider != null)
			slotItemProvider.dispose();
		if (primitiveTypeItemProvider != null)
			primitiveTypeItemProvider.dispose();
		if (literalIntegerItemProvider != null)
			literalIntegerItemProvider.dispose();
		if (literalStringItemProvider != null)
			literalStringItemProvider.dispose();
		if (literalBooleanItemProvider != null)
			literalBooleanItemProvider.dispose();
		if (literalNullItemProvider != null)
			literalNullItemProvider.dispose();
		if (instanceValueItemProvider != null)
			instanceValueItemProvider.dispose();
		if (literalUnlimitedNaturalItemProvider != null)
			literalUnlimitedNaturalItemProvider.dispose();
		if (opaqueBehaviorItemProvider != null)
			opaqueBehaviorItemProvider.dispose();
		if (functionBehaviorItemProvider != null)
			functionBehaviorItemProvider.dispose();
		if (opaqueActionItemProvider != null)
			opaqueActionItemProvider.dispose();
		if (structuredActivityNodeItemProvider != null)
			structuredActivityNodeItemProvider.dispose();
		if (activityItemProvider != null)
			activityItemProvider.dispose();
		if (variableItemProvider != null)
			variableItemProvider.dispose();
		if (activityPartitionItemProvider != null)
			activityPartitionItemProvider.dispose();
		if (interruptibleActivityRegionItemProvider != null)
			interruptibleActivityRegionItemProvider.dispose();
		if (exceptionHandlerItemProvider != null)
			exceptionHandlerItemProvider.dispose();
		if (outputPinItemProvider != null)
			outputPinItemProvider.dispose();
		if (pinItemProvider != null)
			pinItemProvider.dispose();
		if (inputPinItemProvider != null)
			inputPinItemProvider.dispose();
		if (sendSignalActionItemProvider != null)
			sendSignalActionItemProvider.dispose();
		if (callOperationActionItemProvider != null)
			callOperationActionItemProvider.dispose();
		if (callBehaviorActionItemProvider != null)
			callBehaviorActionItemProvider.dispose();
		if (sequenceNodeItemProvider != null)
			sequenceNodeItemProvider.dispose();
		if (controlFlowItemProvider != null)
			controlFlowItemProvider.dispose();
		if (initialNodeItemProvider != null)
			initialNodeItemProvider.dispose();
		if (activityParameterNodeItemProvider != null)
			activityParameterNodeItemProvider.dispose();
		if (valuePinItemProvider != null)
			valuePinItemProvider.dispose();
		if (messageItemProvider != null)
			messageItemProvider.dispose();
		if (interactionItemProvider != null)
			interactionItemProvider.dispose();
		if (lifelineItemProvider != null)
			lifelineItemProvider.dispose();
		if (partDecompositionItemProvider != null)
			partDecompositionItemProvider.dispose();
		if (interactionUseItemProvider != null)
			interactionUseItemProvider.dispose();
		if (gateItemProvider != null)
			gateItemProvider.dispose();
		if (generalOrderingItemProvider != null)
			generalOrderingItemProvider.dispose();
		if (occurrenceSpecificationItemProvider != null)
			occurrenceSpecificationItemProvider.dispose();
		if (interactionOperandItemProvider != null)
			interactionOperandItemProvider.dispose();
		if (interactionConstraintItemProvider != null)
			interactionConstraintItemProvider.dispose();
		if (stateInvariantItemProvider != null)
			stateInvariantItemProvider.dispose();
		if (actionExecutionSpecificationItemProvider != null)
			actionExecutionSpecificationItemProvider.dispose();
		if (behaviorExecutionSpecificationItemProvider != null)
			behaviorExecutionSpecificationItemProvider.dispose();
		if (executionEventItemProvider != null)
			executionEventItemProvider.dispose();
		if (creationEventItemProvider != null)
			creationEventItemProvider.dispose();
		if (destructionEventItemProvider != null)
			destructionEventItemProvider.dispose();
		if (sendOperationEventItemProvider != null)
			sendOperationEventItemProvider.dispose();
		if (sendSignalEventItemProvider != null)
			sendSignalEventItemProvider.dispose();
		if (messageOccurrenceSpecificationItemProvider != null)
			messageOccurrenceSpecificationItemProvider.dispose();
		if (executionOccurrenceSpecificationItemProvider != null)
			executionOccurrenceSpecificationItemProvider.dispose();
		if (receiveOperationEventItemProvider != null)
			receiveOperationEventItemProvider.dispose();
		if (receiveSignalEventItemProvider != null)
			receiveSignalEventItemProvider.dispose();
		if (actorItemProvider != null)
			actorItemProvider.dispose();
		if (callEventItemProvider != null)
			callEventItemProvider.dispose();
		if (changeEventItemProvider != null)
			changeEventItemProvider.dispose();
		if (signalEventItemProvider != null)
			signalEventItemProvider.dispose();
		if (anyReceiveEventItemProvider != null)
			anyReceiveEventItemProvider.dispose();
		if (forkNodeItemProvider != null)
			forkNodeItemProvider.dispose();
		if (flowFinalNodeItemProvider != null)
			flowFinalNodeItemProvider.dispose();
		if (centralBufferNodeItemProvider != null)
			centralBufferNodeItemProvider.dispose();
		if (mergeNodeItemProvider != null)
			mergeNodeItemProvider.dispose();
		if (decisionNodeItemProvider != null)
			decisionNodeItemProvider.dispose();
		if (activityFinalNodeItemProvider != null)
			activityFinalNodeItemProvider.dispose();
		if (componentRealizationItemProvider != null)
			componentRealizationItemProvider.dispose();
		if (componentItemProvider != null)
			componentItemProvider.dispose();
		if (nodeItemProvider != null)
			nodeItemProvider.dispose();
		if (deviceItemProvider != null)
			deviceItemProvider.dispose();
		if (executionEnvironmentItemProvider != null)
			executionEnvironmentItemProvider.dispose();
		if (communicationPathItemProvider != null)
			communicationPathItemProvider.dispose();
		if (combinedFragmentItemProvider != null)
			combinedFragmentItemProvider.dispose();
		if (continuationItemProvider != null)
			continuationItemProvider.dispose();
		if (considerIgnoreFragmentItemProvider != null)
			considerIgnoreFragmentItemProvider.dispose();
		if (createObjectActionItemProvider != null)
			createObjectActionItemProvider.dispose();
		if (destroyObjectActionItemProvider != null)
			destroyObjectActionItemProvider.dispose();
		if (testIdentityActionItemProvider != null)
			testIdentityActionItemProvider.dispose();
		if (readSelfActionItemProvider != null)
			readSelfActionItemProvider.dispose();
		if (readStructuralFeatureActionItemProvider != null)
			readStructuralFeatureActionItemProvider.dispose();
		if (clearStructuralFeatureActionItemProvider != null)
			clearStructuralFeatureActionItemProvider.dispose();
		if (removeStructuralFeatureValueActionItemProvider != null)
			removeStructuralFeatureValueActionItemProvider.dispose();
		if (addStructuralFeatureValueActionItemProvider != null)
			addStructuralFeatureValueActionItemProvider.dispose();
		if (linkEndDataItemProvider != null)
			linkEndDataItemProvider.dispose();
		if (qualifierValueItemProvider != null)
			qualifierValueItemProvider.dispose();
		if (readLinkActionItemProvider != null)
			readLinkActionItemProvider.dispose();
		if (linkEndCreationDataItemProvider != null)
			linkEndCreationDataItemProvider.dispose();
		if (createLinkActionItemProvider != null)
			createLinkActionItemProvider.dispose();
		if (destroyLinkActionItemProvider != null)
			destroyLinkActionItemProvider.dispose();
		if (linkEndDestructionDataItemProvider != null)
			linkEndDestructionDataItemProvider.dispose();
		if (clearAssociationActionItemProvider != null)
			clearAssociationActionItemProvider.dispose();
		if (broadcastSignalActionItemProvider != null)
			broadcastSignalActionItemProvider.dispose();
		if (sendObjectActionItemProvider != null)
			sendObjectActionItemProvider.dispose();
		if (valueSpecificationActionItemProvider != null)
			valueSpecificationActionItemProvider.dispose();
		if (timeExpressionItemProvider != null)
			timeExpressionItemProvider.dispose();
		if (durationItemProvider != null)
			durationItemProvider.dispose();
		if (durationIntervalItemProvider != null)
			durationIntervalItemProvider.dispose();
		if (intervalItemProvider != null)
			intervalItemProvider.dispose();
		if (timeConstraintItemProvider != null)
			timeConstraintItemProvider.dispose();
		if (intervalConstraintItemProvider != null)
			intervalConstraintItemProvider.dispose();
		if (timeIntervalItemProvider != null)
			timeIntervalItemProvider.dispose();
		if (durationConstraintItemProvider != null)
			durationConstraintItemProvider.dispose();
		if (timeObservationItemProvider != null)
			timeObservationItemProvider.dispose();
		if (durationObservationItemProvider != null)
			durationObservationItemProvider.dispose();
		if (finalStateItemProvider != null)
			finalStateItemProvider.dispose();
		if (timeEventItemProvider != null)
			timeEventItemProvider.dispose();
		if (readVariableActionItemProvider != null)
			readVariableActionItemProvider.dispose();
		if (clearVariableActionItemProvider != null)
			clearVariableActionItemProvider.dispose();
		if (addVariableValueActionItemProvider != null)
			addVariableValueActionItemProvider.dispose();
		if (removeVariableValueActionItemProvider != null)
			removeVariableValueActionItemProvider.dispose();
		if (raiseExceptionActionItemProvider != null)
			raiseExceptionActionItemProvider.dispose();
		if (actionInputPinItemProvider != null)
			actionInputPinItemProvider.dispose();
		if (informationItemItemProvider != null)
			informationItemItemProvider.dispose();
		if (informationFlowItemProvider != null)
			informationFlowItemProvider.dispose();
		if (readExtentActionItemProvider != null)
			readExtentActionItemProvider.dispose();
		if (reclassifyObjectActionItemProvider != null)
			reclassifyObjectActionItemProvider.dispose();
		if (readIsClassifiedObjectActionItemProvider != null)
			readIsClassifiedObjectActionItemProvider.dispose();
		if (startClassifierBehaviorActionItemProvider != null)
			startClassifierBehaviorActionItemProvider.dispose();
		if (readLinkObjectEndActionItemProvider != null)
			readLinkObjectEndActionItemProvider.dispose();
		if (readLinkObjectEndQualifierActionItemProvider != null)
			readLinkObjectEndQualifierActionItemProvider.dispose();
		if (createLinkObjectActionItemProvider != null)
			createLinkObjectActionItemProvider.dispose();
		if (acceptEventActionItemProvider != null)
			acceptEventActionItemProvider.dispose();
		if (acceptCallActionItemProvider != null)
			acceptCallActionItemProvider.dispose();
		if (replyActionItemProvider != null)
			replyActionItemProvider.dispose();
		if (unmarshallActionItemProvider != null)
			unmarshallActionItemProvider.dispose();
		if (reduceActionItemProvider != null)
			reduceActionItemProvider.dispose();
		if (joinNodeItemProvider != null)
			joinNodeItemProvider.dispose();
		if (dataStoreNodeItemProvider != null)
			dataStoreNodeItemProvider.dispose();
		if (objectFlowItemProvider != null)
			objectFlowItemProvider.dispose();
		if (conditionalNodeItemProvider != null)
			conditionalNodeItemProvider.dispose();
		if (clauseItemProvider != null)
			clauseItemProvider.dispose();
		if (loopNodeItemProvider != null)
			loopNodeItemProvider.dispose();
		if (expansionNodeItemProvider != null)
			expansionNodeItemProvider.dispose();
		if (expansionRegionItemProvider != null)
			expansionRegionItemProvider.dispose();
		if (protocolTransitionItemProvider != null)
			protocolTransitionItemProvider.dispose();
		if (associationClassItemProvider != null)
			associationClassItemProvider.dispose();
	}

	public void dispose() {
		disposeGen();

		if (stereotypeApplicationItemProvider != null) {
			stereotypeApplicationItemProvider.dispose();
		}
	}

	@Override
	public Adapter createAdapter(Notifier target) {
		Adapter adapter = super.createAdapter(target);
		return adapter == null
			? createStereotypeApplicationAdapter()
			: adapter;
	}

}
