/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.tutorial.intro.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.uml2.tutorial.intro.IntroPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseProjectsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Set<String> projectNames = this.asSet(event.getParameter("project"));
        final ArrayList<IProject> existingProjects = new ArrayList<IProject>();
        for (String projName : projectNames) {
            IProject project = root.getProject(projName);
            if (!project.exists()) continue;
            existingProjects.add(project);
        }
        if (!existingProjects.isEmpty()) {
            WorkspaceModifyOperation run = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("Closing projects...", existingProjects.size());
                    for (IProject proj : existingProjects) {
                        monitor.subTask(proj.getName());
                        proj.close(null);
                    }
                    monitor.worked(1);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)run);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)IntroPlugin.INSTANCE.getString("_UI_ErrorDialog_title"), (String)("Error closing a project: " + e.getLocalizedMessage()));
            }
        }
        return null;
    }

    private Set<String> asSet(String commaSeparated) {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokens = new StringTokenizer(commaSeparated, ";");
        while (tokens.hasMoreTokens()) {
            String next = tokens.nextToken().trim();
            if (next.length() <= 0) continue;
            result.add(next);
        }
        return result;
    }
}

