/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.tutorial.intro.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.uml2.tutorial.intro.IntroPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallProjectsHandler
extends AbstractHandler {
    protected static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Set<String> paths = this.asSet(event.getParameter("path"));
        final HashSet<File> folders = new HashSet<File>();
        String overwriteParm = event.getParameter("overwrite");
        final boolean overwrite = overwriteParm != null && Boolean.valueOf(overwriteParm) != false;
        for (String path : paths) {
            IFolder folder = root.getFolder((IPath)new Path(path));
            if (!folder.exists()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)IntroPlugin.INSTANCE.getString("_UI_ErrorDialog_title"), (String)"The UML2_Tutorial project is not available or is incomplete.  Please repeat the installation step at the beginning of this cheat sheet.");
                return null;
            }
            folders.add(new File(folder.getLocation().toOSString()));
        }
        try {
            final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Creating projects...", folders.size());
                    try {
                        try {
                            InstallProjectsHandler.this.importProjects(folders, shell, overwrite, monitor);
                        }
                        catch (CoreException e) {
                            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)IntroPlugin.INSTANCE.getString("_UI_ErrorDialog_title"), (String)"Failed to create project", (IStatus)e.getStatus());
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)IntroPlugin.INSTANCE.getString("_UI_ErrorDialog_title"), (String)("Failed to create project: " + e.getLocalizedMessage()));
        }
        return null;
    }

    private void importProjects(Set<File> folders, Shell shell, boolean overwrite, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        for (File folder : folders) {
            monitor.subTask(folder.getName());
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(folder.getName());
            if (project.exists() && !overwrite) continue;
            ImportOperation importOperation = new ImportOperation(project.getFullPath(), (Object)folder, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, OVERWRITE_ALL_QUERY);
            importOperation.setCreateContainerStructure(false);
            importOperation.setContext(shell);
            importOperation.run((IProgressMonitor)new NullProgressMonitor());
            this.ensureSrcFolder(project);
            monitor.worked(1);
        }
    }

    private void ensureSrcFolder(IProject project) throws CoreException {
        IFolder src;
        if (project.getFile(".classpath").exists() && !(src = project.getFolder("src")).exists()) {
            src.create(true, true, null);
        }
    }

    private Set<String> asSet(String commaSeparated) {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokens = new StringTokenizer(commaSeparated, ";");
        while (tokens.hasMoreTokens()) {
            String next = tokens.nextToken().trim();
            if (next.length() <= 0) continue;
            result.add(next);
        }
        return result;
    }
}

