/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.tutorial.intro.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile file = (IFile)event.getObjectParameterForExecution("path");
        this.openFile(file, event.getParameter("editor"));
        return null;
    }

    protected void openFile(IFile file, String editorID) throws ExecutionException {
        IWorkbench wb = PlatformUI.getWorkbench();
        FileEditorInput input = new FileEditorInput(file);
        IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
        try {
            if (editorID == null) {
                IEditorDescriptor defaultEditor = wb.getEditorRegistry().getDefaultEditor(file.getFullPath().toString());
                editorID = defaultEditor.getId();
            }
            page.openEditor((IEditorInput)input, editorID);
        }
        catch (PartInitException e) {
            throw new ExecutionException(e.getLocalizedMessage());
        }
    }
}

