/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.tutorial.intro.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.uml2.tutorial.intro.IntroPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyWorkspaceProjectsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Set<String> projectNames = this.asSet(event.getParameter("project"));
        ArrayList<IProject> existingProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            String projectName = projects[i].getName();
            if (projectNames.contains(projectName)) {
                existingProjects.add(projects[i]);
            }
            ++i;
        }
        if (!existingProjects.isEmpty()) {
            StringBuffer existingProjectNames = new StringBuffer();
            for (IProject project : existingProjects) {
                existingProjectNames.append(", ").append(project.getName());
            }
            existingProjectNames.delete(0, ", ".length());
            Shell shell = Display.getCurrent().getActiveShell();
            boolean deleteProjects = MessageDialog.openQuestion((Shell)shell, (String)IntroPlugin.INSTANCE.getString("_UI_ActionRequired_title"), (String)IntroPlugin.INSTANCE.getString("_UI_ExistingProjects_desc", new String[]{existingProjectNames.toString()}));
            if (deleteProjects) {
                DeleteResourceAction deleteResourceAction = new DeleteResourceAction(shell);
                deleteResourceAction.selectionChanged((IStructuredSelection)new StructuredSelection(existingProjects));
                deleteResourceAction.run();
            }
        }
        return null;
    }

    private Set<String> asSet(String commaSeparated) {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokens = new StringTokenizer(commaSeparated, ";");
        while (tokens.hasMoreTokens()) {
            String next = tokens.nextToken().trim();
            if (next.length() <= 0) continue;
            result.add(next);
        }
        return result;
    }
}

