/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.BuilderStateUtil;
import org.eclipse.xtext.builder.builderState.EMFBasedPersister;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.ResourceDescriptionsUpdater;
import org.eclipse.xtext.builder.builderState.ShadowingResourceDescriptions;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistableResourceDescriptionsImpl
extends AbstractResourceDescriptionChangeEventSource
implements IBuilderState {
    private volatile Map<URI, IResourceDescription> resourceDescriptionMap = Collections.emptyMap();
    @Inject
    private ResourceDescriptionsUpdater updater;
    @Inject
    private IMarkerUpdater markerUpdater;
    @Inject
    private PersistedStateProvider persister;
    private boolean isLoaded = false;

    public synchronized void load() {
        this.resourceDescriptionMap = Maps.uniqueIndex(this.persister.load(), (Function)new Function<IResourceDescription, URI>(){

            public URI apply(IResourceDescription from) {
                return from.getURI();
            }
        });
        this.isLoaded = true;
    }

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> update(ResourceSet resourceSet, Set<URI> toBeAddedOrUpdated, Set<URI> toBeRemoved, IProgressMonitor monitor) {
        if (!this.isLoaded) {
            this.load();
        }
        toBeAddedOrUpdated = toBeAddedOrUpdated != null ? toBeAddedOrUpdated : Collections.emptySet();
        toBeRemoved = toBeRemoved != null ? toBeRemoved : Collections.emptySet();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create resource descriptions", (int)3);
        subMonitor.subTask("Create resource descriptions");
        try {
            if (subMonitor.isCanceled() || toBeAddedOrUpdated.isEmpty() && toBeRemoved.isEmpty()) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            resourceSet.eAdapters().add((Object)new ShadowingResourceDescriptions.Adapter(this, toBeAddedOrUpdated, toBeRemoved));
            resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
            Collection<IResourceDescription.Delta> deltas = this.updater.transitiveUpdate(this, resourceSet, toBeAddedOrUpdated, toBeRemoved, (IProgressMonitor)subMonitor.newChild(1));
            HashSet copiedDeltas = Sets.newHashSet();
            HashMap newMap = Maps.newHashMap(this.resourceDescriptionMap);
            SubMonitor deltaMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (String)"Update resource descriptions", (int)deltas.size());
            int total = deltas.size();
            int current = 1;
            try {
                for (IResourceDescription.Delta delta : deltas) {
                    if (deltaMonitor.isCanceled()) {
                        ImmutableList immutableList = ImmutableList.of();
                        return immutableList;
                    }
                    deltaMonitor.subTask("Update resource description " + current + " of " + total);
                    DefaultResourceDescriptionDelta copiedDelta = new DefaultResourceDescriptionDelta(delta.getOld(), this.createNew(delta, toBeAddedOrUpdated));
                    copiedDeltas.add(copiedDelta);
                    if (delta.getNew() == null) {
                        newMap.remove(copiedDelta.getOld().getURI());
                    } else {
                        newMap.put(copiedDelta.getNew().getURI(), copiedDelta.getNew());
                    }
                    ++current;
                    deltaMonitor.worked(1);
                }
            }
            finally {
                deltaMonitor.done();
            }
            ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent((Iterable)copiedDeltas, (IResourceDescription.Event.Source)this);
            if (subMonitor.isCanceled()) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            this.doValidate(resourceSet, (ImmutableList<IResourceDescription.Delta>)event.getDeltas(), (IProgressMonitor)subMonitor.newChild(1));
            this.resourceDescriptionMap = Collections.unmodifiableMap(newMap);
            this.notifyListeners((IResourceDescription.Event)event);
            ImmutableList immutableList = event.getDeltas();
            return immutableList;
        }
        finally {
            subMonitor.done();
        }
    }

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> clean(Set<URI> toBeRemoved, IProgressMonitor monitor) {
        if (!this.isLoaded) {
            this.load();
        }
        toBeRemoved = toBeRemoved != null ? toBeRemoved : Collections.emptySet();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create resource descriptions", (int)3);
        subMonitor.subTask("Create resource descriptions");
        try {
            if (subMonitor.isCanceled() || toBeRemoved.isEmpty()) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            Collection<IResourceDescription.Delta> deltas = this.updater.clean(this, toBeRemoved, (IProgressMonitor)subMonitor.newChild(1));
            HashMap newMap = Maps.newHashMap(this.resourceDescriptionMap);
            if (subMonitor.isCanceled()) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            for (IResourceDescription.Delta delta : deltas) {
                newMap.remove(delta.getOld().getURI());
            }
            ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(deltas, (IResourceDescription.Event.Source)this);
            if (subMonitor.isCanceled()) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            this.markerUpdater.updateMarker(null, (ImmutableList<IResourceDescription.Delta>)event.getDeltas(), (IProgressMonitor)subMonitor);
            this.resourceDescriptionMap = Collections.unmodifiableMap(newMap);
            this.notifyListeners((IResourceDescription.Event)event);
            ImmutableList immutableList = event.getDeltas();
            return immutableList;
        }
        finally {
            subMonitor.done();
        }
    }

    protected void doValidate(ResourceSet rs, ImmutableList<IResourceDescription.Delta> deltas, IProgressMonitor monitor) {
        this.markerUpdater.updateMarker(rs, deltas, monitor);
    }

    private IResourceDescription createNew(IResourceDescription.Delta delta, Set<URI> toBeAddedOrUpdated) {
        if (delta.getNew() == null) {
            return null;
        }
        IResourceDescription toCopy = delta.getNew();
        ResourceDescriptionImpl copied = BuilderStateUtil.create(toCopy);
        return copied;
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        if (!this.isLoaded) {
            this.load();
        }
        return this.resourceDescriptionMap.values();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        if (!this.isLoaded) {
            this.load();
        }
        return this.resourceDescriptionMap.get(uri);
    }

    public void setPersister(PersistedStateProvider persister) {
        this.persister = persister;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ImplementedBy(value=EMFBasedPersister.class)
    public static interface PersistedStateProvider {
        public Iterable<IResourceDescription> load();
    }
}

