/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.ShadowingResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptionsUpdater {
    private static final Logger log = Logger.getLogger(ResourceDescriptionsUpdater.class);
    @Inject
    private IResourceServiceProvider.Registry managerRegistry;
    @Inject
    private Provider<ShadowingResourceDescriptions> shadowingResourceDescriptionsProvider;

    public void setResourceServiceRegistry(IResourceServiceProvider.Registry managerRegistry) {
        this.managerRegistry = managerRegistry;
    }

    public Collection<IResourceDescription.Delta> transitiveUpdate(IResourceDescriptions oldState, ResourceSet rs, Set<URI> toBeUpdated, Set<URI> toBeDeleted, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Find affected resources", (int)2);
        subMonitor.subTask("Find affected resources");
        try {
            HashSet toBeDeletedAsSet = Sets.newHashSet(toBeDeleted);
            toBeDeletedAsSet.removeAll(Collections2.forIterable(toBeUpdated));
            HashMap result = Maps.newHashMap();
            for (URI toDelete : toBeDeletedAsSet) {
                IResourceDescription resourceDescription = oldState.getResourceDescription(toDelete);
                if (resourceDescription == null) continue;
                result.put(toDelete, new DefaultResourceDescriptionDelta(resourceDescription, null));
            }
            result.putAll(this.update(oldState, rs, toBeUpdated, (IProgressMonitor)subMonitor.newChild(1)));
            while (true) {
                if (subMonitor.isCanceled()) {
                    Set<IResourceDescription.Delta> set = Collections.emptySet();
                    return set;
                }
                subMonitor.setWorkRemaining(1);
                ShadowingResourceDescriptions newState = (ShadowingResourceDescriptions)this.shadowingResourceDescriptionsProvider.get();
                newState.setContext((Notifier)rs);
                Set<IResourceDescription> descriptions = this.findAffectedResourceDescriptions(oldState, (IResourceDescriptions)newState, result.values(), (IProgressMonitor)subMonitor);
                HashSet uris = Sets.newHashSet((Iterable)Iterables.transform(descriptions, (Function)new Function<IResourceDescription, URI>(){

                    public URI apply(IResourceDescription from) {
                        return from.getURI();
                    }
                }));
                uris.removeAll(result.keySet());
                if (uris.isEmpty()) break;
                result.putAll(this.update(oldState, rs, uris, (IProgressMonitor)subMonitor.newChild(1)));
            }
            Collection<IResourceDescription.Delta> collection = result.values();
            return collection;
        }
        finally {
            subMonitor.done();
        }
    }

    public Collection<IResourceDescription.Delta> clean(IResourceDescriptions oldState, Set<URI> toBeDeleted, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Clean resources", (int)2);
        subMonitor.subTask("Clean resources");
        try {
            HashSet toBeDeletedAsSet = Sets.newHashSet(toBeDeleted);
            HashMap result = Maps.newHashMap();
            for (URI toDelete : toBeDeletedAsSet) {
                IResourceDescription resourceDescription = oldState.getResourceDescription(toDelete);
                if (resourceDescription == null) continue;
                result.put(toDelete, new DefaultResourceDescriptionDelta(resourceDescription, null));
            }
            Collection<IResourceDescription.Delta> collection = result.values();
            return collection;
        }
        finally {
            subMonitor.done();
        }
    }

    protected Map<URI, IResourceDescription.Delta> update(IResourceDescriptions oldState, ResourceSet set, Set<URI> toBeUpdated, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(toBeUpdated.size() * 2));
        int total = toBeUpdated.size();
        int current = 1;
        try {
            HashMap result = Maps.newHashMap();
            for (URI uri : toBeUpdated) {
                block14: {
                    if (subMonitor.isCanceled()) {
                        Map<URI, IResourceDescription.Delta> map = Collections.emptyMap();
                        return map;
                    }
                    Resource res = null;
                    try {
                        subMonitor.subTask("Loading affected resource " + current + " of " + total);
                        res = set.getResource(uri, true);
                        ++current;
                    }
                    catch (WrappedException ex) {
                        IResourceDescription oldDescription;
                        if (set.getURIConverter().exists(uri, Collections.emptyMap())) {
                            log.error((Object)("Error loading resource from: " + uri.toString()), (Throwable)ex);
                        }
                        if (res != null) {
                            set.getResources().remove(res);
                        }
                        if ((oldDescription = oldState.getResourceDescription(uri)) == null) break block14;
                        result.put(uri, new DefaultResourceDescriptionDelta(oldDescription, null));
                    }
                }
                subMonitor.worked(1);
            }
            for (URI uri : toBeUpdated) {
                IResourceDescription.Manager manager;
                if (subMonitor.isCanceled()) {
                    Map<URI, IResourceDescription.Delta> map = Collections.emptyMap();
                    return map;
                }
                if (!result.containsKey(uri) && (manager = this.getResourceDescriptionManager(uri)) != null) {
                    Resource resource = set.getResource(uri, false);
                    IResourceDescription description = manager.getResourceDescription(resource);
                    result.put(uri, new DefaultResourceDescriptionDelta(oldState.getResourceDescription(uri), description));
                }
                subMonitor.worked(1);
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            subMonitor.done();
        }
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.managerRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        return resourceServiceProvider.getResourceDescriptionManager();
    }

    protected Set<IResourceDescription> findAffectedResourceDescriptions(IResourceDescriptions oldState, IResourceDescriptions newState, Collection<IResourceDescription.Delta> deltas, IProgressMonitor monitor) throws IllegalArgumentException {
        HashSet result = Sets.newHashSet();
        Iterable descriptions = oldState.getAllResourceDescriptions();
        for (IResourceDescription desc : descriptions) {
            if (monitor.isCanceled()) {
                return Collections.emptySet();
            }
            IResourceDescription.Manager manager = this.getResourceDescriptionManager(desc.getURI());
            if (manager == null || !manager.isAffected(deltas, desc, newState)) continue;
            result.add(desc);
        }
        return result;
    }
}

