/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class ProjectOpenedOrClosedListener
implements IResourceChangeListener {
    private static final Logger log = Logger.getLogger(ProjectOpenedOrClosedListener.class);
    @Inject
    private ToBeBuiltComputer toBeBuiltComputer;
    @Inject
    private IBuilderState builderState;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private BuildScheduler buildManager;
    @Inject
    private IWorkspace workspace;

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    public ToBeBuiltComputer getToBeBuiltComputer() {
        return this.toBeBuiltComputer;
    }

    public IBuilderState getBuilderState() {
        return this.builderState;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.workspace != null && this.workspace.isAutoBuilding()) {
            if (event.getType() == 1) {
                try {
                    final LinkedHashSet toUpdate = Sets.newLinkedHashSet();
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta.getResource() instanceof IWorkspaceRoot) {
                                return true;
                            }
                            if (delta.getResource() instanceof IProject) {
                                IProject project = (IProject)delta.getResource();
                                if ((delta.getFlags() & 0x4000) != 0 && project.isOpen()) {
                                    toUpdate.add(project);
                                }
                                if ((delta.getKind() & 4) != 0 && project.isOpen() && (delta.getFlags() & 0x80000) != 0) {
                                    if (XtextProjectHelper.hasNature((IProject)project)) {
                                        toUpdate.add(project);
                                    } else {
                                        ProjectOpenedOrClosedListener.this.scheduleRemoveProjectJob(project);
                                    }
                                }
                            }
                            return false;
                        }
                    });
                    this.buildManager.scheduleBuildIfNecessary(toUpdate, new IBuildFlag[0]);
                }
                catch (CoreException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if ((event.getType() == 2 || event.getType() == 4) && event.getResource() instanceof IProject && XtextProjectHelper.hasNature((IProject)((IProject)event.getResource()))) {
                this.scheduleRemoveProjectJob((IProject)event.getResource());
            }
        }
    }

    protected void scheduleRemoveProjectJob(final IProject project) {
        final ToBeBuilt toBeBuilt = this.getToBeBuiltComputer().removeProject(project, (IProgressMonitor)new NullProgressMonitor());
        new Job("Removing project " + project.getName() + " from Xtext index."){
            {
                super($anonymous0);
                this.setRule((ISchedulingRule)ProjectOpenedOrClosedListener.this.workspace.getRoot());
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new WorkspaceModifyOperation(this.getRule()){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            ProjectOpenedOrClosedListener.this.getBuilderState().update(ProjectOpenedOrClosedListener.this.getResourceSetProvider().get(project), toBeBuilt.getToBeUpdated(), toBeBuilt.getToBeDeleted(), monitor);
                        }
                    }.run(monitor);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

