/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RegistryBuilderParticipant
implements IXtextBuilderParticipant {
    private static final String PARTICIPANT = "participant";
    private static final String EXTENSION_POINT_ID = "participant";
    private static final String ATT_CLASS = "class";
    private static final Logger readerLog = Logger.getLogger(BuilderParticipantReader.class);
    @Inject
    private IExtensionRegistry extensionRegistry;
    private volatile ImmutableList<IXtextBuilderParticipant> participants;
    private Map<String, IXtextBuilderParticipant> classToParticipant;

    @Override
    public void build(IXtextBuilderParticipant.IBuildContext buildContext, IProgressMonitor monitor) throws CoreException {
        ImmutableList<IXtextBuilderParticipant> participants = this.getParticipants();
        if (participants.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        subMonitor.subTask("Invoking build participants");
        try {
            for (IXtextBuilderParticipant participant : participants) {
                if (subMonitor.isCanceled()) {
                    return;
                }
                participant.build(buildContext, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public ImmutableList<IXtextBuilderParticipant> getParticipants() {
        ImmutableList<IXtextBuilderParticipant> result = this.participants;
        if (this.participants == null) {
            result = this.initParticipants();
        }
        return result;
    }

    protected synchronized ImmutableList<IXtextBuilderParticipant> initParticipants() {
        ImmutableList result = this.participants;
        if (result == null) {
            if (this.classToParticipant == null) {
                this.classToParticipant = Maps.newHashMap();
                String pluginID = Activator.getDefault().getBundle().getSymbolicName();
                String extensionPointID = "participant";
                BuilderParticipantReader reader = new BuilderParticipantReader(this.extensionRegistry, pluginID, extensionPointID);
                reader.readRegistry();
            }
            this.participants = result = ImmutableList.copyOf(this.classToParticipant.values());
        }
        return result;
    }

    public class BuilderParticipantReader
    extends RegistryReader {
        public BuilderParticipantReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
            super(pluginRegistry, pluginID, extensionPointID);
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            if (element.getName().equals("participant")) {
                String className = element.getAttribute(RegistryBuilderParticipant.ATT_CLASS);
                if (className == null) {
                    this.logMissingAttribute(element, RegistryBuilderParticipant.ATT_CLASS);
                } else if (add) {
                    try {
                        Object participant = element.createExecutableExtension(RegistryBuilderParticipant.ATT_CLASS);
                        if (participant instanceof IXtextBuilderParticipant) {
                            if (RegistryBuilderParticipant.this.classToParticipant.containsKey(className)) {
                                readerLog.warn((Object)("The builder participant '" + className + "' was registered twice."));
                            }
                            RegistryBuilderParticipant.this.classToParticipant.put(className, (IXtextBuilderParticipant)participant);
                            RegistryBuilderParticipant.this.participants = null;
                        } else {
                            this.logError(element, String.valueOf(className) + " did not yield an instance of IXtextBuilderParticipant but " + participant.getClass().getName());
                        }
                        return true;
                    }
                    catch (CoreException e) {
                        this.logError(element, e.getMessage());
                    }
                } else {
                    RegistryBuilderParticipant.this.classToParticipant.remove(className);
                    RegistryBuilderParticipant.this.participants = null;
                    return true;
                }
            }
            return false;
        }

        protected void logError(IConfigurationElement element, String text) {
            IExtension extension = element.getDeclaringExtension();
            readerLog.error((Object)("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier()));
            readerLog.error((Object)text);
        }
    }
}

