/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.UriValidator;

public class ToBeBuiltComputer {
    @Inject
    private IBuilderState builderState;
    @Inject
    private IStorage2UriMapper mapper;
    @Inject
    private UriValidator uriValidator;

    public ToBeBuilt removeProject(IProject project, IProgressMonitor monitor) {
        ToBeBuilt result = new ToBeBuilt();
        SubMonitor.convert((IProgressMonitor)monitor, (int)0);
        Iterable allResourceDescriptions = this.builderState.getAllResourceDescriptions();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)Collections2.forIterable((Iterable)allResourceDescriptions).size());
        for (IResourceDescription description : allResourceDescriptions) {
            Iterable storages = this.mapper.getStorages(description.getURI());
            if (!storages.iterator().hasNext()) {
                result.getToBeDeleted().add(description.getURI());
            } else {
                for (IStorage storage : storages) {
                    if (!this.isOnProject(storage, project)) continue;
                    result.getToBeDeleted().add(description.getURI());
                }
            }
            subMonitor.worked(1);
        }
        return result;
    }

    protected boolean isOnProject(IStorage storage, IProject project) {
        if (storage instanceof IFile) {
            return project.contains((ISchedulingRule)((IFile)storage));
        }
        return false;
    }

    public ToBeBuilt updateProjectNewResourcesOnly(IProject project, IProgressMonitor monitor) throws CoreException {
        ToBeBuilt toBeBuilt = this.updateProject(project, monitor);
        Collection existingURIs = Collections2.forIterable((Iterable)Iterables.transform((Iterable)this.builderState.getAllResourceDescriptions(), (Function)new Function<IResourceDescription, URI>(){

            public URI apply(IResourceDescription from) {
                return from.getURI();
            }
        }));
        toBeBuilt.getToBeDeleted().removeAll(existingURIs);
        toBeBuilt.getToBeUpdated().removeAll(existingURIs);
        return toBeBuilt;
    }

    public ToBeBuilt updateProject(IProject project, final IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Collecting resources", (int)1);
        subMonitor.subTask("Collecting resources");
        try {
            final ToBeBuilt toBeBuilt = this.removeProject(project, monitor);
            if (!project.isAccessible()) {
                ToBeBuilt toBeBuilt2 = toBeBuilt;
                return toBeBuilt2;
            }
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IStorage) {
                        return ToBeBuiltComputer.this.updateStorage(monitor, toBeBuilt, (IStorage)resource);
                    }
                    return true;
                }
            });
            ToBeBuilt toBeBuilt3 = toBeBuilt;
            return toBeBuilt3;
        }
        finally {
            subMonitor.done();
        }
    }

    public boolean updateStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (monitor.isCanceled()) {
            return false;
        }
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeUpdated().add(uri);
        }
        return true;
    }

    public boolean removeStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (monitor.isCanceled()) {
            return false;
        }
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeDeleted().add(uri);
        }
        return true;
    }

    protected boolean isHandled(IStorage resource) {
        return resource instanceof IFile && !((IFile)resource).isDerived();
    }

    protected URI getUri(IStorage file) {
        URI uri = this.mapper.getUri(file);
        return uri != null && this.isValid(uri, file) ? uri : null;
    }

    protected boolean isValid(URI uri, IStorage storage) {
        return this.uriValidator.isValid(uri, storage);
    }
}

