/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.nature;

import com.google.inject.Inject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.builder.nature.ToggleXtextNatureAction;
import org.eclipse.xtext.ui.editor.AbstractDirtyStateAwareEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class NatureAddingEditorCallback
extends AbstractDirtyStateAwareEditorCallback {
    @Inject
    private ToggleXtextNatureAction toggleNature;

    public void afterCreatePartControl(XtextEditor editor) {
        super.afterCreatePartControl(editor);
        IResource resource = editor.getResource();
        if (resource != null && !this.toggleNature.hasNature(resource.getProject()) && resource.getProject().isAccessible()) {
            String title = "Add Xtext Nature";
            String message = "Do you want the Xtext nature to be added to this project?";
            Image image = null;
            MessageDialog dialog = new MessageDialog(editor.getEditorSite().getShell(), title, image, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int open = dialog.open();
            if (open == 0) {
                this.toggleNature.toggleNature(resource.getProject());
            }
        }
    }
}

