/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.IResourceScopeCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnChangeEvictingCache
implements IResourceScopeCache {
    @Override
    public <T> T get(Object key, Resource cache, Provider<T> provider) {
        if (cache == null) {
            return (T)provider.get();
        }
        CacheAdapter adapter = this.getOrCreate((Notifier)cache);
        Object element = adapter.get(key);
        if (element == null) {
            element = provider.get();
            adapter.set(key, element);
        }
        return element;
    }

    public CacheAdapter getOrCreate(Notifier notifier) {
        CacheAdapter adapter = (CacheAdapter)EcoreUtil.getAdapter((List)notifier.eAdapters(), CacheAdapter.class);
        if (adapter == null) {
            adapter = new CacheAdapter();
            notifier.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheAdapter
    extends EContentAdapter {
        private Map<Object, Object> values = new HashMap<Object, Object>();
        private Collection<Listener> listeners = Sets.newHashSet();

        public void set(Object name, Object value) {
            this.values.put(name, value);
        }

        public <T> T get(Object name) {
            return (T)this.values.get(name);
        }

        public void addCacheListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void removeCacheListener(Listener listener) {
            this.listeners.remove(listener);
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (this.isSemanticStateChange(notification)) {
                this.values.clear();
                Iterator<Listener> iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    Listener next = iter.next();
                    iter.remove();
                    next.onEvict(this);
                }
            }
        }

        private boolean isSemanticStateChange(Notification notification) {
            return !notification.isTouch() && !(notification.getNewValue() instanceof Resource.Diagnostic);
        }

        public boolean isAdapterForType(Object type) {
            return type == ((Object)((Object)this)).getClass();
        }

        public <T> T get(Object key, Resource res, Provider<T> provider) {
            return null;
        }
    }

    public static interface Listener {
        public void onEvict(CacheAdapter var1);
    }
}

