/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.JvmModelJdtRenameParticipantContext;

public class JdtRenameRefactoringParticipantProcessor
extends RenameElementProcessor {
    @Inject
    private IJvmModelAssociations associations;

    public boolean initialize(IRenameElementContext renameElementContext) {
        Assert.isLegal((boolean)(renameElementContext instanceof JvmModelJdtRenameParticipantContext));
        return super.initialize(renameElementContext);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = this.preCheckInitialConditions(pm);
        if (status.hasError()) {
            return status;
        }
        return super.checkInitialConditions(pm);
    }

    protected RefactoringStatus preCheckInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.associations.getJvmElements(this.getTargetElement()).size() > 1) {
            StatusWrapper statusWrapper = (StatusWrapper)this.getStatusProvider().get();
            statusWrapper.add(3, "Rename from here will not be complete. Try to rename {0} instead.", this.getTargetElement());
            statusWrapper.merge(super.checkInitialConditions(pm));
            return statusWrapper.getRefactoringStatus();
        }
        return new RefactoringStatus();
    }
}

