/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.resource.OutdatedStateManager;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.IXtextModelListenerExtension;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.ui.editor.model.edit.ReconcilingUnitOfWork;
import org.eclipse.xtext.ui.util.DisplayRunnable;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.util.concurrent.IWriteAccess;

public class XtextDocument
extends Document
implements IXtextDocument {
    private DocumentTokenSource tokenSource;
    private ITextEditComposer composer;
    @Inject
    private OutdatedStateManager outdatedStateManager;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject(optional=true)
    private ReconcilingUnitOfWork.ReconcilingUnitOfWorkProvider reconcilingUnitOfWorkProvider = new ReconcilingUnitOfWork.ReconcilingUnitOfWorkProvider();
    private XtextResource resource = null;
    private final List<IXtextModelListener> modelListeners = new ArrayList<IXtextModelListener>();
    private final ListenerList<IXtextDocumentContentObserver> xtextDocumentObservers = new ListenerList(1);
    private final XtextDocumentLocker stateAccess = this.createDocumentLocker();
    private static final IUnitOfWork.Void<XtextResource> noWork = new IUnitOfWork.Void<XtextResource>(){

        public void process(XtextResource state) throws Exception {
        }
    };
    private static final Logger log = Logger.getLogger(XtextDocument.class);
    private transient Job validationJob;
    private ReadWriteLock positionsLock = new ReentrantReadWriteLock();
    private Lock positionsReadLock = this.positionsLock.readLock();
    private Lock positionsWriteLock = this.positionsLock.writeLock();

    public XtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer, OutdatedStateManager outdatedStateManager, OperationCanceledManager operationCanceledManager) {
        this(tokenSource, composer);
        this.outdatedStateManager = outdatedStateManager;
        this.operationCanceledManager = operationCanceledManager;
    }

    @Inject
    public XtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        this.tokenSource = tokenSource;
        tokenSource.computeDamageRegion(new DocumentEvent((IDocument)this, 0, this.getLength(), this.get()));
        this.composer = composer;
    }

    public void setInput(XtextResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    public void disposeInput() {
        if (this.validationJob != null) {
            this.validationJob.cancel();
        }
        this.internalModify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource state) throws Exception {
                if (state != null) {
                    state.getResourceSet().eSetDeliver(false);
                    state.getResourceSet().eAdapters().clear();
                    state.eSetDeliver(false);
                    state.eAdapters().clear();
                }
                XtextDocument.this.resource = null;
            }
        });
    }

    protected XtextDocumentLocker createDocumentLocker() {
        return new XtextDocumentLocker();
    }

    public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
        T readOnly = this.stateAccess.readOnly(work);
        return readOnly;
    }

    public <T> T priorityReadOnly(IUnitOfWork<T, XtextResource> work) {
        return this.stateAccess.priorityReadOnly(work);
    }

    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        this.readOnly((IUnitOfWork<T, XtextResource>)noWork);
        ReconcilingUnitOfWork<T> reconcilingUnitOfWork = this.reconcilingUnitOfWorkProvider.get(work, this, this.composer);
        return this.internalModify(reconcilingUnitOfWork);
    }

    public <T> T internalModify(IUnitOfWork<T, XtextResource> work) {
        return this.stateAccess.modify(work);
    }

    protected void ensureThatStateIsNotReturned(Object exec, IUnitOfWork<?, XtextResource> uow) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        List<IXtextModelListener> list = this.modelListeners;
        synchronized (list) {
            if (this.modelListeners.contains(listener)) {
                return;
            }
            if (listener instanceof DirtyStateEditorSupport) {
                this.modelListeners.add(0, listener);
            } else {
                this.modelListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        List<IXtextModelListener> list = this.modelListeners;
        synchronized (list) {
            this.modelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyModelListeners(XtextResource res) {
        ArrayList modelListenersCopy;
        if (res == null || res != this.resource) {
            return;
        }
        List<IXtextModelListener> list = this.modelListeners;
        synchronized (list) {
            modelListenersCopy = Lists.newArrayList(this.modelListeners);
        }
        CancelIndicator cancelIndicator = this.getCancelIndicator();
        for (IXtextModelListener listener : modelListenersCopy) {
            try {
                if (res != this.resource) {
                    return;
                }
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                if (listener instanceof IXtextModelListenerExtension) {
                    ((IXtextModelListenerExtension)((Object)listener)).modelChanged(res, cancelIndicator);
                    continue;
                }
                listener.modelChanged(res);
            }
            catch (Exception exc) {
                this.operationCanceledManager.propagateIfCancelException((Throwable)exc);
                log.error((Object)"Error in IXtextModelListener", (Throwable)exc);
            }
            catch (OperationCanceledError e) {
                throw e.getWrapped();
            }
        }
    }

    @Override
    public void addXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.addDocumentListener(observer);
        this.xtextDocumentObservers.add((Object)observer);
    }

    @Override
    public void removeXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.xtextDocumentObservers.remove((Object)observer);
        this.removeDocumentListener(observer);
    }

    protected boolean updateContentBeforeRead() {
        Object[] listeners = this.xtextDocumentObservers.getListeners();
        boolean hadUpdates = false;
        int i = 0;
        while (i < listeners.length) {
            hadUpdates |= ((IXtextDocumentContentObserver)listeners[i]).performNecessaryUpdates(this.stateAccess);
            ++i;
        }
        return hadUpdates;
    }

    protected boolean hasPendingUpdates() {
        Object[] listeners = this.xtextDocumentObservers.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (((IXtextDocumentContentObserver)listeners[i]).hasPendingUpdates()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CancelIndicator getCancelIndicator() {
        if (this.resource == null) {
            return CancelIndicator.NullImpl;
        }
        return this.outdatedStateManager.newCancelIndicator(this.resource.getResourceSet());
    }

    public void setOutdated(boolean outdated) {
        if (this.resource == null) {
            return;
        }
        if (outdated) {
            ((XtextResourceSet)this.resource.getResourceSet()).markOutdated();
        } else {
            ((XtextResourceSet)this.resource.getResourceSet()).markSynced();
        }
    }

    private void cancelReaders(XtextResource resource) {
        if (this.validationJob != null) {
            this.validationJob.cancel();
        }
        this.setOutdated(true);
    }

    protected Object getResourceLock() {
        return this.getResourceLock(this.resource);
    }

    private Object getResourceLock(XtextResource r) {
        if (r != null) {
            return r instanceof ISynchronizable ? ((ISynchronizable)r).getLock() : r;
        }
        return this;
    }

    public void setValidationJob(Job validationJob) {
        this.validationJob = validationJob;
    }

    public Job getValidationJob() {
        return this.validationJob;
    }

    public void checkAndUpdateAnnotations() {
        if (this.validationJob != null) {
            this.validationJob.cancel();
            if (this.resource != null && !this.getCancelIndicator().isCanceled()) {
                this.validationJob.schedule();
            }
        }
    }

    public URI getResourceURI() {
        XtextResource resource = this.resource;
        if (resource != null) {
            return resource.getURI();
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        XtextResource resource = this.resource;
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if ((adapterType == IFile.class || adapterType == IResource.class) && uri.isPlatformResource()) {
            return (T)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }

    public Position[] getPositions(String category, int offset, int length, boolean canStartBefore, boolean canEndAfter) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category, offset, length, canStartBefore, canEndAfter);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public void addPosition(Position position) throws BadLocationException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(Position position) {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    protected void fireDocumentChanged(final DocumentEvent event) {
        new DisplayRunnable(){

            @Override
            protected void run() throws Exception {
                XtextDocument.this.cancelReaders(XtextDocument.this.resource);
                XtextDocument.this.tokenSource.updateStructure(event);
                XtextDocument.super.fireDocumentChanged(event);
            }
        }.syncExec();
    }

    protected void fireRewriteSessionChanged(final DocumentRewriteSessionEvent event) {
        new DisplayRunnable(){

            @Override
            protected void run() throws Exception {
                XtextDocument.super.fireRewriteSessionChanged(event);
            }
        }.syncExec();
    }

    public IRegion getLastDamage() {
        return this.tokenSource.getLastDamagedRegion();
    }

    public Iterable<ILexerTokenRegion> getTokens() {
        return this.tokenSource.getTokenInfos();
    }

    static /* synthetic */ Object access$5(XtextDocument xtextDocument, XtextResource xtextResource) {
        return xtextDocument.getResourceLock(xtextResource);
    }

    protected class XtextDocumentLocker
    implements IXtextDocumentContentObserver.Processor,
    IReadAccess<XtextResource>,
    IReadAccess.Priority<XtextResource>,
    IWriteAccess<XtextResource> {
        private AtomicInteger potentialUpdaterCount = new AtomicInteger(0);
        private volatile boolean hadUpdates;
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Lock writeLock = this.rwLock.writeLock();
        private final Lock readLock = this.rwLock.readLock();
        private ThreadLocal<Integer> readLockCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        protected XtextDocumentLocker() {
        }

        @Override
        public <T> T process(IUnitOfWork<T, XtextResource> transaction) {
            if (this.getReadHoldCount() != 1 || this.getWriteHoldCount() != 0) {
                throw new IllegalStateException("Exactly one read lock and no write locks expected! But was read: " + this.getReadHoldCount() + ", write:" + this.getWriteHoldCount());
            }
            this.releaseReadLock();
            this.acquireWriteLock();
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("process - " + Thread.currentThread().getName()));
                }
                T t = this.modify(transaction);
                return t;
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Downgrading from write lock to read lock...");
                }
                this.acquireReadLock();
                this.releaseWriteLock();
            }
        }

        protected int getWriteHoldCount() {
            return this.rwLock.getWriteHoldCount();
        }

        protected int getReadHoldCount() {
            return this.readLockCount.get();
        }

        private void acquireReadLock() {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Trying to acquire read lock...");
            }
            this.readLock.lock();
            this.readLockCount.set(this.readLockCount.get() + 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)"...read lock acquired.");
            }
        }

        private void releaseReadLock() {
            this.readLock.unlock();
            this.readLockCount.set(this.readLockCount.get() - 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Read lock released.");
            }
        }

        private void acquireWriteLock() {
            if (XtextDocument.this.validationJob != null) {
                XtextDocument.this.validationJob.cancel();
            }
            XtextDocument.this.setOutdated(true);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Trying to acquire write lock...");
            }
            this.writeLock.lock();
            if (log.isTraceEnabled()) {
                log.trace((Object)"...write lock acquired.");
            }
            XtextDocument.this.setOutdated(false);
        }

        private void releaseWriteLock() {
            this.writeLock.unlock();
            if (log.isTraceEnabled()) {
                log.trace((Object)"Write lock released.");
            }
        }

        protected XtextResource getState() {
            return XtextDocument.this.resource;
        }

        /*
         * Exception decompiling
         */
        public <T> T modify(IUnitOfWork<T, XtextResource> work) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public <T> T priorityReadOnly(IUnitOfWork<T, XtextResource> work) {
            return this.internalReadOnly(work, true);
        }

        public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
            return this.internalReadOnly(work, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected <T> T internalReadOnly(IUnitOfWork<T, XtextResource> work, boolean isCancelReaders) {
            boolean isCancelable = work instanceof CancelableUnitOfWork;
            if (isCancelReaders) {
                if (Display.getCurrent() == null) {
                    log.error((Object)"Priority read only called from non UI-thread.", (Throwable)new IllegalStateException());
                }
                XtextDocument.this.cancelReaders(XtextDocument.this.resource);
            }
            XtextResource state = this.getState();
            Object object = XtextDocument.this.getResourceLock();
            synchronized (object) {
                this.acquireReadLock();
                if (isCancelReaders) {
                    XtextDocument.this.setOutdated(false);
                }
                try {
                    this.potentialUpdaterCount.incrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("read - " + Thread.currentThread().getName()));
                    }
                    if (this.getReadHoldCount() == 1 && this.getWriteHoldCount() == 0) {
                        this.hadUpdates |= XtextDocument.this.updateContentBeforeRead();
                    }
                    Object exec = XtextDocument.this.outdatedStateManager.exec(work, (Resource)state);
                    XtextDocument.this.ensureThatStateIsNotReturned(exec, work);
                    Object object2 = exec;
                    return (T)object2;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
                catch (OperationCanceledError e) {
                    throw e.getWrapped();
                }
                finally {
                    block28: {
                        block27: {
                            try {
                                try {
                                    if (this.potentialUpdaterCount.decrementAndGet() != 0 || !this.hadUpdates && !isCancelReaders) break block27;
                                    boolean wasHadUpdates = this.hadUpdates;
                                    this.hadUpdates = false;
                                    if (XtextDocument.this.getCancelIndicator().isCanceled() && isCancelable) {
                                        throw new OperationCanceledException();
                                    }
                                    if (wasHadUpdates) {
                                        XtextDocument.this.notifyModelListeners(state);
                                    }
                                }
                                catch (RuntimeException e) {
                                    if (!XtextDocument.this.operationCanceledManager.isOperationCanceledException((Throwable)e)) {
                                        throw e;
                                    }
                                    if (isCancelable) {
                                        throw e;
                                    }
                                    this.releaseReadLock();
                                    break block28;
                                }
                            }
                            catch (Throwable throwable) {
                                this.releaseReadLock();
                                throw throwable;
                            }
                        }
                        this.releaseReadLock();
                    }
                }
            }
        }
    }
}

