/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.conversion;

import org.antlr.runtime.TokenSource;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public class JavaIDValueConverter
extends IDValueConverter {
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.charAt(0) == '^') {
                string = string.substring(1);
            }
            String result = JavaIDValueConverter.convertFromJavaIdentifier(string, node);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    protected void assertValidValue(String value) {
        super.assertValidValue(value);
        if (!JavaIDValueConverter.isValidIdentifierStart(value.charAt(0))) {
            throw new ValueConverterException(String.valueOf(value) + " is not a valid identifier.", null, null);
        }
        int i = 1;
        int length = value.length();
        while (i < length) {
            if (!JavaIDValueConverter.isValidIdentifierPart(value.charAt(i))) {
                throw new ValueConverterException(String.valueOf(value) + " is not a valid identifier.", null, null);
            }
            ++i;
        }
    }

    protected void assertTokens(String value, String result) {
    }

    protected TokenSource getTokenSource(String escapedValue) {
        throw new UnsupportedOperationException();
    }

    public static boolean isValidIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isValidIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static String convertFromJavaIdentifier(String identifier, INode node) {
        int idx = identifier.indexOf(92);
        if (idx < 0) {
            return identifier;
        }
        return JavaIDValueConverter.doConvertFromJavaString(identifier, idx, node);
    }

    private static int unescapeCharAndAppendTo(String string, int index, StringBuilder result, ErrorInfo errorInfo) {
        char c;
        if ((c = string.charAt(index++)) == '\\') {
            index = JavaIDValueConverter.doUnescapeCharAndAppendTo(string, index, result, errorInfo);
        } else {
            JavaIDValueConverter.validateAndAppendChar(result, c, errorInfo);
        }
        return index;
    }

    private static int doUnescapeCharAndAppendTo(String string, int index, StringBuilder result, ErrorInfo errorInfo) {
        if (string.length() == index) {
            errorInfo.badChar = true;
            return index;
        }
        char c = string.charAt(index++);
        switch (c) {
            case 'u': {
                return JavaIDValueConverter.unescapeUnicodeSequence(string, index, result, errorInfo);
            }
        }
        errorInfo.badChar = true;
        JavaIDValueConverter.validateAndAppendChar(result, c, errorInfo);
        return index;
    }

    private static int unescapeUnicodeSequence(String string, int index, StringBuilder result, ErrorInfo errorInfo) {
        try {
            if (index + 4 > string.length() || !JavaIDValueConverter.isHexSequence(string, index, 4)) {
                result.append('u');
                errorInfo.error = true;
                return index;
            }
            char appendMe = (char)Integer.parseInt(string.substring(index, index + 4), 16);
            JavaIDValueConverter.validateAndAppendChar(result, appendMe, errorInfo);
            return index + 4;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal \\uxxxx encoding in " + string);
        }
    }

    private static void validateAndAppendChar(StringBuilder result, char c, ErrorInfo error) {
        if (result.length() == 0) {
            if (!JavaIDValueConverter.isValidIdentifierStart(c)) {
                error.badChar = true;
                return;
            }
        } else if (!JavaIDValueConverter.isValidIdentifierPart(c)) {
            error.badChar = true;
            return;
        }
        result.append(c);
    }

    private static String doConvertFromJavaString(String identifier, int firstEscapeSequence, INode node) throws ValueConverterException {
        int length = identifier.length();
        StringBuilder result = new StringBuilder(length);
        result.append(identifier, 0, firstEscapeSequence);
        ErrorInfo errorInfo = new ErrorInfo();
        int nextIndex = firstEscapeSequence;
        while (nextIndex < length) {
            nextIndex = JavaIDValueConverter.unescapeCharAndAppendTo(identifier, nextIndex, result, errorInfo);
        }
        String asString = result.toString();
        if (errorInfo.error) {
            throw new ValueConverterWithValueException("Illegal escape sequence in identifier '" + identifier + "'", node, (Object)asString, null);
        }
        if (errorInfo.badChar) {
            if (result.length() != 0) {
                throw new ValueConverterWithValueException("Illegal character in identifier '" + asString + "' (" + identifier + ")", node, (Object)asString, null);
            }
            throw new ValueConverterWithValueException("Illegal character in identifier '" + identifier + "'", node, null, null);
        }
        return asString;
    }

    private static boolean isHexSequence(String in, int off, int chars) {
        int i = off;
        while (i < in.length() && i < off + chars) {
            char c = in.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static class ErrorInfo {
        boolean error = false;
        boolean badChar = false;

        private ErrorInfo() {
        }
    }
}

