/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.builder.preferences.Messages;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.ui.preferences.ScrolledPageContent;

public class BuilderConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String SETTINGS_SECTION_NAME = "BuilderConfigurationBlock";
    private EclipseOutputConfigurationProvider configurationProvider;

    public BuilderConfigurationBlock(IProject project, IPreferenceStore preferenceStore, EclipseOutputConfigurationProvider configurationProvider, IWorkbenchPreferenceContainer container) {
        super(project, preferenceStore, container);
        this.configurationProvider = configurationProvider;
    }

    protected Control doCreateContents(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        String[] trueFalseValues = new String[]{"true", "false"};
        int columns = 3;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        String label = Messages.BuilderConfigurationBlock_GeneralSection_Label;
        ExpandableComposite excomposite = this.createStyleSection(composite, label, columns);
        Composite othersComposite = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)othersComposite);
        othersComposite.setLayout((Layout)new GridLayout(columns, false));
        this.addCheckBox(othersComposite, Messages.BuilderPreferencePage_GenerateAuto, "autobuilding", trueFalseValues, 0);
        Set<OutputConfiguration> outputConfigurations = this.configurationProvider.getOutputConfigurations(this.getProject());
        for (OutputConfiguration outputConfiguration : outputConfigurations) {
            label = outputConfiguration.getDescription();
            excomposite = this.createStyleSection(composite, label, columns);
            othersComposite = new Composite((Composite)excomposite, 0);
            excomposite.setClient((Control)othersComposite);
            othersComposite.setLayout((Layout)new GridLayout(columns, false));
            this.addTextField(othersComposite, Messages.OutputConfigurationPage_Directory, BuilderPreferenceAccess.getKey(outputConfiguration, "directory"), 0, 200);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CreateDirectory, BuilderPreferenceAccess.getKey(outputConfiguration, "createDirectory"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_OverrideExistingResources, BuilderPreferenceAccess.getKey(outputConfiguration, "override"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CreatesDerivedResources, BuilderPreferenceAccess.getKey(outputConfiguration, "derived"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CleanupDerivedResources, BuilderPreferenceAccess.getKey(outputConfiguration, "cleanupDerived"), trueFalseValues, 0);
            this.addCheckBox(othersComposite, Messages.OutputConfigurationPage_CleanDirectory, BuilderPreferenceAccess.getKey(outputConfiguration, "cleanDirectory"), trueFalseValues, 0);
            final Button installAsPrimaryButton = this.addCheckBox(othersComposite, Messages.BuilderConfigurationBlock_InstallDslAsPrimarySource, BuilderPreferenceAccess.getKey(outputConfiguration, "installDslAsPrimarySource"), trueFalseValues, 0);
            final Button hideLocalButton = this.addCheckBox(othersComposite, Messages.BuilderConfigurationBlock_hideSyntheticLocalVariables, BuilderPreferenceAccess.getKey(outputConfiguration, "hideLocalSyntheticVariables"), trueFalseValues, 0);
            hideLocalButton.setEnabled(installAsPrimaryButton.getSelection());
            installAsPrimaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    hideLocalButton.setEnabled(installAsPrimaryButton.getSelection());
                }
            });
            GridData hideLocalButtonData = new GridData();
            hideLocalButtonData.horizontalIndent = 32;
            hideLocalButton.setLayoutData((Object)hideLocalButtonData);
        }
        this.registerKey("is_project_specific");
        IDialogSettings section = Activator.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(section);
        return pageContent;
    }

    protected void validateSettings(String changedKey, String oldValue, String newValue) {
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(settings);
        super.dispose();
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.BuilderConfigurationBlock_SettingsChanged_Title;
        String message = workspaceSettings ? Messages.BuilderConfigurationBlock_SettingsChanged_WorkspaceBuild : Messages.BuilderConfigurationBlock_SettingsChanged_ProjectBuild;
        return new String[]{title, message};
    }

    protected Job getBuildJob(IProject project) {
        OptionsConfigurationBlock.BuildJob buildJob = new OptionsConfigurationBlock.BuildJob(Messages.BuilderConfigurationBlock_BuildJob_Title0, project);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }
}

