/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;

public class TextViewerOperationAction
extends TextViewerAction {
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;
    private boolean fRunsOnReadOnly = false;
    private boolean fAllowUpdate = false;

    public TextViewerOperationAction(ResourceBundle bundle, String prefix, ITextViewer viewer, int operationCode) {
        this(bundle, prefix, viewer, operationCode, false);
    }

    public TextViewerOperationAction(ResourceBundle bundle, String prefix, ITextViewer viewer, int operationCode, boolean runsOnReadOnly) {
        super(bundle, prefix);
        this.setViewer(viewer);
        this.fOperationCode = operationCode;
        this.fRunsOnReadOnly = runsOnReadOnly;
        this.fAllowUpdate = true;
        this.update();
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (viewer == null) {
            return;
        }
        if (!this.fRunsOnReadOnly && !this.canModifyViewer()) {
            return;
        }
        Display display = null;
        Shell shell = viewer.getTextWidget().getShell();
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                TextViewerOperationAction.this.fOperationTarget.doOperation(TextViewerOperationAction.this.fOperationCode);
            }
        });
    }

    public void update() {
        if (!this.fAllowUpdate) {
            return;
        }
        super.update();
        if (!this.fRunsOnReadOnly && !this.canModifyViewer()) {
            this.setEnabled(false);
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (this.fOperationTarget == null && viewer != null && this.fOperationCode != -1) {
            this.fOperationTarget = viewer.getTextOperationTarget();
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(isEnabled);
    }

    public void setViewer(ITextViewer viewer) {
        super.setViewer(viewer);
        this.fOperationTarget = null;
    }
}

