/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;

@NonNullByDefault
public class TextRegionWithLineInformation
extends TextRegion
implements ITextRegionWithLineInformation {
    private final int lineNumber;
    private final int endLineNumber;

    public TextRegionWithLineInformation(int offset, int length, int lineNumber, int endLineNumber) {
        super(offset, length);
        if (lineNumber < 0) {
            throw new IllegalArgumentException("lineNumber " + lineNumber + " is < 0");
        }
        if (endLineNumber < lineNumber) {
            throw new IllegalArgumentException("endLineNumber " + endLineNumber + " is < lineNumber " + lineNumber);
        }
        this.lineNumber = lineNumber;
        this.endLineNumber = endLineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public ITextRegion merge(ITextRegion other) {
        if (other instanceof ITextRegionWithLineInformation) {
            return this.merge((ITextRegionWithLineInformation)other);
        }
        return super.merge(other);
    }

    public ITextRegionWithLineInformation merge(ITextRegionWithLineInformation other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        int newOffset = Math.min(this.getOffset(), other.getOffset());
        int newLength = Math.max(this.getOffset() + this.getLength(), other.getOffset() + other.getLength()) - newOffset;
        int newLineNumber = Math.min(this.getLineNumber(), other.getLineNumber());
        int newEndLineNumber = Math.max(this.getEndLineNumber(), other.getEndLineNumber());
        return new TextRegionWithLineInformation(newOffset, newLength, newLineNumber, newEndLineNumber);
    }

    public String toString() {
        return "TextRegionWithLineInformation " + super.toString() + "[lineNumber=" + this.lineNumber + ", endLineNumber=" + this.endLineNumber + "]";
    }
}

