/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditor;

public class JavaEditorInputMatcher
implements IEditorMatchingStrategy {
    private static final Logger logger = Logger.getLogger(JavaEditorInputMatcher.class);
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private XtextEditorInfo editorInfo;
    @Inject
    private StacktraceBasedEditorDecider decisions;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(IEditorReference editorRef, IEditorInput newInput) {
        try {
            if (!this.editorInfo.getEditorId().equals(editorRef.getId())) {
                return false;
            }
            IEditorInput currentInput = editorRef.getEditorInput();
            if (newInput.equals(currentInput)) {
                return true;
            }
            if (this.decisions.decideAccordingToCaller() == StacktraceBasedEditorDecider.Decision.FORCE_JAVA) {
                return false;
            }
            IFile newResource = ResourceUtil.getFile((IEditorInput)newInput);
            if (newResource == null) {
                return false;
            }
            IResource currentResource = ResourceUtil.getResource((IEditorInput)currentInput);
            ITrace traceToSource = this.traceInformation.getTraceToSource((IStorage)newResource);
            if (traceToSource == null) {
                return false;
            }
            Iterable allLocations = traceToSource.getAllAssociatedLocations();
            boolean thisIsTheOnlyOne = false;
            Iterator iterator = allLocations.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    IEditorPart existingEditor;
                    if (!thisIsTheOnlyOne || !((existingEditor = editorRef.getEditor(true)) instanceof XbaseEditor)) return false;
                    ((XbaseEditor)existingEditor).markNextSelectionAsJavaOffset((IResource)newResource);
                    return true;
                }
                ILocationInResource location = (ILocationInResource)iterator.next();
                if (!currentResource.equals((Object)location.getStorage())) {
                    return false;
                }
                thisIsTheOnlyOne = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

