/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractReturnAwareTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractStackedTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.NoExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.ExpectationTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.RawTypeSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeArgumentFromComputedTypeCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractLinkingCandidate<Expression extends XExpression>
implements ILinkingCandidate {
    private final ExpressionTypeComputationState state;
    private final Expression expression;
    private List<LightweightTypeReference> typeArguments;
    protected IFeatureCallArguments arguments;

    protected AbstractLinkingCandidate(Expression expression, ExpressionTypeComputationState state) {
        this.expression = expression;
        this.state = state;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> initializeTypeParameterMapping() {
        LinkedHashMap typeParameterMapping;
        this.state.getResolvedTypes().acceptLinkingInformation((XExpression)this.expression, this);
        List<JvmTypeParameter> declaredTypeParameters = this.getDeclaredTypeParameters();
        if (declaredTypeParameters.isEmpty()) {
            typeParameterMapping = Collections.emptyMap();
        } else {
            JvmTypeParameter declaredTypeParameter;
            typeParameterMapping = Maps.newLinkedHashMap();
            List<LightweightTypeReference> explicitTypeArguments = this.getSyntacticTypeArguments();
            int size = Math.min(declaredTypeParameters.size(), explicitTypeArguments.size());
            int i = 0;
            while (i < size) {
                LightweightTypeReference substitute;
                declaredTypeParameter = declaredTypeParameters.get(i);
                LightweightTypeReference explicitTypeArgument = explicitTypeArguments.get(i);
                UnboundTypeReference typeReference = this.state.getResolvedTypes().createUnboundTypeReference((XExpression)this.expression, declaredTypeParameter);
                if (explicitTypeArgument != null && explicitTypeArgument.isValidHint() && !(substitute = explicitTypeArgument.getInvariantBoundSubstitute()).isAny()) {
                    typeReference.acceptHint(substitute, BoundTypeArgumentSource.EXPLICIT, this.expression, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
                }
                typeParameterMapping.put(declaredTypeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
                ++i;
            }
            i = size;
            while (i < declaredTypeParameters.size()) {
                declaredTypeParameter = declaredTypeParameters.get(i);
                this.initializeMapping(declaredTypeParameter, typeParameterMapping);
                ++i;
            }
        }
        return typeParameterMapping;
    }

    protected void initializeMapping(JvmTypeParameter typeParameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> result) {
        UnboundTypeReference typeReference = this.state.getResolvedTypes().createUnboundTypeReference((XExpression)this.expression, typeParameter);
        result.put(typeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
    }

    protected void accept(ObservableTypeExpectation expectation, LightweightTypeReference actual) {
        LightweightTypeReference expectedType = expectation.getExpectedType();
        if (expectedType == null || actual instanceof AnyTypeReference || actual.isPrimitiveVoid()) {
            return;
        }
        this.resolveAgainstActualType(expectedType, actual, expectation.getState());
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        if (this.typeArguments == null) {
            List<JvmTypeParameter> typeParameters = this.getDeclaredTypeParameters();
            if (typeParameters.isEmpty()) {
                this.typeArguments = Collections.emptyList();
            } else {
                ArrayList result = Lists.newArrayListWithCapacity((int)typeParameters.size());
                for (JvmTypeParameter parameter : typeParameters) {
                    LightweightMergedBoundTypeArgument typeArgument = this.getTypeParameterMapping().get(parameter);
                    result.add(typeArgument.getTypeReference());
                }
                this.typeArguments = result;
            }
        }
        return this.typeArguments;
    }

    protected abstract Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping();

    protected List<JvmTypeParameter> getDeclaredTypeParameters() {
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmTypeParameterDeclarator) {
            return ((JvmTypeParameterDeclarator)feature).getTypeParameters();
        }
        return Collections.emptyList();
    }

    @Override
    public void applyToComputationState() {
        this.preApply();
        JvmIdentifiableElement feature = this.getFeature();
        LightweightTypeReference featureType = this.getDeclaredType(feature);
        for (ITypeExpectation iTypeExpectation : this.state.getExpectations()) {
            TypeParameterSubstitutor substitutor = null;
            if (!this.isRawTypeContext()) {
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> declaratorParameterMapping = this.getDeclaratorParameterMapping();
                substitutor = new TypeParameterByUnboundSubstitutor(declaratorParameterMapping, iTypeExpectation.getReferenceOwner()){

                    protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                        UnboundTypeReference result = AbstractLinkingCandidate.this.state.getResolvedTypes().createUnboundTypeReference(AbstractLinkingCandidate.this.expression, type);
                        return result;
                    }

                    @Nullable
                    protected LightweightTypeReference getBoundTypeArgument(ParameterizedTypeReference reference, JvmTypeParameter type, ConstraintVisitingInfo visiting) {
                        if (this.getOwner().getDeclaredTypeParameters().contains(type)) {
                            return null;
                        }
                        return super.getBoundTypeArgument(reference, type, visiting);
                    }

                    @Nullable
                    protected LightweightMergedBoundTypeArgument getBoundTypeArgument(JvmTypeParameter typeParameter, ConstraintVisitingInfo info) {
                        JvmTypeConstraint constraint;
                        LightweightTypeReference typeReference;
                        LightweightMergedBoundTypeArgument result = super.getBoundTypeArgument(typeParameter, info);
                        if (result != null && result.getVariance() == VarianceInfo.INVARIANT && (typeReference = result.getTypeReference()).isWildcard() && typeReference.getLowerBoundSubstitute().isAny() && typeReference.getUpperBoundSubstitute().isType(Object.class) && !typeParameter.getConstraints().isEmpty() && (constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(0)) instanceof JvmUpperBound) {
                            LightweightTypeReference reference = new OwnedConverter(this.getOwner()).toLightweightReference(constraint.getTypeReference());
                            return new LightweightMergedBoundTypeArgument(reference, VarianceInfo.OUT);
                        }
                        return result;
                    }
                };
                substitutor.enhanceMapping(this.getTypeParameterMapping());
            } else {
                substitutor = new RawTypeSubstitutor(iTypeExpectation.getReferenceOwner());
            }
            LightweightTypeReference substitutedFeatureType = substitutor.substitute(featureType).getUpperBoundSubstitute();
            this.deferredBindTypeArgument(iTypeExpectation, substitutedFeatureType);
            iTypeExpectation.acceptActualType(substitutedFeatureType, ConformanceHint.UNCHECKED);
        }
        this.state.getStackedResolvedTypes().mergeIntoParent();
    }

    protected void preApply() {
        this.computeArgumentTypes();
    }

    protected void deferredBindTypeArgument(ITypeExpectation expectation, LightweightTypeReference type) {
        LightweightTypeReference expectedType = expectation.getExpectedType();
        if (expectedType != null) {
            ExpectationTypeParameterHintCollector collector = new ExpectationTypeParameterHintCollector(this.state.getReferenceOwner());
            collector.processPairedReferences(expectedType, type);
        }
    }

    public void computeArgumentTypes() {
        this.initializeArgumentTypeComputation();
        while (this.arguments.hasUnprocessedArguments()) {
            this.computeArgumentType(this.arguments.getNextUnprocessedArgumentSlot());
        }
    }

    protected void initializeArgumentTypeComputation() {
        if (this.arguments != null) {
            return;
        }
        this.arguments = this.state.getResolver().getExpressionArgumentFactory().createExpressionArguments((XExpression)this.expression, this);
    }

    protected void computeArgumentType(IFeatureCallArgumentSlot slot) {
        TypeParameterSubstitutor<?> substitutor = this.createArgumentTypeSubstitutor();
        if (!slot.isVarArg() && !slot.isSuperfluous()) {
            this.computeFixedArityArgumentType(slot, substitutor);
        } else if (slot.isVarArg()) {
            this.computeVarArgumentType(slot, substitutor);
        } else {
            XExpression argument = slot.getArgumentExpression();
            if (argument != null) {
                this.resolveArgumentType(argument, null, this.state.withNonVoidExpectation());
            }
        }
        slot.markProcessed();
    }

    protected void computeVarArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        LightweightTypeReference componentType;
        LightweightTypeReference lastParameterType = slot.getDeclaredType();
        if (lastParameterType == null) {
            throw new IllegalStateException();
        }
        LightweightTypeReference lightweightTypeReference = componentType = lastParameterType.isArray() ? lastParameterType.getComponentType() : lastParameterType;
        if (componentType == null) {
            throw new IllegalStateException();
        }
        ITypeComputationState argumentState = null;
        LightweightTypeReference substitutedComponentType = substitutor.substitute(componentType);
        List<XExpression> arguments = slot.getArgumentExpressions();
        if (!substitutedComponentType.isAny()) {
            if (arguments.size() == 1) {
                ArgumentTypeComputationState first = this.createVarArgTypeComputationState(substitutedComponentType);
                ArrayTypeReference arrayTypeReference = new ArrayTypeReference(substitutedComponentType.getOwner(), substitutedComponentType);
                ArgumentTypeComputationState second = this.createLinkingTypeComputationState(arrayTypeReference);
                argumentState = new CompoundTypeComputationState(substitutedComponentType.getOwner(), first, second);
            } else {
                argumentState = this.createVarArgTypeComputationState(substitutedComponentType);
            }
            for (XExpression argument : arguments) {
                if (argument == null) continue;
                this.resolveArgumentType(argument, substitutedComponentType, argumentState);
            }
        } else {
            for (XExpression argument : arguments) {
                if (argument == null) continue;
                this.resolveArgumentType(argument, null, this.state.withNonVoidExpectation());
            }
        }
    }

    protected TypeParameterSubstitutor<?> createArgumentTypeSubstitutor() {
        if (this.isRawTypeContext()) {
            return new RawTypeSubstitutor(this.state.getReferenceOwner());
        }
        UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(this.getDeclaratorParameterMapping(), this.state.getReferenceOwner()){

            @Override
            @Nullable
            protected LightweightTypeReference getBoundTypeArgument(ParameterizedTypeReference reference, JvmTypeParameter type, Set<JvmTypeParameter> visiting) {
                if (type.getDeclarator() instanceof JvmType && this.getOwner().getDeclaredTypeParameters().contains(type)) {
                    return null;
                }
                return super.getBoundTypeArgument(reference, type, visiting);
            }
        };
        substitutor.enhanceMapping(this.getTypeParameterMapping());
        return substitutor;
    }

    protected boolean isRawTypeContext() {
        return false;
    }

    protected void computeFixedArityArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        XExpression argument = slot.getArgumentExpression();
        if (argument != null) {
            LightweightTypeReference parameterType = slot.getDeclaredType();
            if (parameterType == null) {
                this.resolveArgumentType(argument, null, this.state.withNonVoidExpectation());
            } else {
                LightweightTypeReference substitutedParameterType = substitutor.substitute(parameterType);
                ArgumentTypeComputationState argumentState = this.createLinkingTypeComputationState(substitutedParameterType);
                this.resolveArgumentType(argument, substitutedParameterType, argumentState);
            }
        }
    }

    protected ArgumentTypeComputationState createLinkingTypeComputationState(LightweightTypeReference expectedType) {
        return new ArgumentTypeComputationState(this.state, expectedType.getLowerBoundSubstitute(), null);
    }

    protected ArgumentTypeComputationState createVarArgTypeComputationState(LightweightTypeReference expectedType) {
        return new ArgumentTypeComputationState(this.state, expectedType.getLowerBoundSubstitute(), ConformanceHint.VAR_ARG);
    }

    protected void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, AbstractTypeComputationState state) {
        List<JvmTypeParameter> typeParameters;
        if (!actualType.isAny() && !(typeParameters = this.getDeclaredTypeParameters()).isEmpty()) {
            TypeArgumentFromComputedTypeCollector.resolveAgainstActualType(declaredType, actualType, typeParameters, this.getTypeParameterMapping(), BoundTypeArgumentSource.EXPECTATION, state.getReferenceOwner());
        }
    }

    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        LightweightTypeReference result = this.state.getResolvedTypes().getActualType(feature);
        if (result == null) {
            return new AnyTypeReference(this.getState().getReferenceOwner());
        }
        return result;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getDeclaratorParameterMapping() {
        return Collections.emptyMap();
    }

    protected void resolveArgumentType(XExpression argument, @Nullable LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        argumentState.computeTypes(argument);
    }

    protected abstract List<XExpression> getArguments();

    @Override
    public abstract ILinkingCandidate getPreferredCandidate(ILinkingCandidate var1);

    @Nullable
    protected LightweightTypeReference getExpectedType(XExpression expression) {
        return this.state.getResolvedTypes().getExpectedType(expression);
    }

    @Nullable
    protected LightweightTypeReference getActualType(JvmIdentifiableElement element, boolean ignoreReassignedTypes) {
        return this.state.getResolvedTypes().doGetActualType(element, ignoreReassignedTypes);
    }

    @Nullable
    protected LightweightTypeReference getActualType(@Nullable XExpression expression) {
        if (expression == null) {
            return null;
        }
        return this.state.getResolvedTypes().getActualType(expression);
    }

    @Nullable
    protected LightweightTypeReference getSubstitutedExpectedType(int argumentIndex) {
        XExpression expression = this.arguments.getArgument(argumentIndex);
        if (expression == null) {
            return null;
        }
        LightweightTypeReference expectedType = this.getExpectedType(expression);
        if (expectedType != null) {
            if (expectedType instanceof UnboundTypeReference) {
                expectedType = new ParameterizedTypeReference(expectedType.getOwner(), (JvmType)((UnboundTypeReference)expectedType).getTypeParameter());
            }
            expectedType = expectedType.getRawTypeReference();
        }
        return expectedType;
    }

    protected abstract List<LightweightTypeReference> getSyntacticTypeArguments();

    @Override
    public abstract JvmIdentifiableElement getFeature();

    public Expression getExpression() {
        return this.expression;
    }

    protected boolean hasReceiver() {
        return false;
    }

    protected ExpressionTypeComputationState getState() {
        return this.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArgumentTypeComputationState
    extends AbstractStackedTypeComputationState {
        private final LightweightTypeReference expectedType;
        private final ConformanceHint defaultHint;

        public ArgumentTypeComputationState(AbstractTypeComputationState parent, @Nullable LightweightTypeReference expectedType, ConformanceHint defaultHint) {
            super(parent.getResolvedTypes(), parent.getFeatureScopeSession(), parent);
            this.expectedType = expectedType;
            this.defaultHint = defaultHint;
        }

        @Override
        protected List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState actualState) {
            AbstractTypeExpectation result = this.createTypeExpectation(this.expectedType, actualState, false, this.defaultHint);
            return Collections.singletonList(result);
        }

        protected AbstractTypeExpectation createTypeExpectation(@Nullable LightweightTypeReference expectedType, AbstractTypeComputationState actualState, boolean returnType, @Nullable ConformanceHint hint) {
            AbstractReturnAwareTypeExpectation result = null;
            if (expectedType != null) {
                LightweightTypeReference copied = expectedType.copyInto(actualState.getReferenceOwner());
                result = new ObservableTypeExpectation(copied, actualState, returnType, hint);
            } else {
                result = new NoExpectation(actualState, returnType);
            }
            return result;
        }

        protected LightweightTypeReference getExpectedType() {
            return this.expectedType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ObservableTypeExpectation
    extends TypeExpectation {
        private ConformanceHint conformanceHint;

        public ObservableTypeExpectation(LightweightTypeReference expectedType, AbstractTypeComputationState state, @Nullable boolean returnType, ConformanceHint conformanceHint) {
            super(expectedType, state, returnType);
            this.conformanceHint = conformanceHint;
        }

        @Override
        public void acceptActualType(LightweightTypeReference type, ConformanceHint ... hints) {
            ConformanceHint[] actualHints = hints;
            if (this.conformanceHint != null) {
                actualHints = new ConformanceHint[hints.length + 1];
                System.arraycopy(hints, 0, actualHints, 0, hints.length);
                actualHints[hints.length] = this.conformanceHint;
            }
            AbstractLinkingCandidate.this.accept(this, type);
            super.acceptActualType(type, actualHints);
        }

        @Override
        public ObservableTypeExpectation copyInto(ITypeReferenceOwner referenceOwner) {
            LightweightTypeReference expectedType = this.getExpectedType();
            if (expectedType == null || expectedType.isOwnedBy(referenceOwner)) {
                return this;
            }
            return new ObservableTypeExpectation(expectedType.copyInto(referenceOwner), this.getState(), this.isReturnType(), this.conformanceHint);
        }
    }
}

