/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectBasedBuilderParticipant
implements IXtextBuilderParticipant {
    @Inject
    private IGenerator generator;
    @Inject
    private Provider<EclipseResourceFileSystemAccess> fileAccessProvider;
    @Inject
    private IResourceServiceProvider resourceServiceProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    private Map<URI, Set<String>> sourceTargetMap = Maps.newHashMap();

    @Override
    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        IProject builtProject = context.getBuiltProject();
        IJavaProject javaProject = JavaCore.create((IProject)builtProject);
        if (!javaProject.exists()) {
            return;
        }
        IFolder srcGenFolder = this.getSrcGenFolder(builtProject);
        if (!srcGenFolder.exists()) {
            return;
        }
        if (!this.isValidOutputFolder(javaProject, srcGenFolder)) {
            return;
        }
        for (IResourceDescription.Delta delta : context.getDeltas()) {
            final HashSet oldFiles = Sets.newHashSet();
            if (this.sourceTargetMap.containsKey(delta.getUri())) {
                oldFiles.addAll((Collection)this.sourceTargetMap.get(delta.getUri()));
            }
            final HashSet newFiles = Sets.newHashSet();
            IFileSystemAccess fileSystemAccess = this.getConfiguredFileSystemAccess(srcGenFolder, new IAcceptor<String>(){

                public void accept(String fileName) {
                    oldFiles.remove(fileName);
                    newFiles.add(fileName);
                }
            });
            if (delta.getNew() == null) {
                this.handleDeletion(delta, context, fileSystemAccess);
            } else {
                this.handleChangedContents(delta, context, fileSystemAccess);
            }
            for (String removeFile : oldFiles) {
                fileSystemAccess.deleteFile(removeFile);
            }
            if (newFiles.isEmpty()) continue;
            this.sourceTargetMap.put(delta.getUri(), newFiles);
        }
    }

    protected boolean isValidOutputFolder(IJavaProject javaProject, IFolder srcGenFolder) {
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)srcGenFolder);
        return root.exists();
    }

    protected IFolder getSrcGenFolder(IProject builtProject) {
        return builtProject.getFolder("src-gen");
    }

    protected IFileSystemAccess getConfiguredFileSystemAccess(IFolder srcGenFolder, IAcceptor<String> newFileAcceptor) {
        EclipseResourceFileSystemAccess access = (EclipseResourceFileSystemAccess)((Object)this.fileAccessProvider.get());
        access.setOutputPath(srcGenFolder.getFullPath().toString());
        access.setNewFileAcceptor(newFileAcceptor);
        return access;
    }

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess fileSystemAccess) {
        if (!this.resourceServiceProvider.canHandle(delta.getUri())) {
            return;
        }
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        if (this.shouldGenerate(resource, context)) {
            this.generator.doGenerate(resource, fileSystemAccess);
            context.needRebuild();
        }
    }

    protected boolean shouldGenerate(Resource resource, IXtextBuilderParticipant.IBuildContext context) {
        try {
            Iterable storages = this.storage2UriMapper.getStorages(resource.getURI());
            for (Pair pair : storages) {
                if (!(pair.getFirst() instanceof IFile) || !((IProject)pair.getSecond()).equals((Object)context.getBuiltProject())) continue;
                return ((IFile)pair.getFirst()).findMaxProblemSeverity(null, true, 2) != 2;
            }
            return false;
        }
        catch (CoreException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }

    protected void handleDeletion(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess fileSystemAccess) {
    }
}

