/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.doc;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;

public class Textile2xdoc {
    public static void main(String[] args) {
        try {
            new Textile2xdoc().transform();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void transform() throws IOException {
        File sourceDir = new File("doc");
        File targetDir = new File("xdoc");
        targetDir.mkdir();
        FilenameFilter textileFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".textile");
            }
        };
        FileWriter index = new FileWriter(targetDir + File.separator + "Xtext.xdoc");
        index.write("document[Xtext Documentation]\n");
        FileWriter lastChapter = index;
        String[] stringArray = sourceDir.list(textileFilter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceFileName = stringArray[n2];
            String sourceFullName = String.valueOf(sourceDir.getName()) + File.separator + sourceFileName;
            System.out.println(sourceFullName);
            String source = Files.readFileIntoString((String)sourceFullName);
            String target = this.transform(source);
            String targetFullName = String.valueOf(targetDir.getName()) + File.separator + sourceFileName.replaceAll("\\.textile", ".xdoc");
            System.out.println("-->" + targetFullName);
            Files.writeStringIntoFile((String)targetFullName, (String)target);
            if (!Strings.isEmpty((String)target)) {
                String sectionType = target.substring(0, target.indexOf(58));
                String sectionLabel = target.substring(target.indexOf(58) + 1, target.indexOf("["));
                if ("chapter".equals(sectionType)) {
                    index.write("\n\n" + sectionType + "-ref[" + sectionLabel + "]");
                    if (lastChapter != index) {
                        lastChapter.close();
                    }
                    lastChapter = new FileWriter(targetFullName, true);
                } else {
                    lastChapter.write("\n\n" + sectionType + "-ref[" + sectionLabel + "]");
                }
            }
            System.out.println();
            ++n2;
        }
        index.close();
    }

    private String transform(String source) {
        return new TransformationBuilder(source).transformBrackets().transformBlocks().transformEnumerations("#", "ol").transformEnumerations("\\*", "ul").transformMarkup("\\*\\*", "\\*\\*", "e").transformMarkup("__", "__", "e").transformMarkup("_", "_", "e").transformMarkup("\\*", "\\*", "e").transformLabels().transformLinks().transformCodeRefs().transformHeading("h1", "chapter").transformHeading("h2", "section").transformHeading("h3", "section2").transformHeading("h4", "section3").transformHeading("h5", "section4").transformParagraphs().transformTables().transformImages().transformNewlines().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransformationBuilder {
        public static final String LABEL_TERMINAL_CHARS = "\\,\\.\\)\\|\\:\\s\\]";
        public static final String HREF_TERMINAL_CHARS = ",\\)\\|\\s\\]";
        private List<Region> regions;

        public TransformationBuilder(String source) {
            this.createRegions(source);
        }

        public TransformationBuilder createRegions(String source) {
            List<String> bcSections = this.findBcSections(source, "^(bc\\.\\. *(.*?))\n((\\p{Alpha}\\p{Alnum}*((\\(\\#)|(\\.\\.? )))|\\Z)", 40);
            bcSections.addAll(this.findBcSections(source, "^(bc\\. *(.*?))$", 40));
            ArrayList bcLocations = Lists.newArrayList();
            for (String bcSection : bcSections) {
                Pair bcLocation = Tuples.create((Object)source.indexOf(bcSection), (Object)bcSection.length());
                if (bcLocations.contains(bcLocation)) continue;
                bcLocations.add(bcLocation);
            }
            Collections.sort(bcLocations, new Comparator<Pair<Integer, Integer>>(){

                @Override
                public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                    return o1.getFirst() != o2.getFirst() ? (Integer)o1.getFirst() - (Integer)o2.getFirst() : (Integer)o2.getSecond() - (Integer)o1.getSecond();
                }
            });
            int currentOffset = 0;
            this.regions = Lists.newArrayList();
            for (Pair bcLocation : bcLocations) {
                if (currentOffset > (Integer)bcLocation.getFirst()) continue;
                if (currentOffset != (Integer)bcLocation.getFirst()) {
                    this.regions.add(new Region(source, currentOffset, (Integer)bcLocation.getFirst() - currentOffset, false));
                }
                Region bcRegion = new Region(source, (Integer)bcLocation.getFirst(), (Integer)bcLocation.getSecond(), true);
                this.regions.add(bcRegion);
                currentOffset = (Integer)bcLocation.getFirst() + (Integer)bcLocation.getSecond();
            }
            if (currentOffset < source.length()) {
                this.regions.add(new Region(source, currentOffset, source.length() - currentOffset, false));
            }
            if (!this.toString().equals(source)) {
                throw new IllegalStateException();
            }
            return this;
        }

        private List<String> findBcSections(String source, String regex, int flags) {
            ArrayList matches = Lists.newArrayList();
            Pattern pattern = Pattern.compile(regex, flags);
            int currentOffset = 0;
            Matcher matcher = pattern.matcher(source);
            while (matcher.find(currentOffset)) {
                matches.add(matcher.group(1));
                currentOffset = matcher.start(1) + 1;
            }
            return matches;
        }

        private TransformationBuilder replaceAllMultiLine(String regex, String replacement) {
            return this.replaceAll(regex, replacement, 40);
        }

        private TransformationBuilder replaceAllSingleLine(String regex, String replacement) {
            return this.replaceAll(regex, replacement, 8);
        }

        private TransformationBuilder replaceAll(String regex, String replacement, int flags) {
            for (Region region : this.regions) {
                if (region.isProtected) continue;
                Matcher matcher = Pattern.compile(regex, flags).matcher(region.content);
                region.content = matcher.replaceAll(replacement);
            }
            return this;
        }

        public TransformationBuilder transformBrackets() {
            for (Region region : this.regions) {
                region.content = region.content.replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
            }
            return this;
        }

        public TransformationBuilder transformHeading(String textileHeading, String xdocHeading) {
            return this.replaceAllSingleLine("^" + textileHeading + "\\(#([^\\)]*)\\)\\.\\s(.*?)\\s*$", "\n" + xdocHeading + ":$1[$2]\n").replaceAllSingleLine("^" + textileHeading + "\\.\\s(.*?)\\s*$", "\n" + xdocHeading + "[$1]\n");
        }

        public TransformationBuilder transformMarkup(String textileStart, String textileEnd, String xdocMarkup) {
            return this.replaceAllSingleLine("(\\s)" + textileStart + "([^" + textileEnd + "\n]*?)" + textileEnd, "$1" + xdocMarkup + "[$2]");
        }

        public TransformationBuilder transformCodeRefs() {
            for (String codeRef : this.findMultiLineMatches("(\\$\\{([^\\}]*)?\\})")) {
                if (!codeRef.contains("/")) continue;
                String javaFQN = codeRef.substring(codeRef.lastIndexOf(47) + 1, codeRef.length() - 1);
                System.out.println(String.valueOf(codeRef) + " -> " + javaFQN);
                this.replaceAllMultiLine(Pattern.quote(codeRef), "codeRef[" + javaFQN + "]");
            }
            return this;
        }

        public TransformationBuilder transformBlocks() {
            for (Region region : this.regions) {
                if (!region.isProtected) continue;
                region.content = String.valueOf(region.content.replaceAll("^bc\\.(\\.)? ", "\n\ncode[Java][")) + "]\n\n";
            }
            return this.replaceAllMultiLine("^bc\\.\\. *(.*?)\n((\\p{Alpha}\\p{Alnum}*(\\(|\\.\\.? ))|\\z)", "code[$1]\n$2").replaceAllMultiLine("^bc\\.\\. *(.*?)\n((\\p{Alpha}\\p{Alnum}*(\\(|\\.\\.? ))|\\z)", "code[$1]\n$2").replaceAllMultiLine("^bc\\. *(.*?)$", "code[$1]\n");
        }

        public TransformationBuilder transformLinks() {
            return this.replaceAllMultiLine("\"([^\"\n]*)\":#([^\\,\\.\\)\\|\\:\\s\\]]*)", "ref:$2[$1]").replaceAllMultiLine("\"([^\"\n]*)\":([^,\\)\\|\\s\\]]*)", "link[$2][$1]");
        }

        public TransformationBuilder transformEnumerations(String textileMarker, String xdocEnvironment) {
            return this.replaceAllMultiLine("((^" + textileMarker + "+ .*?$)+)(^\\s*$|\\z)", String.valueOf(this.todo("revise indentation levels")) + xdocEnvironment + "[\n$1]\n").replaceAllSingleLine("^" + textileMarker + "+ (.*?)$", "item[$1]");
        }

        private String todo(String string) {
            return "todo[" + string + "]\n";
        }

        public TransformationBuilder transformTables() {
            this.replaceAllMultiLine("((^\\|.*?$)+)^ *$", "table[\n$1]\n");
            List<String> tableRows = this.findSingleLineMatches("^(\\|.*?)$");
            for (String tableRow : tableRows) {
                StringBuilder replaceBuffer = new StringBuilder("tr[");
                String[] stringArray = tableRow.substring(1).split("\\|");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String td = stringArray[n2];
                    replaceBuffer.append("td[");
                    String tdContent = Strings.isEmpty((String)td.trim()) ? " " : td.trim();
                    replaceBuffer.append(tdContent);
                    replaceBuffer.append("]");
                    ++n2;
                }
                replaceBuffer.append("]");
                this.replaceAllMultiLine(Pattern.quote(tableRow), replaceBuffer.toString());
            }
            return this;
        }

        public TransformationBuilder transformLabels() {
            List<String> labels = this.findSingleLineMatches("#(\\p{Alpha}[^\\,\\.\\)\\|\\:\\s\\]]*)");
            for (String label : labels) {
                String validLabel;
                if (label.equals(validLabel = label.replaceAll("[^\\p{Alnum}_]", "_"))) continue;
                System.out.println("Changing #" + label + " to #" + validLabel);
                this.replaceAllSingleLine("#" + Pattern.quote(label) + "([" + LABEL_TERMINAL_CHARS + "])", "#" + validLabel + "$1");
            }
            return this;
        }

        public TransformationBuilder transformParagraphs() {
            return this.replaceAllMultiLine("^p\\.\\s*", "");
        }

        public TransformationBuilder transformNewlines() {
            return this.replaceAllMultiLine("\\A\\n*", "").replaceAllMultiLine("^\\s+$", "\n").replaceAllMultiLine("\n*\\z", "");
        }

        public TransformationBuilder transformImages() {
            return this.replaceAllMultiLine("^\\!(\\{([^\\}]*)\\})?([^\\!]*?)(\\([^\\)]*?\\))?!$", "img[$3][ ][ $2][ $4]\n");
        }

        private List<String> findMatches(String regex, int flags) {
            ArrayList matches = Lists.newArrayList();
            for (Region region : this.regions) {
                if (region.isProtected) continue;
                Pattern pattern = Pattern.compile(regex, flags);
                int currentStart = 0;
                Matcher matcher = pattern.matcher(region.content);
                while (matcher.find(currentStart)) {
                    matches.add(matcher.group(1));
                    currentStart = matcher.start(1) + 1;
                }
            }
            return matches;
        }

        private List<String> findMultiLineMatches(String regex) {
            return this.findMatches(regex, 40);
        }

        private List<String> findSingleLineMatches(String regex) {
            return this.findMatches(regex, 8);
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            for (Region region : this.regions) {
                r.append(region.content);
            }
            return r.toString();
        }

        class Region {
            boolean isProtected;
            private String content;

            Region(String document, int offset, int length, boolean isBlock) {
                this.content = document.substring(offset, offset + length);
                this.isProtected = isBlock;
            }
        }
    }
}

